package com.ejianc.business.pro.supplier.utils;

import com.alibaba.fastjson.JSONObject;
import com.baidu.aip.ocr.AipOcr;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

import static java.lang.System.out;

@Component
public class OuterInterface {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${outInterface.baidu.AppID}")
    private String baiduAppId;
    @Value("${outInterface.baidu.APIKey}")
    private String baiduApiKey;
    @Value("${outInterface.baidu.SecretKey}")
    private String baiduSecretKey;

    @Value("${outInterface.qichacha.key}")
    private String qichachaKey;
    @Value("${outInterface.qichacha.SecretKey}")
    private String qichachaSecretKey;


    @Value("${outInterface.aliyun.AppKey}")
    private String aliyunAppKey;
    @Value("${outInterface.aliyun.AppSecret}")
    private String aliyunAppSecret;
    @Value("${outInterface.aliyun.AppCode}")
    private String aliyunAppCode;


    // 初始化一个百度OCR客户端 AipOcr
    private AipOcr client;

    private AipOcr getClient() {
        if(client == null){
            client = new AipOcr(baiduAppId, baiduApiKey, baiduSecretKey);
        }
        return client;
    }

    /**
     * 识别营业执照照片信息 通过百度
     * @param imageUrl
     * @return
     */
    public JSONObject getBusinessLicenseInfoFromBaidu(String imageUrl){
        org.json.JSONObject object = getClient().businessLicense(getImageFromURL(imageUrl),new HashMap<>());

        if(object.has("error_code")){
            logger.error("营业执照识别失败！{}",JSONObject.toJSONString(object));
            throw new BusinessException("营业执照识别失败！未识别到内容，请确认您上传了清晰的营业执照照片！");
        }

        JSONObject res = new JSONObject();
        int wordsResultNum = object.getInt("words_result_num");
        if(wordsResultNum == 0){
            throw new BusinessException("营业执照识别失败！未识别到内容，请确认您上传了清晰的营业执照照片！");
        }
        org.json.JSONObject wordsResult = object.getJSONObject("words_result");
        if(wordsResult.has("单位名称")){
            String words = wordsResult.getJSONObject("单位名称").getString("words");
            if(!"无".equals(words)){
                res.put("name",words);
            }
        }
        if(wordsResult.has("经营范围")){
            String words = wordsResult.getJSONObject("经营范围").getString("words");
            if(!"无".equals(words)){
                res.put("businessRange",words);
            }
        }
        if(wordsResult.has("社会信用代码")){
            String words = wordsResult.getJSONObject("社会信用代码").getString("words");
            if(!"无".equals(words)){
                res.put("taxpayerNum",words);
            }
        }
        if(wordsResult.has("地址")){
            String words = wordsResult.getJSONObject("地址").getString("words");
            if(!"无".equals(words)){
                res.put("address",words);
            }
        }
        if(wordsResult.has("法人")){
            String words = wordsResult.getJSONObject("法人").getString("words");
            if(!"无".equals(words)){
                res.put("legalPerson",words);
            }
        }
//        if(wordsResult.has("注册资本")){
//            String words = wordsResult.getJSONObject("注册资本").getString("words");
//            if(!"无".equals(words)){
//                BigDecimal registerMny = null;
//                if(words.contains("万元")){
//                    registerMny = new BigDecimal(words.substring(0,words.length()-3)+"0000");
//                }else if(words.contains("元")){
//                    registerMny = new BigDecimal(words.substring(0,words.length()-2));
//                }else {
//                    registerMny = new BigDecimal(words);
//                }
//                res.put("registerMny",registerMny);
//            }
//        }
        if(wordsResult.has("有效期")){
            String words = wordsResult.getJSONObject("有效期").getString("words");
            if(!"无".equals(words) && !"长期".equals(words)){
                String timeOut = null;
                try {
                    timeOut = DateFormatUtil.formatDate("yyyy-MM-dd",DateFormatUtil.parseDate("yyyy年MM月dd日",words));
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                res.put("timeOut",timeOut);
            }
        }
        if(wordsResult.has("成立日期")){
            String words = wordsResult.getJSONObject("成立日期").getString("words");
            if(!"无".equals(words)){
                String registerDate = null;
                try {
                    registerDate = DateFormatUtil.formatDate("yyyy-MM-dd",DateFormatUtil.parseDate("yyyy年MM月dd日",words));
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                res.put("registerDate",registerDate);
            }
        }
        res.put("ocrJsonStr",JSONObject.toJSONString(wordsResult));
        return res;
    }

    /**
     * 识别身份证照片信息 通过百度
     * @param imageUrl
     * @return
     */
    public JSONObject getIdCardInfoFromBaidu(String imageUrl){
        org.json.JSONObject object = getClient().idcard(getImageFromURL(imageUrl),"front",new HashMap<>());

        if(object.has("error_code")){
            logger.error("身份证识别失败！{}",JSONObject.toJSONString(object));
            throw new BusinessException("身份证识别失败！未识别到内容，请确认您上传了清晰的身份证照片！");
        }

        JSONObject res = new JSONObject();
        int wordsResultNum = object.getInt("words_result_num");
        if(wordsResultNum == 0){
            throw new BusinessException("身份证识别失败！未识别到内容，请确认您上传了清晰的身份证照片！");
        }
        org.json.JSONObject wordsResult = object.getJSONObject("words_result");
        if(wordsResult.has("姓名")){
            String words = wordsResult.getJSONObject("姓名").getString("words");
            if(!"无".equals(words)){
                res.put("name",words);
            }
        }
        if(wordsResult.has("公民身份号码")){
            String words = wordsResult.getJSONObject("公民身份号码").getString("words");
            if(!"无".equals(words)){
                res.put("taxpayerNum",words);
            }
        }
        if(wordsResult.has("住址")){
            String words = wordsResult.getJSONObject("住址").getString("words");
            if(!"无".equals(words)){
                res.put("address",words);
            }
        }
        if(wordsResult.has("姓名")){//法人
            String words = wordsResult.getJSONObject("姓名").getString("words");
            if(!"无".equals(words)){
                res.put("legalPerson",words);
            }
        }
        if(wordsResult.has("失效日期")){
            String words = wordsResult.getJSONObject("失效日期").getString("words");
            if(!"无".equals(words) && !"长期".equals(words)){
                String timeOut = null;
                try {
                    timeOut = DateFormatUtil.formatDate("yyyy-MM-dd",DateFormatUtil.parseDate("yyyyMMdd",words));
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                res.put("timeOut",timeOut);
            }
        }
        if(wordsResult.has("出生")){
            String words = wordsResult.getJSONObject("出生").getString("words");
            if(!"无".equals(words)){
                String registerDate = null;
                try {
                    registerDate = DateFormatUtil.formatDate("yyyy-MM-dd",DateFormatUtil.parseDate("yyyyMMdd",words));
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                res.put("registerDate",registerDate);
            }
        }
        res.put("ocrJsonStr",JSONObject.toJSONString(wordsResult));
        return res;
    }


    private static byte[] getImageFromURL(String urlPath) {
        byte[] data = null;
        InputStream is = null;
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlPath);
            conn = (HttpURLConnection) url.openConnection();
            conn.setDoInput(true);
            // conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(6000);
            is = conn.getInputStream();
            if (conn.getResponseCode() == 200) {
                data = readInputStream(is);
            } else{
                data=null;
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("营业执照识别失败！");
        } finally {
            try {
                if(is != null){
                    is.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            conn.disconnect();
        }
        return data;
    }

    /**
     * 从输入流中获取数据
     * @param inStream 输入流
     * @return
     * @throws Exception
     */
    private static byte[] readInputStream(InputStream inStream) throws Exception{
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while( (len=inStream.read(buffer)) != -1 ){
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }


    /** 企查查相关代码 开始*********************************************************************************************************/
    /**
     * 根据企业名称和社会信用代码
     * 校验企业信息是否通过 通过企查查
     * @param name 企业名称
     * @param code 社会信用代码
     * @return
     */
    public boolean checkEnterpriseFromQcc(String name,String code){
        String reqInterNme = "http://api.qichacha.com/ECITwoElVerify/GetInfo";
        String paramStr = "creditCode="+code+"&verifyName="+name+"&verifyType=1";
        try {
            HttpHead reqHeader = new HttpHead();
            String[] autherHeader = randomAuthentHeader();
            reqHeader.setHeader("Token", autherHeader[0]);
            reqHeader.setHeader("Timespan", autherHeader[1]);
            final String reqUri = reqInterNme.concat("?key=").concat(qichachaKey).concat("&").concat(paramStr);
            String tokenJson = HttpHelper.httpGet(reqUri, reqHeader.getAllHeaders());
            JSONObject res = formatJson(tokenJson);
            if(res.getInteger("Status") == 200){
                if(res.getJSONObject("Result").getInteger("VerifyResult") == 1){//校验一致
                    return true;
                }else if(res.getJSONObject("Result").getInteger("VerifyResult") == 0){
                    throw new BusinessException("企业校验失败！统一社会信用代码有误!");
                }else {
                    throw new BusinessException("企业校验失败！统一社会信用代码和企业名称不一致!");
                }
            }else {
                throw new BusinessException("企业校验失败！"+res.getString("Message"));
            }
        } catch (Exception e1) {
            logger.error("企查查接口企业校验失败：{}",e1.getMessage());
            throw new BusinessException(e1.getMessage());
        }
    }

    // 获取Auth Code
    protected  final String[] randomAuthentHeader() {
        String timeSpan = String.valueOf(System.currentTimeMillis() / 1000);
        return new String[] { DigestUtils.md5Hex(qichachaKey.concat(timeSpan).concat(qichachaSecretKey)).toUpperCase(), timeSpan };
    }

    // pretty print 返回值
    protected JSONObject formatJson(String jsonString) throws JSONException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object obj = mapper.readValue(jsonString, Object.class);
            String indented = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            out.println("*****************indented===="+indented);
            return JSONObject.parseObject(indented);
        } catch (Exception e) {
            logger.error("企查查接口返回：{}",jsonString);
           throw new BusinessException("企业校验失败！接口返回信息格式不对！");
        }
    }
    /** 企查查相关代码 结束**************************************************************************************/

    /** 阿里云api相关代码 开始**************************************************************************************/
    public boolean checkPersonFromAly(String name,String code){
        String host = "http://checkone.market.alicloudapi.com";
        String path = "/chinadatapay/1882";
        String method = "POST";
        Map<String, String> headers = new HashMap<String, String>();
        //最后在header中的格式(中间是英文空格)为Authorization:APPCODE 83359fd73fe94948385f570e3c139105
        headers.put("Authorization", "APPCODE " + aliyunAppCode);
        //根据API的要求，定义相对应的Content-Type
        headers.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        Map<String, String> querys = new HashMap<String, String>();
        Map<String, String> bodys = new HashMap<String, String>();
        bodys.put("idcard", code);
        bodys.put("name", name);

        try {
            logger.info("阿里校验身份信息：host---{}, path---{}，bodys---{}",host, path,JSONObject.toJSONString(bodys));
            HttpResponse response = HttpHelper.doPost(host, path, method, headers, querys, bodys);
            JSONObject res = JSONObject.parseObject(EntityUtils.toString(response.getEntity()));
            logger.info(name+"  "+code+"身份信息校验结果：{}",res);
            if(res!=null && res.getInteger("code") == 10000){
                if(res.getJSONObject("data").getInteger("result") == 1){//校验一致
                    return true;
                }else {
                    throw new BusinessException("身份证信息未校验通过！");
                }
            }else {
                throw new BusinessException("身份证信息未校验通过！");
            }
        } catch (Exception e) {
            logger.error("识别出错",e);
            e.printStackTrace();
            throw new BusinessException("身份证信息未校验通过！");
        }
    }
    /** 阿里云api相关代码 结束**************************************************************************************/


}
