/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller.appraise;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.service.appraise.AppraiseService;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"appraise"})
public class AppraiseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    AppraiseService appraiseService;
    private static String RULE_CODE = "P-k202Ay57";
    @Autowired
    IParamConfigApi paramConfigApi;

    @PostMapping(value={"/pushIncidentAppraiseAnnually"})
    public CommonResponse<String> pushIncidentAppraiseAnnually(HttpServletRequest request) {
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        this.logger.info("\u4f9b\u5e94\u5546\u8fc7\u7a0b\u8bc4\u4ef7\u5e74\u5ea6\u63a8\u9001\u4efb\u52a1\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)appraiseParamVO));
        CommonResponse byCode = this.paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff0c\u89c4\u5219\u7f16\u7801:{}", (Object)RULE_CODE);
            return CommonResponse.success((String)"\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff01");
        }
        appraiseParamVO.setRuleName(((ParamRegisterSetVO)byCode.getData()).getValueData());
        this.appraiseService.pushIncidentAppraiseAnnually(appraiseParamVO);
        return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u8fc7\u7a0b\u8bc4\u4ef7\u5e74\u5ea6\u63a8\u9001\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01");
    }

    @PostMapping(value={"/pushProcessAppraise"})
    public CommonResponse<AppraiseResultVO> pushProcessAppraise(HttpServletRequest request) {
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        CommonResponse byCode = this.paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff0c\u89c4\u5219\u7f16\u7801:{}", (Object)RULE_CODE);
            return CommonResponse.success((String)"\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff01");
        }
        String ruleName = ((ParamRegisterSetVO)byCode.getData()).getValueData();
        this.logger.info("\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff0c\u89c4\u5219\u540d\u79f0:{}", (Object)ruleName);
        appraiseParamVO.setRuleName(ruleName);
        AppraiseResultVO appraiseResultVO = this.appraiseService.pushProcessAppraise(appraiseParamVO);
        return CommonResponse.success((Object)appraiseResultVO);
    }

    private AppraiseParamVO getParamVO(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        JSONArray parameters = json.getJSONObject(0).getJSONArray("parameters");
        AppraiseParamVO appraiseParamVO = new AppraiseParamVO();
        for (int i = 0; i < parameters.size(); ++i) {
            JSONObject obj = parameters.getJSONObject(i);
            String property = (String)obj.get((Object)"property");
            if ("contractMny".equalsIgnoreCase(property)) {
                appraiseParamVO.setContractMny(obj.getBigDecimal("value"));
                continue;
            }
            if ("settleContractRatio".equalsIgnoreCase(property)) {
                appraiseParamVO.setSettleContractRatio(obj.getBigDecimal("value"));
                continue;
            }
            if ("spaceLastDays".equalsIgnoreCase(property)) {
                appraiseParamVO.setSpaceLastDays(obj.getInteger("value"));
                continue;
            }
            if ("yearPushDate".equalsIgnoreCase(property)) {
                appraiseParamVO.setYearPushDate(obj.getString("value"));
                continue;
            }
            if (!"contractType".equalsIgnoreCase(property)) continue;
            appraiseParamVO.setContractType(obj.getString("value"));
        }
        return appraiseParamVO;
    }

    @PostMapping(value={"/pushYearAppraise"})
    public CommonResponse<AppraiseResultVO> pushYearAppraise(HttpServletRequest request) {
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        CommonResponse byCode = this.paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff0c\u89c4\u5219\u7f16\u7801:{}", (Object)RULE_CODE);
            return CommonResponse.success((String)"\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff01");
        }
        appraiseParamVO.setRuleName(((ParamRegisterSetVO)byCode.getData()).getValueData());
        AppraiseResultVO appraiseResultVO = this.appraiseService.pushYearAppraise(appraiseParamVO);
        return CommonResponse.success((Object)appraiseResultVO);
    }
}

