package com.ejianc.business.pro.supplier.controller;

import com.ejianc.business.pro.supplier.service.ISupplierStatisticsService;
import com.ejianc.business.pro.supplier.vo.CooperateSourceBliVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 协同分析
 *
 * @author 姜轶凯
 */
@Controller
@RequestMapping("/supplierStatistics")
public class SupplierStatisticsController {


    @Autowired
    private ISupplierStatisticsService supplierStatisticsService;


    /**
     * @param supplierId
     * @Description cooperateAnalysis 查询协同分析
     */
    @RequestMapping(value = "/cooperateAnalysis", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse <List<CooperateSourceBliVO>> cooperateAnalysis(Long supplierId, String dateIn) {
        CommonResponse<List<CooperateSourceBliVO>> response= supplierStatisticsService.cooperateAnalysis(supplierId,dateIn);
        return response;
    }

}
