package com.ejianc.business.pro.supplier.service.appraise;

import com.ejianc.business.pro.supplier.vo.IncidentVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;

import java.util.List;
/**
 * 推送过程评价-逻辑接口
 */
public interface PushProcessLogic {
    /**
     * 推送过程评价 逻辑一
     * @param appraiseParamVO
     * @return  List<IncidentVO>
     */
    public List<IncidentVO> logicOne(AppraiseParamVO appraiseParamVO);
    /**
     * 推送过程评价 逻辑二
     * @param appraiseParamVO
     * @return  List<IncidentVO>
     */
    public List<IncidentVO> logicTwo(AppraiseParamVO appraiseParamVO);

    /**
     * 供应商过程评价年度推送
     *
     * @param appraiseParamVO
     * @return
     */
    List<IncidentVO> getAnnualIncidentPushList(AppraiseParamVO appraiseParamVO, String startDate);
}
