package com.ejianc.business.pro.supplier.controller.report;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.bean.PunishEntity;
import com.ejianc.business.pro.supplier.consts.SupplyQueryTypeUrlEnum;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.pro.supplier.vo.IncidentVO;
import com.ejianc.business.pro.supplier.vo.PunishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 供应商报表
 */
@RestController
@RequestMapping("supplierReport")
public class SupplierReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IPunishService service;
    @Autowired
    private IIncidentService incidentService;

    @Autowired
    private IGradeService gradeService;

    @Autowired
    private IDefdocApi defdocApi;

    private static String PUNISH_REASON_CODE = "pro-supply-deal-reason";

    /**
     * @param param
     * @Description punishList 处置列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/punishList", method = RequestMethod.POST)
    public CommonResponse<IPage<PunishVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getFuzzyFields().add("supplyTypeName");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));

        param.getOrderMap().put("applyDate", QueryParam.DESC);
        IPage<PunishEntity> page = service.queryPage(param, false);

        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));

        CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentIdWithoutProjectDept(orgId);
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        IPage<PunishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PunishVO> punishVOS = BeanMapper.mapList(page.getRecords(), PunishVO.class);
        if (CollectionUtils.isNotEmpty(punishVOS)) {
            Map<Long, String> defMap = new HashMap<>();
            CommonResponse<List<DefdocDetailVO>> defDocByDefCode = defdocApi.getDefDocByDefCode(PUNISH_REASON_CODE);
            if(defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty(defDocByDefCode.getData())){
                defMap = defDocByDefCode.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getName));
            }
            Map<Long, Integer> gradeMap = new HashMap<>();
            List<GradeEntity> list = gradeService.list();
            if (CollectionUtils.isNotEmpty(list)){
                gradeMap = list.stream().collect(Collectors.toMap(GradeEntity::getId, GradeEntity::getWeight, (key1, key2) -> key2));
            }

            for (PunishVO t : punishVOS) {
                Long oldGrade = t.getOldGrade();
                Long gradeId = t.getGradeId();
                Integer oldWeight = gradeMap.get(oldGrade) == null ? 0 : gradeMap.get(oldGrade);
                Integer weight = gradeMap.get(gradeId) == null ? 0 : gradeMap.get(gradeId);
                t.setIsLower(weight < oldWeight ? "是" : "否");
                t.setUrl("/ejc-prosupplier-frontend/#/punish/card?id=" + t.getId());
                t.setClickable(orgIdList.contains(t.getApplyOrgId()) ? Boolean.TRUE : Boolean.FALSE);
                t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
                t.setMemo(defMap.get(t.getReason()));
            }

        }
        pageData.setRecords(punishVOS);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出处置记录
     * @Return void
     */
    @RequestMapping(value = "/excelPunishExport", method = RequestMethod.POST)
    public void excelPunishExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getFuzzyFields().add("supplyTypeName");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));

        param.getOrderMap().put("applyDate", QueryParam.DESC);
        List<PunishEntity> punishEntityList = service.queryList(param);
        List<PunishVO> punishVOS = BeanMapper.mapList(punishEntityList, PunishVO.class);
        if (CollectionUtils.isNotEmpty(punishVOS)) {
            Map<Long, String> defMap = new HashMap<>();
            CommonResponse<List<DefdocDetailVO>> defDocByDefCode = defdocApi.getDefDocByDefCode(PUNISH_REASON_CODE);
            if(defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty(defDocByDefCode.getData())){
                defMap = defDocByDefCode.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getName));
            }
            Map<Long, Integer> gradeMap = new HashMap<>();
            List<GradeEntity> list = gradeService.list();
            if (CollectionUtils.isNotEmpty(list)){
                gradeMap = list.stream().collect(Collectors.toMap(GradeEntity::getId, GradeEntity::getWeight, (key1, key2) -> key2));
            }
            for (PunishVO t : punishVOS) {
                Long oldGrade = t.getOldGrade();
                Long gradeId = t.getGradeId();
                Integer oldWeight = gradeMap.get(oldGrade) == null ? 0 : gradeMap.get(oldGrade);
                Integer weight = gradeMap.get(gradeId) == null ? 0 : gradeMap.get(gradeId);
                t.setIsLower(weight < oldWeight ? "是" : "否");
                t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
                t.setMemo(defMap.get(t.getReason()));
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", punishVOS);
        ExcelExport.getInstance().export("supplier-report-punish-export.xlsx", beans, response);
    }


    @RequestMapping(value = "/appraiseList", method = RequestMethod.POST)
    public CommonResponse<IPage<IncidentVO>> appraiseList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("orgName");
        fuzzyFields.add("appraiseType");
        fuzzyFields.add("sourceType");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));

        CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentIdWithoutProjectDept(orgId);
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));

        param.getOrderMap().put("date", QueryParam.DESC);

        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<IncidentVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<IncidentVO> list = incidentService.queryAppraiseList(page, wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(
                    t -> {
                        t.setUrl("/ejc-prosupplier-frontend/#" + SupplyQueryTypeUrlEnum.getUrl(t.getAppraiseType() + t.getSupplyQueryType()) + t.getId());
                        t.setClickable(orgIdList.contains(t.getOrgId()) ? Boolean.TRUE : Boolean.FALSE);
                    }
            );
        }
        page.setTotal(page.getTotal());
        page.setRecords(list);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description 导出处置记录
     * @Return void
     */
    @RequestMapping(value = "/excelAppraiseExport", method = RequestMethod.POST)
    public void excelAppraiseExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("appraiseType");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));

        param.getOrderMap().put("date", QueryParam.DESC);

        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<IncidentVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<IncidentVO> list = incidentService.queryAppraiseList(page, wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(
                    t -> t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription())
            );
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("supplier-report-appraise-export.xlsx", beans, response);
    }

}
