/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.bean.LimitEntity;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractIncidentEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractProcessEntity;
import com.ejianc.business.pro.supplier.bean.YearEntity;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.ILimitService;
import com.ejianc.business.pro.supplier.service.ISubleaderCanInSubService;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.business.pro.supplier.vo.appraise.CalRuleVo;
import com.ejianc.business.pro.supplier.vo.appraise.ContVo;
import com.ejianc.business.pro.supplier.vo.appraise.ProjectBaseVo;
import com.ejianc.business.pro.supplier.vo.appraise.ProjectSubVo;
import com.ejianc.business.pro.supplier.vo.appraise.SubContVo;
import com.ejianc.business.pro.supplier.vo.appraise.SupplyBaseVo;
import com.ejianc.business.pro.supplier.vo.appraise.SupplySubVo;
import com.ejianc.business.pro.supplier.vo.appraise.TypeBaseVo;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.api.IShareSubleadersApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.google.common.collect.HashBasedTable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="yearAppraiseService")
public class YearAppraiseService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "YEAY_EVALUATE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAbnormalService abnormalService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    IProSupplierApi proSupplierApi;
    @Autowired
    private IYearService yearService;
    @Autowired
    private ILimitService limitService;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private ISubleaderCanInSubService subleaderCanInSubService;
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareSubleadersApi shareSubleadersApi;
    private static final BigDecimal level1 = new BigDecimal(-10L);
    private static final BigDecimal level2 = new BigDecimal(-20L);
    private static final BigDecimal level3 = new BigDecimal(-30L);

    public String getStartDate(AppraiseParamVO appraiseParamVO) {
        String nowDateStr = DateUtil.format(new Date(), "yyyy-MM-dd");
        String substring = nowDateStr.substring(5, 10);
        if (!appraiseParamVO.getYearPushDate().equals(substring)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.isNotNull((Object)"old_start_date");
        wrapper.orderByDesc((Object)"create_time");
        List list = this.yearService.list((Wrapper)wrapper);
        if (list.size() != 0) {
            Date createTime = ((YearEntity)((Object)list.get(0))).getCreateTime();
            return DateUtil.format(createTime, "yyyy-MM-dd");
        }
        Integer startYear = DateUtil.getYear() - 1;
        return startYear + "-" + appraiseParamVO.getYearPushDate();
    }

    public Map<Long, SupplySubVo> sumSubGrade(List<ProcessEntity> processList, List<IncidentEntity> incidentList) {
        ProjectSubVo projectSubVo1;
        ProjectSubVo projectSubVo;
        Map projectMap;
        SupplySubVo supplySubVo1;
        HashMap<Long, ProjectSubVo> projectSubMap;
        String entityStr;
        String supplySubVoStr;
        SupplySubVo supplySubVo;
        HashMap<Long, SupplySubVo> supplySubMap = new HashMap<Long, SupplySubVo>();
        for (ProcessEntity processEntity : processList) {
            supplySubVo = (SupplySubVo)supplySubMap.get(processEntity.getSupplyId());
            this.logger.info("ProcessEntity");
            this.logger.info(processEntity.getId().toString());
            this.logger.info(processEntity.getSupplyId() + "" + processEntity.getBuckleBranch());
            processEntity.setBuckleBranch(null == processEntity.getBuckleBranch() ? BigDecimal.ZERO : processEntity.getBuckleBranch());
            supplySubVoStr = JSONObject.toJSONString((Object)supplySubVo);
            this.logger.info("supplySubVoStr:" + supplySubVoStr);
            entityStr = JSONObject.toJSONString((Object)((Object)processEntity));
            this.logger.info("entityStr:" + entityStr);
            if (null == supplySubVo) {
                ProjectSubVo projectSubVo12 = new ProjectSubVo();
                projectSubVo12.setPrijectId(processEntity.getProjectId());
                projectSubVo12.setSubGrade(processEntity.getBuckleBranch());
                projectSubMap = new HashMap<Long, ProjectSubVo>();
                projectSubMap.put(processEntity.getProjectId(), projectSubVo12);
                supplySubVo1 = new SupplySubVo();
                supplySubVo1.setSupplyId(processEntity.getSupplyId());
                supplySubVo1.setSubGrade(processEntity.getBuckleBranch());
                supplySubVo1.setProjectMap(projectSubMap);
                supplySubVo1.setSjSubGrade(processEntity.getBuckleBranch());
                supplySubVo1.setGcSubGrade(BigDecimal.ZERO);
                supplySubMap.put(processEntity.getSupplyId(), supplySubVo1);
                continue;
            }
            projectMap = supplySubVo.getProjectMap();
            projectSubVo = (ProjectSubVo)projectMap.get(processEntity.getProjectId());
            if (null == projectSubVo) {
                projectSubVo1 = new ProjectSubVo();
                projectSubVo1.setPrijectId(processEntity.getProjectId());
                projectSubVo1.setSubGrade(processEntity.getBuckleBranch());
                projectMap.put(processEntity.getProjectId(), projectSubVo1);
                supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(processEntity.getBuckleBranch()));
                supplySubVo.setSjSubGrade(supplySubVo.getSjSubGrade().add(processEntity.getBuckleBranch()));
                continue;
            }
            projectSubVo.setSubGrade(projectSubVo.getSubGrade().add(processEntity.getBuckleBranch()));
            supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(processEntity.getBuckleBranch()));
            supplySubVo.setSjSubGrade(supplySubVo.getSjSubGrade().add(processEntity.getBuckleBranch()));
        }
        for (IncidentEntity incidentEntity : incidentList) {
            supplySubVo = (SupplySubVo)supplySubMap.get(incidentEntity.getSupplyId());
            this.logger.info("IncidentEntity");
            this.logger.info(incidentEntity.getId().toString());
            this.logger.info(incidentEntity.getSupplyId() + "" + incidentEntity.getBuckleBranch());
            incidentEntity.setBuckleBranch(null == incidentEntity.getBuckleBranch() ? BigDecimal.ZERO : incidentEntity.getBuckleBranch());
            supplySubVoStr = JSONObject.toJSONString((Object)supplySubVo);
            this.logger.info("supplySubVoStr:" + supplySubVoStr);
            entityStr = JSONObject.toJSONString((Object)((Object)incidentEntity));
            this.logger.info("entityStr:" + entityStr);
            if (null == supplySubVo) {
                ProjectSubVo projectSubVo12 = new ProjectSubVo();
                projectSubVo12.setPrijectId(incidentEntity.getProjectId());
                projectSubVo12.setSubGrade(incidentEntity.getBuckleBranch());
                projectSubMap = new HashMap();
                projectSubMap.put(incidentEntity.getProjectId(), projectSubVo12);
                supplySubVo1 = new SupplySubVo();
                supplySubVo1.setSupplyId(incidentEntity.getSupplyId());
                supplySubVo1.setSubGrade(incidentEntity.getBuckleBranch());
                supplySubVo1.setGcSubGrade(incidentEntity.getBuckleBranch());
                supplySubVo1.setProjectMap(projectSubMap);
                supplySubMap.put(incidentEntity.getSupplyId(), supplySubVo1);
                continue;
            }
            projectMap = supplySubVo.getProjectMap();
            projectSubVo = (ProjectSubVo)projectMap.get(incidentEntity.getProjectId());
            if (null == projectSubVo) {
                projectSubVo1 = new ProjectSubVo();
                projectSubVo1.setPrijectId(incidentEntity.getProjectId());
                projectSubVo1.setSubGrade(incidentEntity.getBuckleBranch());
                projectMap.put(incidentEntity.getProjectId(), projectSubVo1);
                supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(incidentEntity.getBuckleBranch()));
                supplySubVo.setGcSubGrade(supplySubVo.getGcSubGrade().add(incidentEntity.getBuckleBranch()));
                continue;
            }
            projectSubVo.setSubGrade(projectSubVo.getSubGrade().add(incidentEntity.getBuckleBranch()));
            supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(incidentEntity.getBuckleBranch()));
            supplySubVo.setGcSubGrade(supplySubVo.getGcSubGrade().add(incidentEntity.getBuckleBranch()));
        }
        return supplySubMap;
    }

    public Map<Long, SupplyBaseVo> getSupplyResult(String rule, List<ContractDTO> dtos) {
        HashMap<Long, SupplyBaseVo> supplyBaseMap = new HashMap<Long, SupplyBaseVo>();
        for (ContractDTO dto : dtos) {
            HashMap<Long, ContractDTO> contractMap;
            ProjectBaseVo projectBaseVo;
            HashMap<Long, ProjectBaseVo> projectMap;
            String contractType = SupplyQueryTypeUtil.get((String)rule, (String)dto.getContractType());
            SupplyBaseVo supplyBaseVo = (SupplyBaseVo)supplyBaseMap.get(dto.getSupplyId());
            if (null == supplyBaseVo) {
                HashMap<Long, ContractDTO> contractMap2 = new HashMap<Long, ContractDTO>();
                contractMap2.put(dto.getContractId(), dto);
                ProjectBaseVo projectBaseVo2 = new ProjectBaseVo();
                projectBaseVo2.setProjectId(dto.getProjectId());
                projectBaseVo2.setSupplyId(dto.getSupplyId());
                projectBaseVo2.setProjectMny(dto.getContractTaxMny());
                projectBaseVo2.setContracts(contractMap2);
                projectMap = new HashMap<Long, ProjectBaseVo>();
                projectMap.put(dto.getProjectId(), projectBaseVo2);
                TypeBaseVo typeBaseVo = new TypeBaseVo();
                typeBaseVo.setContractType(contractType);
                typeBaseVo.setContractDetailType(dto.getContractType());
                typeBaseVo.setSupplyId(dto.getSupplyId());
                typeBaseVo.setTypeMny(dto.getContractTaxMny());
                typeBaseVo.setProjectMap(projectMap);
                HashMap<String, TypeBaseVo> typeMap = new HashMap<String, TypeBaseVo>();
                typeMap.put(contractType, typeBaseVo);
                SupplyBaseVo supplyBaseVo1 = new SupplyBaseVo();
                supplyBaseVo1.setSumMny(dto.getContractTaxMny());
                supplyBaseVo1.setSupplyId(dto.getSupplyId());
                supplyBaseVo1.setTypeBaseMap(typeMap);
                supplyBaseVo1.setCount(Integer.valueOf(1));
                supplyBaseVo1.addProjectIds(dto.getProjectId());
                supplyBaseMap.put(supplyBaseVo1.getSupplyId(), supplyBaseVo1);
                continue;
            }
            Map typeBaseMap = supplyBaseVo.getTypeBaseMap();
            TypeBaseVo typeBaseVo = (TypeBaseVo)typeBaseMap.get(contractType);
            if (null == typeBaseVo) {
                HashMap<Long, ContractDTO> contractMap3 = new HashMap<Long, ContractDTO>();
                contractMap3.put(dto.getContractId(), dto);
                projectBaseVo = new ProjectBaseVo();
                projectBaseVo.setProjectId(dto.getProjectId());
                projectBaseVo.setSupplyId(dto.getSupplyId());
                projectBaseVo.setProjectMny(dto.getContractTaxMny());
                projectBaseVo.setContracts(contractMap3);
                HashMap<Long, ProjectBaseVo> projectMap2 = new HashMap<Long, ProjectBaseVo>();
                projectMap2.put(dto.getProjectId(), projectBaseVo);
                TypeBaseVo typeBaseVo1 = new TypeBaseVo();
                typeBaseVo1.setContractType(contractType);
                typeBaseVo1.setContractDetailType(dto.getContractType());
                typeBaseVo1.setSupplyId(dto.getSupplyId());
                typeBaseVo1.setTypeMny(dto.getContractTaxMny());
                typeBaseVo1.setProjectMap(projectMap2);
                typeBaseMap.put(contractType, typeBaseVo1);
                supplyBaseVo.setTypeBaseMap(typeBaseMap);
                supplyBaseVo.setSumMny(supplyBaseVo.getSumMny().add(dto.getContractTaxMny()));
                supplyBaseVo.addProjectIds(dto.getProjectId());
                supplyBaseVo.setCount(Integer.valueOf(supplyBaseVo.getCount() + 1));
                continue;
            }
            projectMap = typeBaseVo.getProjectMap();
            projectBaseVo = (ProjectBaseVo)projectMap.get(dto.getProjectId());
            if (null == projectBaseVo) {
                contractMap = new HashMap<Long, ContractDTO>();
                contractMap.put(dto.getContractId(), dto);
                ProjectBaseVo projectBaseVo1 = new ProjectBaseVo();
                projectBaseVo1.setProjectId(dto.getProjectId());
                projectBaseVo1.setSupplyId(dto.getSupplyId());
                projectBaseVo1.setContracts(contractMap);
                projectBaseVo1.setProjectMny(dto.getContractTaxMny());
                projectMap.put(dto.getProjectId(), projectBaseVo1);
                typeBaseVo.setProjectMap(projectMap);
                typeBaseVo.setTypeMny(typeBaseVo.getTypeMny().add(dto.getContractTaxMny()));
                supplyBaseVo.setSumMny(supplyBaseVo.getSumMny().add(dto.getContractTaxMny()));
                supplyBaseVo.addProjectIds(dto.getProjectId());
                supplyBaseVo.setCount(Integer.valueOf(supplyBaseVo.getCount() + 1));
                continue;
            }
            contractMap = projectBaseVo.getContracts();
            contractMap.put(dto.getContractId(), dto);
            projectBaseVo.setContracts(contractMap);
            projectBaseVo.setProjectMny(projectBaseVo.getProjectMny().add(dto.getContractTaxMny()));
            typeBaseVo.setTypeMny(typeBaseVo.getTypeMny().add(dto.getContractTaxMny()));
            supplyBaseVo.setSumMny(typeBaseVo.getTypeMny().add(dto.getContractTaxMny()));
            supplyBaseVo.addProjectIds(dto.getProjectId());
            supplyBaseVo.setCount(Integer.valueOf(supplyBaseVo.getCount() + 1));
        }
        return supplyBaseMap;
    }

    public TypeBaseVo getMaxType(SupplyBaseVo supplyBaseVo) {
        Map typeBaseMap = supplyBaseVo.getTypeBaseMap();
        BigDecimal maxMny = BigDecimal.ZERO;
        TypeBaseVo resultVo = new TypeBaseVo();
        for (TypeBaseVo vo : typeBaseMap.values()) {
            if (vo.getTypeMny().compareTo(maxMny) < 0) continue;
            maxMny = vo.getTypeMny();
            resultVo = vo;
        }
        return resultVo;
    }

    public List<AppraiseResultVO> calGradeA(Map<Long, SupplyBaseVo> supplyBaseMap, Map<Long, SupplierVO> shareSupplierMap, Map<Long, SupplySubVo> longSupplySubVoMap, List<Long> supplierIds, String startDate) {
        QueryWrapper wrapper = new QueryWrapper();
        List list = this.limitService.list((Wrapper)wrapper);
        HashBasedTable doubleMap = HashBasedTable.create();
        for (LimitEntity limitEntity : list) {
            if (!limitEntity.getState().booleanValue() || null == limitEntity.getAllYear()) continue;
            doubleMap.put((Object)limitEntity.getSupplyType(), (Object)limitEntity.getGreadId(), (Object)limitEntity.getAllYear());
        }
        HashMap<Integer, GradeEntity> weightMap = new HashMap<Integer, GradeEntity>();
        HashMap<Long, GradeEntity> weightIdMap = new HashMap<Long, GradeEntity>();
        QueryWrapper gradeWrapper = new QueryWrapper();
        List gradeList = this.gradeService.list((Wrapper)gradeWrapper);
        for (GradeEntity entity : gradeList) {
            weightMap.put(entity.getWeight(), entity);
            weightIdMap.put(entity.getId(), entity);
        }
        HashMap<Integer, AbnormalEntity> errWeightMap = new HashMap<Integer, AbnormalEntity>();
        QueryWrapper abnormalWrapper = new QueryWrapper();
        List errlist = this.abnormalService.list((Wrapper)abnormalWrapper);
        for (AbnormalEntity entity : errlist) {
            errWeightMap.put(entity.getWeight(), entity);
        }
        ArrayList<AppraiseResultVO> appraiseResultVOList = new ArrayList<AppraiseResultVO>();
        this.logger.info("supplyBaseMap:" + JSONObject.toJSONString(supplyBaseMap));
        for (Long supplierId : supplierIds) {
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(supplierId);
            this.logger.info("supplyBaseVo:" + JSONObject.toJSONString((Object)supplyBaseVo));
            if (null == supplyBaseVo) {
                this.logger.info("\u6839\u636e\u4f9b\u5e94\u5546Id-{}\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u8be5\u4f9b\u5e94\u5546\uff01", (Object)supplierId);
                continue;
            }
            TypeBaseVo maxTypeVo = this.getMaxType(supplyBaseVo);
            this.logger.info("maxTypeVo:" + JSONObject.toJSONString((Object)maxTypeVo));
            SupplierVO supplierVO = shareSupplierMap.get(supplierId);
            if (null == supplierVO.getGradeId()) {
                this.logger.info("\u4f9b\u5e94\u5546Id-{}\u6839\u636e\u5176\u73b0\u6709\u7b49\u7ea7\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u8be5\u4f9b\u5e94\u5546\uff01", (Object)supplierId);
                continue;
            }
            String supplyType = maxTypeVo.getContractType();
            this.logger.info("supplyType:" + supplyType);
            this.logger.info("maxTypeVo:" + JSONObject.toJSONString((Object)maxTypeVo));
            this.logger.info("doubleMap:" + JSONObject.toJSONString((Object)doubleMap));
            BigDecimal maxMny = (BigDecimal)doubleMap.get((Object)supplyType, (Object)supplierVO.getGradeId());
            GradeEntity gradeEntity = (GradeEntity)((Object)weightIdMap.get(supplierVO.getGradeId()));
            if (null == gradeEntity) {
                this.logger.info("\u4f9b\u5e94\u5546Id-{}\u6839\u636e\u5176\u73b0\u6709\u7b49\u7ea7Id-{}\u83b7\u53d6\u5230\u5bf9\u5e94\u4f9b\u5e94\u5546\u7b49\u7ea7\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u8be5\u4f9b\u5e94\u5546\uff01", (Object)supplierId, (Object)supplierVO.getGradeId());
                continue;
            }
            Integer nowWeight = gradeEntity.getWeight();
            SupplySubVo supplySubVo = longSupplySubVoMap.get(supplierId);
            Map projectMap = supplySubVo.getProjectMap();
            HashMap<Long, BigDecimal> proSubGrade = new HashMap<Long, BigDecimal>();
            for (ProjectSubVo vo : projectMap.values()) {
                proSubGrade.put(vo.getPrijectId(), vo.getSubGrade());
            }
            CalRuleVo calRuleVo = this.calRuleA(nowWeight, proSubGrade, supplySubVo.getSubGrade(), supplyBaseVo.getSumMny(), maxMny, new BigDecimal(90L));
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            appraiseResultVO.setSupplyId(supplierId);
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(supplyBaseVo.getProjectIds().size() + "");
            Long maxContract = this.getMaxConBytype(maxTypeVo);
            CommonResponse contractPoolVOCommonResponse = this.contractPoolApi.queryById(maxContract);
            if (contractPoolVOCommonResponse.isSuccess() && contractPoolVOCommonResponse.getData() != null) {
                ContractPoolVO data = (ContractPoolVO)contractPoolVOCommonResponse.getData();
                appraiseResultVO.setCooperationOrgId(data.getOrgId());
                appraiseResultVO.setCooperationOrgName(data.getOrgName());
            }
            appraiseResultVO.setPrimaryGrade(gradeEntity.getName());
            appraiseResultVO.setTotalAmount(supplyBaseVo.getSumMny());
            appraiseResultVO.setTotalNum(supplyBaseVo.getCount());
            appraiseResultVO.setProcessBranch(supplySubVo.getGcSubGrade());
            appraiseResultVO.setIncidentBranch(supplySubVo.getSjSubGrade());
            appraiseResultVO.setSupplyType(SupplyQueryTypeUtil.getEName((String)maxTypeVo.getContractDetailType()));
            appraiseResultVO.setSupplyTypeName(SupplyQueryTypeUtil.getName((String)maxTypeVo.getContractDetailType()));
            appraiseResultVO.setThiYearNum(supplyBaseVo.getCount());
            appraiseResultVO.setSupplyQueryType(maxTypeVo.getContractType());
            GradeEntity gradeEntity1 = (GradeEntity)((Object)weightMap.get(calRuleVo.getNewWeight()));
            if (null == gradeEntity1) {
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(gradeEntity1.getId());
            appraiseResultVO.setGradeName(gradeEntity1.getName());
            appraiseResultVO.setContractType(maxTypeVo.getContractDetailType());
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if (null != calRuleVo.getNewErrWeight()) {
                AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)errWeightMap.get(calRuleVo.getNewErrWeight()));
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            appraiseResultVOList.add(appraiseResultVO);
        }
        return appraiseResultVOList;
    }

    private Long getMaxConBytype(TypeBaseVo maxTypeVo) {
        Long maxContract = null;
        BigDecimal max = BigDecimal.ZERO;
        Map projectMap = maxTypeVo.getProjectMap();
        for (ProjectBaseVo item : projectMap.values()) {
            for (ContractDTO t : item.getContracts().values()) {
                if (t.getContractTaxMny().compareTo(max) < 0) continue;
                maxContract = t.getContractId();
            }
        }
        return maxContract;
    }

    private CalRuleVo calRuleA(Integer nowWeight, Map<Long, BigDecimal> proSubGrade, BigDecimal sumGrade, BigDecimal sumMny, BigDecimal maxMny, BigDecimal rercent) {
        this.logger.info("\u8ba1\u7b97\u7b49\u7ea7\u5f00\u59cb\u6253\u5370\u5165\u53c2");
        this.logger.info("nowWeight:" + nowWeight);
        this.logger.info("proSubGrade:" + JSONObject.toJSONString(proSubGrade));
        this.logger.info("sumGrade:" + sumGrade);
        this.logger.info("sumMny:" + sumMny);
        this.logger.info("maxMny:" + maxMny);
        this.logger.info("rercent:" + rercent);
        Integer newWeight = null;
        Integer newErrWeight = null;
        maxMny = null == maxMny ? BigDecimal.ZERO : maxMny.multiply(rercent);
        BigDecimal bigDecimal = sumMny = null == sumMny ? BigDecimal.ZERO : sumMny.multiply(new BigDecimal(100L));
        if (sumGrade.compareTo(level1) > 0) {
            if (nowWeight < 9 && sumMny.compareTo(maxMny) > 0) {
                newWeight = nowWeight + 1;
            } else if (nowWeight == 9 && sumMny.compareTo(maxMny) > 0) {
                boolean res = true;
                if (proSubGrade.values().size() >= 3) {
                    for (BigDecimal dec : proSubGrade.values()) {
                        if (dec.compareTo(level1) > 0) continue;
                        res = false;
                        break;
                    }
                } else {
                    res = false;
                }
                if (res) {
                    newWeight = nowWeight + 1;
                }
            }
        } else if (sumGrade.compareTo(level3) <= 0) {
            newErrWeight = 10;
        } else if (sumGrade.compareTo(level2) <= 0 && nowWeight > 8) {
            newWeight = nowWeight - 1;
        }
        CalRuleVo vo = new CalRuleVo();
        vo.setNewWeight(newWeight);
        vo.setNewErrWeight(newErrWeight);
        return vo;
    }

    private CalRuleVo calRuleB(BigDecimal sumGrade) {
        Integer newWeight = null;
        Integer newErrWeight = null;
        if (sumGrade.compareTo(level1) >= 0) {
            newWeight = 10;
        } else if (sumGrade.compareTo(level1) < 0 && sumGrade.compareTo(level2) <= 0) {
            newWeight = 9;
        } else if (sumGrade.compareTo(level2) < 0 && sumGrade.compareTo(level3) <= 0) {
            newWeight = 8;
        } else if (sumGrade.compareTo(level3) < 0) {
            newErrWeight = 10;
        }
        CalRuleVo vo = new CalRuleVo();
        vo.setNewWeight(newWeight);
        vo.setNewErrWeight(newErrWeight);
        return vo;
    }

    public List<AppraiseResultVO> calGradeB(Map<Long, SupplyBaseVo> supplyBaseMap, Map<Long, SupplierVO> shareSupplierMap, Map<Long, SupplySubVo> longSupplySubVoMap, List<Long> supplierIds, String startDate) {
        HashMap<Integer, GradeEntity> weightMap = new HashMap<Integer, GradeEntity>();
        HashMap<Long, GradeEntity> weightIdMap = new HashMap<Long, GradeEntity>();
        QueryWrapper gradeWrapper = new QueryWrapper();
        List gradeList = this.gradeService.list((Wrapper)gradeWrapper);
        for (GradeEntity entity : gradeList) {
            weightMap.put(entity.getWeight(), entity);
            weightIdMap.put(entity.getId(), entity);
        }
        HashMap<Integer, AbnormalEntity> errWeightMap = new HashMap<Integer, AbnormalEntity>();
        QueryWrapper abnormalWrapper = new QueryWrapper();
        List errlist = this.abnormalService.list((Wrapper)abnormalWrapper);
        for (AbnormalEntity entity : errlist) {
            errWeightMap.put(entity.getWeight(), entity);
        }
        ArrayList<AppraiseResultVO> appraiseResultVOList = new ArrayList<AppraiseResultVO>();
        for (Long supplierId : supplierIds) {
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(supplierId);
            TypeBaseVo maxTypeVo = this.getMaxType(supplyBaseVo);
            SupplierVO supplierVO = shareSupplierMap.get(supplierId);
            SupplySubVo supplySubVo = longSupplySubVoMap.get(supplierId);
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            GradeEntity gradeEntity = (GradeEntity)((Object)weightIdMap.get(supplierVO.getGradeId()));
            CalRuleVo calRuleVo = this.calRuleB(supplySubVo.getSubGrade());
            appraiseResultVO.setSupplyId(supplierId);
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(supplyBaseVo.getProjectIds().size() + "");
            Long maxContract = this.getMaxConBytype(maxTypeVo);
            CommonResponse contractPoolVOCommonResponse = this.contractPoolApi.queryById(maxContract);
            if (contractPoolVOCommonResponse.isSuccess() && contractPoolVOCommonResponse.getData() != null) {
                ContractPoolVO data = (ContractPoolVO)contractPoolVOCommonResponse.getData();
                appraiseResultVO.setCooperationOrgId(data.getOrgId());
                appraiseResultVO.setCooperationOrgName(data.getOrgName());
            }
            appraiseResultVO.setPrimaryGrade(gradeEntity.getName());
            appraiseResultVO.setTotalAmount(supplyBaseVo.getSumMny());
            appraiseResultVO.setTotalNum(supplyBaseVo.getCount());
            appraiseResultVO.setProcessBranch(supplySubVo.getGcSubGrade());
            appraiseResultVO.setIncidentBranch(supplySubVo.getSjSubGrade());
            appraiseResultVO.setSupplyType(SupplyQueryTypeUtil.getEName((String)maxTypeVo.getContractDetailType()));
            appraiseResultVO.setSupplyTypeName(SupplyQueryTypeUtil.getName((String)maxTypeVo.getContractDetailType()));
            appraiseResultVO.setThiYearNum(supplyBaseVo.getCount());
            appraiseResultVO.setSupplyQueryType(maxTypeVo.getContractType());
            GradeEntity gradeEntity1 = (GradeEntity)((Object)weightMap.get(calRuleVo.getNewWeight()));
            if (null == gradeEntity1) {
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(gradeEntity1.getId());
            appraiseResultVO.setGradeName(gradeEntity1.getName());
            appraiseResultVO.setContractType(maxTypeVo.getContractDetailType());
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if (null != calRuleVo.getNewErrWeight()) {
                AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)errWeightMap.get(calRuleVo.getNewErrWeight()));
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            appraiseResultVOList.add(appraiseResultVO);
        }
        return appraiseResultVOList;
    }

    public void sendData(List<AppraiseResultVO> appraiseResultVOList) {
        List yearEntities = BeanMapper.mapList(appraiseResultVOList, YearEntity.class);
        for (YearEntity entity : yearEntities) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setStatus(0);
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            entity.setEndDate(new Date());
            entity.setYearDeduct(0);
        }
        if (yearEntities.size() > 0) {
            this.yearService.saveOrUpdateBatch(yearEntities, yearEntities.size());
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<ContVo> sumSubProGrade(List<SubcontractProcessEntity> processlist, List<SubcontractIncidentEntity> incidentList) {
        Long contractId;
        HashMap<Long, BigDecimal> con = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> gc = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> sj = new HashMap<Long, BigDecimal>();
        BigDecimal sum = BigDecimal.ZERO;
        for (SubcontractProcessEntity subcontractProcessEntity : processlist) {
            contractId = subcontractProcessEntity.getContractId();
            if (null == con.get(contractId)) {
                con.put(contractId, subcontractProcessEntity.getBuckleBranch());
            } else {
                con.put(contractId, ((BigDecimal)con.get(contractId)).add(subcontractProcessEntity.getBuckleBranch()));
            }
            if (null == sj.get(contractId)) {
                sj.put(contractId, subcontractProcessEntity.getBuckleBranch());
            } else {
                sj.put(contractId, ((BigDecimal)sj.get(contractId)).add(subcontractProcessEntity.getBuckleBranch()));
            }
            sum = ComputeUtil.safeAdd((BigDecimal)sum, (BigDecimal)subcontractProcessEntity.getBuckleBranch());
        }
        for (SubcontractIncidentEntity subcontractIncidentEntity : incidentList) {
            contractId = subcontractIncidentEntity.getContractId();
            if (null == con.get(contractId)) {
                con.put(contractId, subcontractIncidentEntity.getBuckleBranch());
            } else {
                con.put(contractId, ((BigDecimal)con.get(contractId)).add(subcontractIncidentEntity.getBuckleBranch()));
            }
            if (null == gc.get(contractId)) {
                gc.put(contractId, subcontractIncidentEntity.getBuckleBranch());
            } else {
                gc.put(contractId, ((BigDecimal)gc.get(contractId)).add(subcontractIncidentEntity.getBuckleBranch()));
            }
            sum = ComputeUtil.safeAdd((BigDecimal)sum, (BigDecimal)subcontractIncidentEntity.getBuckleBranch());
        }
        BigDecimal count = BigDecimal.valueOf(con.size());
        BigDecimal bigDecimal = BigDecimal.ZERO;
        this.logger.info("sum:" + sum);
        this.logger.info("count:" + count);
        if (sum.compareTo(BigDecimal.ZERO) != 0 && count.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal bigDecimal2 = sum.divide(count, 0, 0);
        }
        Map processMap = processlist.stream().collect(HashMap::new, (m, s) -> m.put(s.getContractId(), s), HashMap::putAll);
        Map incidentMap = incidentList.stream().collect(HashMap::new, (m, s) -> m.put(s.getContractId(), s), HashMap::putAll);
        ArrayList<ContVo> resultList = new ArrayList<ContVo>();
        for (Long item : con.keySet()) {
            ContVo contVo;
            void var8_13;
            SubcontractProcessEntity subcontractProcessEntity = (SubcontractProcessEntity)((Object)processMap.get(item));
            SubcontractIncidentEntity subcontractIncidentEntity = (SubcontractIncidentEntity)((Object)incidentMap.get(item));
            if (null != subcontractProcessEntity) {
                contVo = this.getContVo(subcontractProcessEntity, con, sj, (BigDecimal)var8_13);
                resultList.add(contVo);
                continue;
            }
            if (null != subcontractIncidentEntity) {
                contVo = this.getContVo(subcontractIncidentEntity, con, sj, (BigDecimal)var8_13);
                resultList.add(contVo);
                continue;
            }
            this.logger.info("\u6570\u636e\u51fa\u9519\uff0c\u5408\u540cid:" + item);
        }
        return resultList;
    }

    private ContVo getContVo(SubcontractProcessEntity entity, Map<Long, BigDecimal> con, Map<Long, BigDecimal> sj, BigDecimal divide) {
        ContVo contVo = new ContVo();
        contVo.setContractId(entity.getContractId());
        contVo.setContractName(entity.getContractName());
        contVo.setContractType(entity.getContractType());
        contVo.setProjectName(entity.getProjectName());
        contVo.setOrgName(entity.getCheckOrgName());
        contVo.setContractMny(entity.getContractAmount());
        contVo.setSubProGrade(con.get(entity.getContractId()));
        contVo.setSubSjGrade(sj.get(entity.getContractId()));
        contVo.setSubGcGrade(divide);
        return contVo;
    }

    private ContVo getContVo(SubcontractIncidentEntity entity, Map<Long, BigDecimal> con, Map<Long, BigDecimal> sj, BigDecimal divide) {
        ContVo contVo = new ContVo();
        contVo.setContractId(entity.getContractId());
        contVo.setContractName(entity.getContractName());
        contVo.setContractType(entity.getContractType());
        contVo.setProjectName(entity.getProjectName());
        contVo.setOrgName(entity.getCheckOrgName());
        contVo.setContractMny(entity.getContractAmount());
        contVo.setSubProGrade(con.get(entity.getContractId()));
        contVo.setSubSjGrade(sj.get(entity.getContractId()));
        contVo.setSubGcGrade(divide);
        return contVo;
    }

    public List<Map<String, Object>> sumSubProGrade2(List<SubcontractProcessEntity> processlist, List<SubcontractIncidentEntity> incidentList, Long supplyId) {
        SubContVo contVo1;
        ArrayList<SubContVo> vos = new ArrayList<SubContVo>();
        for (SubcontractProcessEntity subcontractProcessEntity : processlist) {
            contVo1 = new SubContVo();
            contVo1.setHeadUserId(subcontractProcessEntity.getHeadUserId());
            contVo1.setHeadUserName(subcontractProcessEntity.getHeadUserName());
            contVo1.setContractId(subcontractProcessEntity.getContractId());
            contVo1.setContractName(subcontractProcessEntity.getContractName());
            contVo1.setContractType(subcontractProcessEntity.getContractType());
            contVo1.setProjectName(subcontractProcessEntity.getProjectName());
            contVo1.setOrgName(subcontractProcessEntity.getCheckOrgName());
            contVo1.setContractMny(subcontractProcessEntity.getContractAmount());
            contVo1.setSubProGrade(subcontractProcessEntity.getBuckleBranch());
            contVo1.setSubSjGrade(subcontractProcessEntity.getBuckleBranch());
            contVo1.setSubGcGrade(BigDecimal.ZERO);
            vos.add(contVo1);
        }
        for (SubcontractIncidentEntity subcontractIncidentEntity : incidentList) {
            contVo1 = new SubContVo();
            contVo1.setHeadUserId(subcontractIncidentEntity.getHeadUserId());
            contVo1.setHeadUserName(subcontractIncidentEntity.getHeadUserName());
            contVo1.setContractId(subcontractIncidentEntity.getContractId());
            contVo1.setContractName(subcontractIncidentEntity.getContractName());
            contVo1.setContractType(subcontractIncidentEntity.getContractType());
            contVo1.setProjectName(subcontractIncidentEntity.getProjectName());
            contVo1.setOrgName(subcontractIncidentEntity.getCheckOrgName());
            contVo1.setContractMny(subcontractIncidentEntity.getContractAmount());
            contVo1.setSubProGrade(subcontractIncidentEntity.getBuckleBranch());
            contVo1.setSubSjGrade(BigDecimal.ZERO);
            contVo1.setSubGcGrade(subcontractIncidentEntity.getBuckleBranch());
            contVo1.setProjectId(subcontractIncidentEntity.getProjectId());
            vos.add(contVo1);
        }
        Map<Long, List<SubContVo>> map = vos.stream().collect(Collectors.groupingBy(t -> null != t.getHeadUserId() ? t.getHeadUserId() : -1L));
        List list = map.keySet().stream().filter(item -> !item.equals(-1L)).collect(Collectors.toList());
        Map<Object, Object> subLeaderMap = new HashMap();
        if (CollectionUtils.isNotEmpty(list)) {
            HashMap<String, ArrayList<Long>> subLeaderParam = new HashMap<String, ArrayList<Long>>();
            subLeaderParam.put("ids", new ArrayList<Long>(map.keySet()));
            this.logger.info("\u67e5\u8be2\u5206\u5305\u8d1f\u8d23\u4eba\u5217\u8868\uff0cids-{}", (Object)JSONObject.toJSONString(list));
            CommonResponse dtoResp = this.shareSubleadersApi.getSubleaderList(subLeaderParam);
            if (!dtoResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5206\u5305\u8d1f\u8d23\u4eba\u5217\u8868\uff0cids-{}\u5f02\u5e38\uff0c{}", (Object)JSONObject.toJSONString(list), (Object)JSONObject.toJSONString((Object)dtoResp));
                throw new RuntimeException("\u67e5\u8be2\u5206\u5305\u8d1f\u8d23\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
            }
            subLeaderMap = ((List)dtoResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Integer code = 1;
        ArrayList<Long> contractIds = new ArrayList<Long>();
        for (Map.Entry<Long, List<SubContVo>> entry : map.entrySet()) {
            Long headUserId = entry.getKey();
            List<SubContVo> list2 = entry.getValue();
            BigDecimal sumCon = BigDecimal.ZERO;
            BigDecimal sumGrade = BigDecimal.ZERO;
            BigDecimal ageGcGrade = BigDecimal.ZERO;
            HashMap<Long, BigDecimal> proGrade = new HashMap<Long, BigDecimal>();
            for (SubContVo vo : list2) {
                sumCon = ComputeUtil.safeAdd((BigDecimal)sumCon, (BigDecimal)vo.getContractMny());
                sumGrade = ComputeUtil.safeAdd((BigDecimal)sumGrade, (BigDecimal)vo.getSubProGrade());
                BigDecimal grade = (BigDecimal)proGrade.get(vo.getContractId());
                if (null == grade) {
                    proGrade.put(vo.getContractId(), vo.getSubProGrade());
                    continue;
                }
                proGrade.put(vo.getContractId(), grade.add(vo.getSubProGrade()));
            }
            QueryWrapper wrapper = new QueryWrapper();
            List limitList = this.limitService.list((Wrapper)wrapper);
            HashBasedTable doubleMap = HashBasedTable.create();
            for (LimitEntity limitEntity : limitList) {
                if (!limitEntity.getState().booleanValue() || null == limitEntity.getAllYear()) continue;
                doubleMap.put((Object)limitEntity.getSupplyType(), (Object)limitEntity.getGreadId(), (Object)limitEntity.getAllYear());
            }
            HashMap<Integer, GradeEntity> weightMap = new HashMap<Integer, GradeEntity>();
            HashMap<Long, GradeEntity> weightIdMap = new HashMap<Long, GradeEntity>();
            QueryWrapper gradeWrapper = new QueryWrapper();
            List gradeList = this.gradeService.list((Wrapper)gradeWrapper);
            for (GradeEntity entity : gradeList) {
                weightMap.put(entity.getWeight(), entity);
                weightIdMap.put(entity.getId(), entity);
            }
            HashMap<Integer, AbnormalEntity> errWeightMap = new HashMap<Integer, AbnormalEntity>();
            QueryWrapper abnormalWrapper = new QueryWrapper();
            List errlist = this.abnormalService.list((Wrapper)abnormalWrapper);
            for (AbnormalEntity entity : errlist) {
                errWeightMap.put(entity.getWeight(), entity);
            }
            SubleadersVO subleadersVO = (SubleadersVO)subLeaderMap.get(headUserId);
            Object max = BigDecimal.ZERO;
            String level = "";
            String errLevel = "";
            Integer i = 0;
            if (null != subleadersVO) {
                Long grade = subleadersVO.getGrade();
                GradeEntity gradeEntity = (GradeEntity)((Object)weightIdMap.get(grade));
                BigDecimal labor = doubleMap.get((Object)"labor", (Object)gradeEntity.getId()) == null ? BigDecimal.ZERO : (BigDecimal)doubleMap.get((Object)"labor", (Object)gradeEntity.getId());
                BigDecimal major = doubleMap.get((Object)"major", (Object)gradeEntity.getId()) == null ? BigDecimal.ZERO : (BigDecimal)doubleMap.get((Object)"major", (Object)gradeEntity.getId());
                max = labor.compareTo(major) > 0 ? labor : major;
                CalRuleVo calRuleVo = this.calRuleA(gradeEntity.getWeight(), proGrade, sumGrade, sumCon, (BigDecimal)max, new BigDecimal(90L));
                GradeEntity gradeEntity1 = (GradeEntity)((Object)weightMap.get(calRuleVo.getNewWeight()));
                if (null == gradeEntity1) {
                    gradeEntity1 = gradeEntity;
                }
                level = gradeEntity1.getName();
                AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)errWeightMap.get(calRuleVo.getNewErrWeight()));
                errLevel = null != abnormalEntity ? abnormalEntity.getName() : null;
            }
            ArrayList children = new ArrayList();
            int conNums = proGrade.keySet().size();
            ageGcGrade = sumGrade.divide(new BigDecimal(conNums), 0, RoundingMode.UP);
            for (SubContVo vo : list2) {
                if (contractIds.contains(vo.getContractId())) continue;
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("headUserId", null != vo.getHeadUserId() ? vo.getHeadUserId() : "");
                resultMap.put("headUserName", vo.getHeadUserName());
                resultMap.put("contractId", vo.getContractId());
                resultMap.put("contractName", vo.getContractName());
                resultMap.put("projectId", vo.getProjectId());
                resultMap.put("projectName", vo.getProjectName());
                resultMap.put("contractMny", vo.getContractMny());
                resultMap.put("sumCon", sumCon);
                resultMap.put("gcGrade", ageGcGrade);
                resultMap.put("proGrade", proGrade.get(vo.getContractId()));
                resultMap.put("sumGrade", sumGrade);
                resultMap.put("level", level);
                resultMap.put("errLevel", errLevel);
                resultMap.put("id", UUID.randomUUID());
                if (i == 0) {
                    resultMap.put("rowCol", conNums);
                } else {
                    resultMap.put("rowCol", 0);
                }
                contractIds.add(vo.getContractId());
                children.add(resultMap);
            }
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("code", code);
            map1.put("children", children);
            map1.put("headUserId", null != headUserId && !Long.valueOf("-1").equals(headUserId) ? headUserId : "");
            map1.put("headUserName", null != subleadersVO ? subleadersVO.getName() : null);
            map1.put("sumCon", sumCon);
            map1.put("gcGrade", ageGcGrade);
            map1.put("proGrade", sumGrade);
            map1.put("level", level);
            map1.put("errLevel", errLevel);
            map1.put("id", UUID.randomUUID());
            contractIds.clear();
            result.add(map1);
        }
        return result;
    }

    public void updateSup(YearEntity entity) {
        Long grade = entity.getGrade();
        String gradeName = entity.getGradeName();
        try {
            this.proSupplierApi.upgradeSupplier(entity.getSupplyId(), grade, gradeName);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            String infomsg = sw.toString();
            this.logger.error(infomsg);
        }
        if (null != entity.getPunishType()) {
            PunishVO punishVO = new PunishVO();
            punishVO.setSupplierId(entity.getSupplyId());
            punishVO.setPunishType(entity.getPunishType());
            punishVO.setPunishDate(new Date());
            AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)this.abnormalService.selectById(entity.getPunishType()));
            if (null == abnormalEntity) {
                this.logger.error("\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u5f02\u5e38\u7b49\u7ea7\u7684\u6570\u636e");
                return;
            }
            Date endDate = DateUtil.monthAdd(new Date(), abnormalEntity.getLastTime() == null ? 0 : abnormalEntity.getLastTime());
            punishVO.setExceptionEndDate(endDate);
            punishVO.setPunishApplyPerson(entity.getProcess());
            punishVO.setPunishGradeId(entity.getGrade());
            punishVO.setPunishGrade(entity.getGradeName());
            punishVO.setPunishOldGrade(entity.getPrimaryGrade());
            punishVO.setPunishApplyOrg(entity.getOrgName());
            String punishVOStr = JSONObject.toJSONString((Object)punishVO);
            this.logger.info("punishVOStr:" + punishVOStr);
            try {
                this.proSupplierApi.punishSupplier(punishVO);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)sw, true));
                String infomsg = sw.toString();
                this.logger.error(infomsg);
            }
        }
    }
}

