/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.SubcontractCanInEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractInvestigateEntity;
import com.ejianc.business.pro.supplier.service.ISubcontractCanInService;
import com.ejianc.business.pro.supplier.service.ISubcontractInvestigateService;
import com.ejianc.business.pro.supplier.service.ISubleadersService;
import com.ejianc.business.pro.supplier.vo.AlreadyInvestigateVO;
import com.ejianc.business.pro.supplier.vo.SubcontractCanInVO;
import com.ejianc.business.pro.supplier.vo.SubcontractInvestigateVO;
import com.ejianc.business.pro.supplier.vo.SubleadersVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subcontractInvestigate"})
public class SubcontractInvestigateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISubcontractInvestigateService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISubcontractCanInService subcontractCanInService;
    @Autowired
    private ISubleadersService subleadersService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubcontractInvestigateVO> saveOrUpdate(@RequestBody SubcontractInvestigateVO saveOrUpdateVO) {
        SubcontractInvestigateEntity entity = (SubcontractInvestigateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SubcontractInvestigateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setSupplyQueryType("laborSub");
        this.service.saveOrUpdate((Object)entity, false);
        SubcontractCanInEntity subcontractCanInEntity = (SubcontractCanInEntity)((Object)this.subcontractCanInService.getById(entity.getCanInId()));
        subcontractCanInEntity.setHasInvestigate(true);
        this.subcontractCanInService.saveOrUpdate((Object)subcontractCanInEntity);
        SubcontractInvestigateVO vo = (SubcontractInvestigateVO)BeanMapper.map((Object)((Object)entity), SubcontractInvestigateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractInvestigateVO> queryDetail(Long id) {
        SubcontractInvestigateEntity entity = (SubcontractInvestigateEntity)((Object)this.service.selectById(id));
        SubcontractInvestigateVO vo = (SubcontractInvestigateVO)BeanMapper.map((Object)((Object)entity), SubcontractInvestigateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractInvestigateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SubcontractInvestigateVO subcontractInvestigateVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubcontractInvestigateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractInvestigateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubcontractInvestigate-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubcontractInvestigateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubcontractInvestigateVO>> refSubcontractInvestigateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractInvestigateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAlreadyList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AlreadyInvestigateVO>> queryMyList(@RequestBody QueryParam queryParam) {
        IPage<AlreadyInvestigateVO> pageData = this.service.queryAlreadyList(queryParam);
        return CommonResponse.success(pageData);
    }

    @RequestMapping(value={"/queryStayList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubcontractCanInVO>> queryStayList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("materialContent");
        param.getFuzzyFields().add("applyOrgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("applyOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("investigate", new Parameter("eq", (Object)true));
        param.getParams().put("hasInvestigate", new Parameter("sql", (Object)"has_investigate is not true"));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("supplyQueryType", new Parameter("eq", (Object)"laborSub"));
        IPage page = this.subcontractCanInService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractCanInVO.class));
        List records = BeanMapper.mapList((Iterable)page.getRecords(), SubcontractCanInVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            for (SubcontractCanInVO record : records) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("pid", new Parameter("eq", (Object)record.getId()));
                List subLeadersEntities = this.subleadersService.queryList(queryParam);
                if (!CollectionUtils.isNotEmpty((Collection)subLeadersEntities)) continue;
                List subleaders = BeanMapper.mapList((Iterable)subLeadersEntities, SubleadersVO.class);
                record.setSubLeaders(subleaders);
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/deleteAlready"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteAlready(@RequestBody List<AlreadyInvestigateVO> vos) {
        List alreadyList = vos.stream().map(AlreadyInvestigateVO::getId).collect(Collectors.toList());
        this.service.removeByIds(vos.stream().map(AlreadyInvestigateVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

