package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.pro.supplier.bean.YearEntity;
import com.ejianc.business.pro.supplier.mapper.YearMapper;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.ProcessVO;
import com.ejianc.business.pro.supplier.vo.YearVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.warn.api.IWarningApi;
import com.ejianc.business.warn.vo.WarningParameterVO;
import com.ejianc.business.warn.vo.WarningVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 年度评价
 * 
 * @author generator
 * 
 */
@Service("yearService")
public class YearServiceImpl extends BaseServiceImpl<YearMapper, YearEntity> implements IYearService{

    @Autowired
    private IWarningApi warningApi;
    @Autowired
    private YearMapper yearMapper;
    @Autowired
    private IProSupplierApi iProSupplierApi;
    private static String CODE = "WARNING000094";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;
    @Override
    public Map<Long, Integer> queryGrade(Map<String, List<Long>> map) {
        List<Long> suplyIds = map.get("suplyIds");
        List<YearEntity> yearEntities = yearMapper.queryGrade(suplyIds);
        Map<Long,Integer> resultMap = new HashMap<>();
        yearEntities.forEach(item->{
            resultMap.put(item.getSupplyId(),item.getYearDeduct());
        });
        return resultMap;
    }

    @Override
    public Map<Long, BigDecimal> queryTotalBranch(Map<String, List<Long>> map) {
        Map<Long,BigDecimal> resultMap = new HashMap<>();
        List<Long> suplyIds = map.get("suplyIds");
        if(CollectionUtils.isEmpty(suplyIds)) {
            return resultMap;
        }
        List<YearEntity> yearEntities = yearMapper.queryGrade(suplyIds);
        yearEntities.forEach(item->{
            resultMap.put(item.getSupplyId(), item.getTotalBranch());
        });
        return resultMap;
    }

    @Override
    public CommonResponse<String> syncYear(YearVO saveOrUpdateVO) {
        logger.info("i8传输-供应商事件年度评价-接收传参-saveOrUpdateVO" + JSONObject.toJSONString(saveOrUpdateVO));

        String initContextUrl = baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        StringBuilder authtoken = new StringBuilder();
        try {
            CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
            if(userContextResponse.isSuccess()) {
                JSONObject userContext = userContextResponse.getData().getJSONObject("userContext");
                authtoken.append("userType=").append(userContext.get("userType"))
                        .append(";userCode=").append(userContext.get("userCode"))
                        .append(";orgId=").append(userContext.get("orgId"))
                        .append(";tenantid=").append(userContext.get("tenantid"))
                        .append(";token=").append(userContext.get("token"))
                        .append(";u_logints=").append(userContext.get("u_logints"))
                        .append(";u_usercode=").append(userContext.get("u_usercode"))
                        .append(";userId=").append(userContext.get("userId"));
                logger.info("拼接鉴权：" + authtoken.toString());
            }
        } catch (Exception e) {
            logger.error("获取调度任务上下文异常, ", e);
        }
        InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());

        CommonResponse<WarningVO> byCode = warningApi.getWarningByCode(CODE);
        if (!byCode.isSuccess()) {
            logger.info("未获取到供应商年度评价周期日期！");
            return CommonResponse.success("未获取到供应商年度评价周期日期！");
        }
        String parameterValue = "01-01";
        if (CollectionUtils.isNotEmpty(byCode.getData().getWarningParameterList())){
            for (WarningParameterVO warningParameterVO : byCode.getData().getWarningParameterList()) {
                if ("yearPushDate".equals(warningParameterVO.getParameterProperty())){
                    parameterValue = warningParameterVO.getParameterValue();
                }
            }
        }

        // 获取年度评价周期
        String startDate = DateUtil.getYear() - 1 + "-" + parameterValue;
        String endDateStr = DateUtil.getYear() + "-" + parameterValue;

        List<String> createDataCodeList = new ArrayList<>();
        List<Long> updateDataIdList = new ArrayList<>();
        List<String> updateDataCodeList = new ArrayList<>();


        if (StringUtils.isEmpty(saveOrUpdateVO.getUnitI8Code())){
            return CommonResponse.error("接口传输失败，i8单位编码未传值 ！");
        }
        List<YearEntity> yearListData = super.list(new QueryWrapper<YearEntity>().eq("unit_i8_code", saveOrUpdateVO.getUnitI8Code()).between("handle_date", startDate, endDateStr));
        if (CollectionUtils.isNotEmpty(yearListData) && yearListData.size() > 0){
            return CommonResponse.success("接口传输失败，该供应商本年度已推送！");
        }

        List<YearEntity> yearList = super.list(new QueryWrapper<YearEntity>().eq("unit_i8_code", saveOrUpdateVO.getUnitI8Code()));
        YearEntity yearEntity = null;

        CommonResponse<SupplierDTO> listCommonResponse = iProSupplierApi.selectSupplierByUnitI8Code(saveOrUpdateVO.getUnitI8Code());
        if (!listCommonResponse.isSuccess()){
            return CommonResponse.error("未找到对应i8单位编码供应商，请推送供应商后再做评价！");
        }
        SupplierDTO supplierDTO = listCommonResponse.getData();
        logger.info("查出对应供应商-----" + JSONObject.toJSONString(supplierDTO));

        if (CollectionUtils.isNotEmpty(yearList) && yearList.size() > 0){
            yearEntity = yearList.get(0);
            updateDataCodeList.add(saveOrUpdateVO.getCode());
            updateDataIdList.add(saveOrUpdateVO.getId());
        }else {
            yearEntity = new YearEntity();
            yearEntity.setId(IdWorker.getId());
            yearEntity.setTenantId(999999L);

            //编号重复校验
            QueryWrapper<YearEntity> query = new QueryWrapper();
            query.eq("code", saveOrUpdateVO.getCode());
            List<YearEntity> billCodeEntityList = super.list(query);
            if(CollectionUtils.isNotEmpty(billCodeEntityList)) {
                return CommonResponse.error("保存失败，编码重复！");
            }

            yearEntity.setCode(saveOrUpdateVO.getCode());
            createDataCodeList.add(saveOrUpdateVO.getCode());
        }

        yearEntity.setContractId(saveOrUpdateVO.getContractId());
        yearEntity.setContractName(saveOrUpdateVO.getContractName());

        yearEntity.setSupplyId(supplierDTO.getId());
        yearEntity.setSupplyName(supplierDTO.getSupplyTypeName());
//        yearEntity.setSupplyId(saveOrUpdateVO.getSupplyId());
//        yearEntity.setSupplyName(saveOrUpdateVO.getSupplyName());

        yearEntity.setThiYearNum(saveOrUpdateVO.getThiYearNum());
        yearEntity.setTotalAmount(saveOrUpdateVO.getTotalAmount());
        yearEntity.setCooperationProjectName(saveOrUpdateVO.getCooperationProjectName());
        yearEntity.setCooperationOrgName(saveOrUpdateVO.getCooperationOrgName());
        yearEntity.setTotalBranch(saveOrUpdateVO.getTotalBranch());
        yearEntity.setGradeName(saveOrUpdateVO.getGradeName());
        yearEntity.setGrade(saveOrUpdateVO.getGrade());
        yearEntity.setEndDate(saveOrUpdateVO.getEndDate());

        yearEntity.setUnitI8Code(saveOrUpdateVO.getUnitI8Code());
        yearEntity.setI8Url(saveOrUpdateVO.getI8Url());

        yearEntity.setStatus(1);
        yearEntity.setBillState(1);
        yearEntity.setSourceType("i8");

        yearEntity.setSupplyQueryType(supplierDTO.getSupplyQueryType());
        super.saveOrUpdate(yearEntity, false);


        logger.info("i8传输-供应商事件评价-保存成功-saveOrUpdateVO");
        return CommonResponse.success("保存或修改单据成功！");
    }
}
