package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.IHistoryService;
import com.ejianc.business.pro.supplier.service.IUpgradeService;
import com.ejianc.business.pro.supplier.vo.EvaluateHistoryVO;
import com.ejianc.business.pro.supplier.vo.HistoryVO;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.pro.supplier.vo.PunishVO;

/**
 * 供应商处置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("punish")
public class PunishController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PUNISH-CODE";//此处需要根据实际修改

    @Autowired
    private IPunishService service;
    @Autowired
    private IHistoryService historyService;
    @Autowired
    private IGradeService gradeService;

    @Autowired
    private IUpgradeService upgradeService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PunishVO> saveOrUpdate(@RequestBody PunishVO saveorUpdateVO) {
    	PunishEntity entity = BeanMapper.map(saveorUpdateVO, PunishEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> code = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(code.isSuccess()) {
                entity.setCode(code.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        QueryParam param = new QueryParam();
        param.getParams().put("supplyId",new Parameter(QueryParam.EQ,saveorUpdateVO.getSupplyId()));
        param.getParams().put("billState",new Parameter(QueryParam.IN,"0,2,4,5"));

        List<PunishEntity> list= service.queryList(param);
        if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
            return CommonResponse.error("该供应商存在未生效的处置单！");
        }

        List<UpgradeEntity> upgradeList= upgradeService.queryList(param);
        if(CollectionUtils.isNotEmpty(upgradeList)){
            return CommonResponse.error("该供应商存在未生效的评级单！");
        }

        GradeEntity oldGrade =gradeService.getById(saveorUpdateVO.getOldGrade());
        GradeEntity gradeEntity =gradeService.getById(saveorUpdateVO.getGradeId());
        if(gradeEntity.getWeight() > oldGrade.getWeight()){
            return CommonResponse.error("评定等级必须小于原等级！");
        }
        if(saveorUpdateVO.getSupplyType().contains("material") || saveorUpdateVO.getSupplyType().contains("equipment") || saveorUpdateVO.getSupplyType().contains("revolvMaterial")){
            entity.setSupplyQueryType(SupplierQueryType.materialEquipment);
        }else {
            entity.setSupplyQueryType("other");
        }

    	service.saveOrUpdate(entity, false);
    	PunishVO vo = BeanMapper.map(entity, PunishVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PunishVO> queryDetail(Long id) {
    	PunishEntity entity = service.selectById(id);
    	PunishVO vo = BeanMapper.map(entity, PunishVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PunishVO> vos) {

        service.removeByIds(vos.stream().map(PunishVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PunishVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getFuzzyFields().add("supplyTypeName");
        param.getFuzzyFields().add("code");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(param.getParams().get("supplyTypeNames") != null){
            param.getParams().put("supplyTypeName", new Parameter(QueryParam.LIKE, param.getParams().get("supplyTypeNames").getValue()));
            param.getParams().remove("supplyTypeNames");
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("applyDate", "desc");
        param.setOrderMap(orderMap);
        IPage<PunishEntity> page = service.queryPage(param,false);
        IPage<PunishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PunishVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getFuzzyFields().add("supplyTypeName");
        param.getFuzzyFields().add("code");

        if(param.getParams().get("supplyTypeNames") != null){
            param.getParams().put("supplyTypeName", new Parameter(QueryParam.LIKE, param.getParams().get("supplyTypeNames").getValue()));
            param.getParams().remove("supplyTypeNames");
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("applyDate", "desc");
        param.setOrderMap(orderMap);
        List<PunishEntity> list = service.queryList(param);
        List<PunishVO> records = BeanMapper.mapList(list,PunishVO.class);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().exportWithTrans("Punish-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPunishData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PunishVO>> refPunishData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PunishEntity> page = service.queryPage(param,false);
        IPage<PunishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PunishVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 查询历史评价记录
     * @param supplyId
     * @return
     */
    @RequestMapping(value = "/evaluateHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<HistoryVO>> history(Long supplyId){
        QueryParam param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.EQ,supplyId));
        List<HistoryEntity> list =historyService.queryList(param);
        List<HistoryVO> successList =BeanMapper.mapList(list, HistoryVO.class);
        return CommonResponse.success("查询数据成功！",successList);
    }
}
