/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.SupplierGroupEntity;
import com.ejianc.business.pro.supplier.service.ISupplierGroupService;
import com.ejianc.business.pro.supplier.vo.SupplierGroupVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"supplierGroup"})
public class SupplierGroupController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Autowired
    private IDefdocApi defdocApi;
    private static String SUPPLY_CODE = "pro-supply-can-in-org-nature";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SUPPLIER_GROUP";
    @Autowired
    private ISupplierGroupService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierGroupVO> saveOrUpdate(@RequestBody SupplierGroupVO saveOrUpdateVO) {
        List billCodeEntityList;
        SupplierGroupEntity entity = (SupplierGroupEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SupplierGroupEntity.class));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"code", (Object)saveOrUpdateVO.getCode());
        if (null != saveOrUpdateVO.getId()) {
            query.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(billCodeEntityList = this.service.list((Wrapper)query)))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
        }
        if (null == entity.getCode() && (entity.getId() == null || entity.getId() == 0L)) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null != entity.getSupplierType()) {
            if ("enterprise".equals(entity.getSupplierType())) {
                entity.setSupplierTypeName("\u4f01\u4e1a");
            } else if ("person".equals(entity.getSupplierType())) {
                entity.setSupplierTypeName("\u4e2a\u4eba");
            } else if ("person,subPerson".equals(entity.getSupplierType())) {
                entity.setSupplierTypeName("\u4e2a\u4eba,\u5206\u5305\u8d1f\u8d23\u4eba");
            } else {
                entity.setSupplierTypeName("\u5206\u5305\u8d1f\u8d23\u4eba");
            }
        }
        Map<Object, Object> defMap = new HashMap();
        if (null != entity.getEnterpriseNatureName()) {
            CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode(SUPPLY_CODE);
            if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)defDocByDefCode.getData()))) {
                defMap = ((List)defDocByDefCode.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, BaseVO::getId));
            }
            entity.setEnterpriseNature((Long)defMap.get(entity.getEnterpriseNatureName()));
        }
        if (null == entity.getSyncTime()) {
            entity.setSyncTime(new Date());
        }
        entity.setLatestUpdateTime(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        SupplierGroupVO vo = (SupplierGroupVO)BeanMapper.map((Object)((Object)entity), SupplierGroupVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierGroupVO> queryDetail(Long id) {
        SupplierGroupEntity entity = (SupplierGroupEntity)((Object)this.service.selectById(id));
        SupplierGroupVO vo = (SupplierGroupVO)BeanMapper.map((Object)((Object)entity), SupplierGroupVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/querySupplierGroupDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierGroupVO> querySupplierGroupDetail(Long id) {
        SupplierGroupEntity entity = (SupplierGroupEntity)((Object)this.service.selectById(id));
        SupplierGroupVO vo = (SupplierGroupVO)BeanMapper.map((Object)((Object)entity), SupplierGroupVO.class);
        vo.setSupplierGroupId(vo.getId());
        vo.setId(Long.valueOf(IdWorker.getId()));
        CommonResponse fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(vo.getSupplierGroupId()), "EJCBT202506000003", "legalFile1", String.valueOf(vo.getId()), "BT211210000000001", "K1639384112713");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(vo.getSupplierGroupId()), "EJCBT202506000003", "businessLicenseFile", String.valueOf(vo.getId()), "BT211210000000001", "K1639384499212");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(vo.getSupplierGroupId()), "EJCBT202506000003", "accountPermitFile", String.valueOf(vo.getId()), "BT211210000000001", "K16393844992144");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierGroupVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SupplierGroupVO vo : vos) {
                SupplierGroupEntity entity = (SupplierGroupEntity)((Object)this.service.selectById(vo.getId()));
                CommonResponse supplierVOCommonResponse = this.iProSupplierApi.selectBySupplierGroupId(entity.getId());
                if (!supplierVOCommonResponse.isSuccess() || ((SupplierVO)supplierVOCommonResponse.getData()).getId() <= 0L) continue;
                return CommonResponse.error((String)("\u4f9b\u5e94\u5546" + entity.getName() + "\u5df2\u51c6\u5165\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierGroupVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("enterpriseNatureName");
        fuzzyFields.add("taxpayerNum");
        fuzzyFields.add("registerCountryName");
        fuzzyFields.add("areaName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierGroupVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("enterpriseNatureName");
        fuzzyFields.add("taxpayerNum");
        fuzzyFields.add("registerCountryName");
        fuzzyFields.add("areaName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SupplierGroup-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSupplierGroupData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierGroupVO>> refSupplierGroupData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("taxpayerNum");
        fuzzyFields.add("supplierType");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"supplierType")) {
                param.getParams().put("supplierType", new Parameter("like", (Object)"subPerson"));
            } else {
                param.getParams().put("supplierType", new Parameter("ne", (Object)"subPerson"));
            }
        } else {
            param.getParams().put("supplierType", new Parameter("ne", (Object)"subPerson"));
        }
        param.getParams().put("blacklistFlag", new Parameter("eq", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierGroupVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/pushSupplierToPool"})
    @ResponseBody
    public CommonResponse<SupplierGroupVO> pushSupplierToPool(@RequestBody Long id) {
        this.logger.info("id-{}", (Object)id);
        return this.service.pushSupplierToPool(id, true);
    }
}

