package com.ejianc.business.pro.supplier.service.appraise;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("pushProcessRuleBLogic")
public class PushProcessRuleBLogic implements IPushProcessRuleBLogic{
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "INCIDENT";//此处需要根据实际修改

    /**
     * 逻辑一
     *  查询合同池中状态为履约中的合同，当前时间-该合同上次推送评价时间（如无取合同签订时间）>=xx天
     * @param appraiseParamVO
     * @return
     */
    @Override
    public void logicOne(AppraiseParamVO appraiseParamVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus",new Parameter(QueryParam.EQ, ContractPerformanceStateEnum.履约中.getStateCode()));
        queryParam.getParams().put("sourceType",new Parameter(QueryParam.IN, Arrays.asList(new String[]{ContractTypeEnum.物资采购合同.getTypeCode(),
                ContractTypeEnum.混凝土合同.getTypeCode(),ContractTypeEnum.辅料中心周转材租赁合同.getTypeCode(),ContractTypeEnum.设备采购.getTypeCode(),
                ContractTypeEnum.设备租赁.getTypeCode(),ContractTypeEnum.劳务分包合同.getTypeCode(),ContractTypeEnum.专业分包合同.getTypeCode()})));
        CommonResponse<List<ContractPoolVO>> listCommonResponse = contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()){
            List<ContractPoolVO> contractPoolVOList = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(contractPoolVOList)){
                //当前时间-该合同上次推送评价时间（如无取合同签订时间）>=xx天
                List<ContractPoolVO> pushList = new ArrayList<>();
                contractPoolVOList.forEach(item->{
                    Date date = new Date();
                    QueryWrapper<IncidentEntity> wrapper = new QueryWrapper<>();
                    wrapper.eq("contract_id",item.getContractId());
                    wrapper.eq("performance_status",ContractPerformanceStateEnum.履约中.getStateCode());
                    wrapper.eq("dr",0);
                    wrapper.orderByDesc("date");
                    //查询当前合同在过程评价表中历史数据
                    List<IncidentEntity> list = incidentService.list(wrapper);
                    //如果有历史数据，取第一条，获取评价时间
                    if(CollectionUtils.isNotEmpty(list)){
                        date = list.get(0).getDate();
                    }else{
                        //没有，则取当前合同的合同签订时间
                        date = item.getSignDate();
                    }
                    int days = DateUtil.differentDays(new Date(), date);
                    //计算天数
                    days = Math.abs(days);
                    //天数大于等于平台设置的天数参数则推送过程评价
                    if(days>=appraiseParamVO.getSpaceLastDays()){
                        // 推送过程评价
                        pushList.add(item);
                    }
                });
                if(pushList.size()>0){
                    saveIncident(pushList);
                }
            }
        }
    }

    /**
     * 逻辑二
     *  查询合同池中 已终止的合同并推送
     * @param appraiseParamVO
     * @return
     */
    @Override
    public void logicTwo(AppraiseParamVO appraiseParamVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus",new Parameter(QueryParam.EQ, ContractPerformanceStateEnum.已终止.getStateCode()));
        queryParam.getParams().put("sourceType",new Parameter(QueryParam.IN, Arrays.asList(new String[]{ContractTypeEnum.物资采购合同.getTypeCode(),
                ContractTypeEnum.混凝土合同.getTypeCode(),ContractTypeEnum.辅料中心周转材租赁合同.getTypeCode(),ContractTypeEnum.设备采购.getTypeCode(),
                ContractTypeEnum.设备租赁.getTypeCode(),ContractTypeEnum.劳务分包合同.getTypeCode(),ContractTypeEnum.专业分包合同.getTypeCode()})));
        CommonResponse<List<ContractPoolVO>> listCommonResponse = contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()){
            List<ContractPoolVO> pushList = new ArrayList<>();
            //合同池数据
            List<ContractPoolVO> conList = listCommonResponse.getData();
            if(CollectionUtils.isNotEmpty(conList)){
                //获取合同池id集合
                List<Long> contractPoolIds = conList.stream().map(ContractPoolVO::getId).collect(Collectors.toList());
                QueryParam queryIncidentParam = new QueryParam();
                queryIncidentParam.getParams().put("contractId", new Parameter(QueryParam.IN, contractPoolIds));
                queryIncidentParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ,ContractPerformanceStateEnum.已终止.getStateCode()));
                //根据合同池id 查询否已经有状态为已终止的过程评价
                List<IncidentEntity> incidentList = incidentService.queryList(queryIncidentParam, false);
                Map<Long, IncidentEntity> map = incidentList.stream().collect(Collectors.toMap(k -> k.getContractId(), (k) -> k));
                if(incidentList.size() == 0){
                    pushList.addAll(conList);
                }else{
                    conList.forEach(item->{
                        if (!map.containsKey(item.getContractId())) {
                            pushList.add(item);
                        }
                    });
                }
                saveIncident(pushList);
            }
        }
    }

    /**
     * 生成过程评价数据
     * @param list
     */
    public void saveIncident(List<ContractPoolVO> list){
        List<IncidentEntity> pushList = new ArrayList<>();
        list.forEach(e->{
            IncidentEntity entity = new IncidentEntity();
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setContractId(e.getContractId());
            entity.setPerformanceStatus(e.getPerformanceStatus());
            entity.setStatus(0);
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            CommonResponse<UserVO> voCommonResponse =userApi.findUserByUserId(InvocationInfoProxy.getUserid());
            if(voCommonResponse.isSuccess()){
                UserVO user =voCommonResponse.getData();
                entity.setCreateUserName(user.getUserName());
                entity.setPhone(user.getUserMobile());
            }
            entity.setProcessId(sessionManager.getUserContext().getUserId());
            entity.setProcess(sessionManager.getUserContext().getUserName());
            entity.setContractType(e.getSourceTypeName());
            entity.setContractName(e.getContractName());
            entity.setProjectId(e.getProjectId());
            entity.setProjectName(e.getProjectName());
            entity.setContractAmount(e.getContractTaxMny());
            entity.setSupplyId(e.getPartybId());
            entity.setSupplyName(e.getPartyaName());
            entity.setSupplyQueryType(SupplyQueryTypeUtil.get("RULE_B",e.getSourceType()));
            entity.setCheckOrgId(sessionManager.getUserContext().getOrgId());
            entity.setCheckOrgName(sessionManager.getUserContext().getOrgName());
            entity.setDate(new Date());
            entity.setSource("定时推送");
            pushList.add(entity);
        });
        if(pushList.size()>0){
            incidentService.saveOrUpdateBatch(pushList,pushList.size());
        }
    }
}
