/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.pro.supplier.bean.YearEntity;
import com.ejianc.business.pro.supplier.mapper.YearMapper;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.YearVO;
import com.ejianc.business.warn.api.IWarningApi;
import com.ejianc.business.warn.vo.WarningParameterVO;
import com.ejianc.business.warn.vo.WarningVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="yearService")
public class YearServiceImpl
extends BaseServiceImpl<YearMapper, YearEntity>
implements IYearService {
    @Autowired
    private IWarningApi warningApi;
    @Autowired
    private YearMapper yearMapper;
    @Autowired
    private IProSupplierApi iProSupplierApi;
    private static String CODE = "WARNING000094";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public Map<Long, Integer> queryGrade(Map<String, List<Long>> map) {
        List<Long> suplyIds = map.get("suplyIds");
        List<YearEntity> yearEntities = this.yearMapper.queryGrade(suplyIds);
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        yearEntities.forEach(item -> resultMap.put(item.getSupplyId(), item.getYearDeduct()));
        return resultMap;
    }

    @Override
    public Map<Long, BigDecimal> queryTotalBranch(Map<String, List<Long>> map) {
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>();
        List<Long> suplyIds = map.get("suplyIds");
        if (CollectionUtils.isEmpty(suplyIds)) {
            return resultMap;
        }
        List<YearEntity> yearEntities = this.yearMapper.queryGrade(suplyIds);
        yearEntities.forEach(item -> resultMap.put(item.getSupplyId(), item.getTotalBranch()));
        return resultMap;
    }

    @Override
    public CommonResponse<String> syncYear(YearVO saveOrUpdateVO) {
        this.logger.info("i8\u4f20\u8f93-\u4f9b\u5e94\u5546\u4e8b\u4ef6\u5e74\u5ea6\u8bc4\u4ef7-\u63a5\u6536\u4f20\u53c2-saveOrUpdateVO" + JSONObject.toJSONString((Object)saveOrUpdateVO));
        String initContextUrl = this.baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        StringBuilder authtoken = new StringBuilder();
        try {
            CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            if (userContextResponse.isSuccess()) {
                JSONObject userContext = ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
                this.logger.info("\u62fc\u63a5\u9274\u6743\uff1a" + authtoken.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8c03\u5ea6\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38, ", (Throwable)e);
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
        CommonResponse byCode = this.warningApi.getWarningByCode(CODE);
        if (!byCode.isSuccess()) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u5e74\u5ea6\u8bc4\u4ef7\u5468\u671f\u65e5\u671f\uff01");
            return CommonResponse.success((String)"\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u5e74\u5ea6\u8bc4\u4ef7\u5468\u671f\u65e5\u671f\uff01");
        }
        String parameterValue = "01-01";
        if (CollectionUtils.isNotEmpty((Collection)((WarningVO)byCode.getData()).getWarningParameterList())) {
            for (WarningParameterVO warningParameterVO : ((WarningVO)byCode.getData()).getWarningParameterList()) {
                if (!"yearPushDate".equals(warningParameterVO.getParameterProperty())) continue;
                parameterValue = warningParameterVO.getParameterValue();
            }
        }
        String startDate = DateUtil.getYear() - 1 + "-" + parameterValue;
        String endDateStr = DateUtil.getYear() + "-" + parameterValue;
        ArrayList<String> createDataCodeList = new ArrayList<String>();
        ArrayList<Long> updateDataIdList = new ArrayList<Long>();
        ArrayList<String> updateDataCodeList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getUnitI8Code())) {
            return CommonResponse.error((String)"\u63a5\u53e3\u4f20\u8f93\u5931\u8d25\uff0ci8\u5355\u4f4d\u7f16\u7801\u672a\u4f20\u503c \uff01");
        }
        List yearListData = super.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"unit_i8_code", (Object)saveOrUpdateVO.getUnitI8Code())).between((Object)"handle_date", (Object)startDate, (Object)endDateStr));
        if (CollectionUtils.isNotEmpty((Collection)yearListData) && yearListData.size() > 0) {
            return CommonResponse.success((String)"\u63a5\u53e3\u4f20\u8f93\u5931\u8d25\uff0c\u8be5\u4f9b\u5e94\u5546\u672c\u5e74\u5ea6\u5df2\u63a8\u9001\uff01");
        }
        List yearList = super.list((Wrapper)new QueryWrapper().eq((Object)"unit_i8_code", (Object)saveOrUpdateVO.getUnitI8Code()));
        YearEntity yearEntity = null;
        CommonResponse listCommonResponse = this.iProSupplierApi.selectSupplierByUnitI8Code(saveOrUpdateVO.getUnitI8Code());
        if (!listCommonResponse.isSuccess()) {
            return CommonResponse.error((String)"\u672a\u627e\u5230\u5bf9\u5e94i8\u5355\u4f4d\u7f16\u7801\u4f9b\u5e94\u5546\uff0c\u8bf7\u63a8\u9001\u4f9b\u5e94\u5546\u540e\u518d\u505a\u8bc4\u4ef7\uff01");
        }
        SupplierDTO supplierDTO = (SupplierDTO)listCommonResponse.getData();
        this.logger.info("\u67e5\u51fa\u5bf9\u5e94\u4f9b\u5e94\u5546-----" + JSONObject.toJSONString((Object)supplierDTO));
        if (CollectionUtils.isNotEmpty((Collection)yearList) && yearList.size() > 0) {
            yearEntity = (YearEntity)((Object)yearList.get(0));
            updateDataCodeList.add(saveOrUpdateVO.getCode());
            updateDataIdList.add(saveOrUpdateVO.getId());
        } else {
            yearEntity = new YearEntity();
            yearEntity.setId(IdWorker.getId());
            yearEntity.setTenantId(999999L);
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"code", (Object)saveOrUpdateVO.getCode());
            List billCodeEntityList = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)billCodeEntityList)) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
            yearEntity.setCode(saveOrUpdateVO.getCode());
            createDataCodeList.add(saveOrUpdateVO.getCode());
        }
        yearEntity.setContractId(saveOrUpdateVO.getContractId());
        yearEntity.setContractName(saveOrUpdateVO.getContractName());
        yearEntity.setSupplyId(supplierDTO.getId());
        yearEntity.setSupplyName(supplierDTO.getSupplyTypeName());
        yearEntity.setThiYearNum(saveOrUpdateVO.getThiYearNum());
        yearEntity.setTotalAmount(saveOrUpdateVO.getTotalAmount());
        yearEntity.setCooperationProjectName(saveOrUpdateVO.getCooperationProjectName());
        yearEntity.setCooperationOrgName(saveOrUpdateVO.getCooperationOrgName());
        yearEntity.setTotalBranch(saveOrUpdateVO.getTotalBranch());
        yearEntity.setGradeName(saveOrUpdateVO.getGradeName());
        yearEntity.setGrade(saveOrUpdateVO.getGrade());
        yearEntity.setEndDate(saveOrUpdateVO.getEndDate());
        yearEntity.setUnitI8Code(saveOrUpdateVO.getUnitI8Code());
        yearEntity.setI8Url(saveOrUpdateVO.getI8Url());
        yearEntity.setStatus(1);
        yearEntity.setBillState(1);
        yearEntity.setSourceType("i8");
        if (null != supplierDTO.getMainBusinessCategory()) {
            if ("materialEquipment".equals(supplierDTO.getMainBusinessCategory()) || "revolvMaterial".equals(supplierDTO.getMainBusinessCategory()) || "equipment".equals(supplierDTO.getMainBusinessCategory())) {
                yearEntity.setSupplyQueryType("materialEquipment");
            } else if ("labor".equals(supplierDTO.getMainBusinessCategory()) || "major".equals(supplierDTO.getMainBusinessCategory())) {
                yearEntity.setSupplyQueryType("sub");
            } else {
                yearEntity.setSupplyQueryType("other");
            }
        }
        super.saveOrUpdate((Object)yearEntity, false);
        this.logger.info("i8\u4f20\u8f93-\u4f9b\u5e94\u5546\u4e8b\u4ef6\u8bc4\u4ef7-\u4fdd\u5b58\u6210\u529f-saveOrUpdateVO");
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }
}

