package com.ejianc.business.pro.supplier.controller.appraise;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.service.appraise.AppraiseService;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;

/**
 * @author songlx
 * @version 1.0
 * @description: 评价接口
 * @date 2022/4/24
 */
@Controller
@RequestMapping("appraise")
public class AppraiseController implements Serializable {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    IContractPoolApi contractPoolApi;

    @Autowired
    ISettlePoolApi settlePoolApi;

    @Autowired
    AppraiseService appraiseService;

    private static String RULE_CODE = "P-k202Ay57";

    @Autowired
    IParamConfigApi paramConfigApi;


    /**
     * 查询在从设置日期起，往前一年内 没有过程评价，生效的时间评价，存在履约中、已冻结合同的供应商，按照合同维度推送过程评价
     *
     * @return
     */
    @PostMapping(value = "/pushIncidentAppraiseAnnually")
    public CommonResponse<String> pushIncidentAppraiseAnnually(HttpServletRequest request) {
        //获取定时任务配置的参数
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        logger.info("供应商过程评价年度推送任务参数：{}", JSONObject.toJSONString(appraiseParamVO));
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            logger.info("未获取到供应商评价规则，规则编码:{}", RULE_CODE);
            return CommonResponse.success("未获取到供应商评价规则！");
        }
        appraiseParamVO.setRuleName(byCode.getData().getValueData());
        appraiseService.pushIncidentAppraiseAnnually(appraiseParamVO);

        return CommonResponse.success("供应商过程评价年度推送任务执行成功！");
    }

    /**
     * @description: 推送过程评价
     * @author songlx
     * @date: 2022/4/24
     */
    @PostMapping(value = "/pushProcessAppraise")
    public CommonResponse<AppraiseResultVO> pushProcessAppraise(HttpServletRequest request) {
        //获取定时任务配置的参数
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            logger.info("未获取到供应商评价规则，规则编码:{}", RULE_CODE);
            return CommonResponse.success("未获取到供应商评价规则！");
        }
        String ruleName = byCode.getData().getValueData();
        logger.info("获取到供应商评价规则，规则名称:{}", ruleName);
        appraiseParamVO.setRuleName(ruleName);
        AppraiseResultVO appraiseResultVO = appraiseService.pushProcessAppraise(appraiseParamVO);
        return CommonResponse.success(appraiseResultVO);
    }

    private AppraiseParamVO getParamVO(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("获取到的参数JSON是：" + param + "----");
        JSONArray parameters = json.getJSONObject(0).getJSONArray("parameters");
        AppraiseParamVO appraiseParamVO = new AppraiseParamVO();
        for (int i = 0; i < parameters.size(); i++) {
            JSONObject obj = parameters.getJSONObject(i);
            String property = (String) obj.get("property");
            if ("contractMny".equalsIgnoreCase(property)) {
                appraiseParamVO.setContractMny(obj.getBigDecimal("value"));
            } else if ("settleContractRatio".equalsIgnoreCase(property)) {
                appraiseParamVO.setSettleContractRatio(obj.getBigDecimal("value"));
            } else if ("spaceLastDays".equalsIgnoreCase(property)) {
                appraiseParamVO.setSpaceLastDays(obj.getInteger("value"));
            } else if ("yearPushDate".equalsIgnoreCase(property)) {
                appraiseParamVO.setYearPushDate(obj.getString("value"));
            }
            else if ("contractType".equalsIgnoreCase(property)){
                appraiseParamVO.setContractType(obj.getString("value"));
            }
        }
        return appraiseParamVO;
    }

    /**
     * @description: 推送年度评价
     * @author songlx
     * @date: 2022/4/24
     */
    @PostMapping(value = "/pushYearAppraise")
    public CommonResponse<AppraiseResultVO> pushYearAppraise(HttpServletRequest request) {
        //获取定时任务配置的参数
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            logger.info("未获取到供应商评价规则，规则编码:{}", RULE_CODE);
            return CommonResponse.success("未获取到供应商评价规则！");
        }
        appraiseParamVO.setRuleName(byCode.getData().getValueData());
        AppraiseResultVO appraiseResultVO = appraiseService.pushYearAppraise(appraiseParamVO);
        return CommonResponse.success(appraiseResultVO);
    }


}
