package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.SupplierGroupEntity;
import com.ejianc.business.pro.supplier.service.ISupplierGroupService;
import com.ejianc.business.pro.supplier.vo.SupplierGroupVO;

/**
 * 集团供应商库表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("supplierGroup")
public class SupplierGroupController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Autowired
    private IDefdocApi defdocApi;

    private static String SUPPLY_CODE = "pro-supply-can-in-org-nature";

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUPPLIER_GROUP";//此处需要根据实际修改

    @Autowired
    private ISupplierGroupService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierGroupVO> saveOrUpdate(@RequestBody SupplierGroupVO saveOrUpdateVO) {
    	SupplierGroupEntity entity = BeanMapper.map(saveOrUpdateVO, SupplierGroupEntity.class);

        //编号重复校验
        QueryWrapper<SupplierGroupEntity> query = new QueryWrapper();
        query.eq("code", saveOrUpdateVO.getCode());
        if(null != saveOrUpdateVO.getId()) {
            query.ne("id", saveOrUpdateVO.getId());
        }
        List<SupplierGroupEntity> billCodeEntityList = service.list(query);
        if(CollectionUtils.isNotEmpty(billCodeEntityList)) {
            return CommonResponse.error("保存失败，编码重复！");
        }

    	if(null == entity.getCode() && (entity.getId() == null || entity.getId() == 0)){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	if (null != entity.getSupplierType()){
            if ("enterprise".equals(entity.getSupplierType())) {
                entity.setSupplierTypeName("企业");
            } else if ("person".equals(entity.getSupplierType())) {
                entity.setSupplierTypeName("个人");
            } else if ("person,subPerson".equals(entity.getSupplierType())) {
                entity.setSupplierTypeName("个人,分包负责人");
            } else {
                entity.setSupplierTypeName("分包负责人");
            }
        }
        // 企业性质名称/单位属性
        Map<String, Long> defMap = new HashMap<>();
        if (null != entity.getEnterpriseNatureName()){
            CommonResponse<List<DefdocDetailVO>> defDocByDefCode = defdocApi.getDefDocByDefCode(SUPPLY_CODE);
            if(defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty(defDocByDefCode.getData())){
                defMap = defDocByDefCode.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getId));
            }
            entity.setEnterpriseNature(defMap.get(entity.getEnterpriseNatureName()));
        }

        if (null == entity.getSyncTime()){
            entity.setSyncTime(new Date());
        }
        entity.setLatestUpdateTime(new Date());
        service.saveOrUpdate(entity, false);
    	SupplierGroupVO vo = BeanMapper.map(entity, SupplierGroupVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }




    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierGroupVO> queryDetail(Long id) {
    	SupplierGroupEntity entity = service.selectById(id);
    	SupplierGroupVO vo = BeanMapper.map(entity, SupplierGroupVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description querySupplierGroupDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/querySupplierGroupDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierGroupVO> querySupplierGroupDetail(Long id) {
    	SupplierGroupEntity entity = service.selectById(id);
    	SupplierGroupVO vo = BeanMapper.map(entity, SupplierGroupVO.class);
    	vo.setSupplierGroupId(vo.getId());
    	vo.setId(IdWorker.getId());
        CommonResponse<String> fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(vo.getSupplierGroupId()), "EJCBT202506000003", "legalFile1",
                String.valueOf(vo.getId()), "BT211210000000001", "K1639384112713");//法人身份复印件
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(vo.getSupplierGroupId()), "EJCBT202506000003", "businessLicenseFile",
                String.valueOf(vo.getId()), "BT211210000000001", "K1639384499212");//营业执照
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(vo.getSupplierGroupId()), "EJCBT202506000003", "accountPermitFile",
                String.valueOf(vo.getId()), "BT211210000000001", "K16393844992144");//开户行许可证
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierGroupVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SupplierGroupVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                SupplierGroupEntity entity = service.selectById(vo.getId());
                CommonResponse<SupplierVO> supplierVOCommonResponse = iProSupplierApi.selectBySupplierGroupId(entity.getId());
                if (supplierVOCommonResponse.isSuccess() && null != supplierVOCommonResponse.getData() && supplierVOCommonResponse.getData().getId() > 0){
                    return CommonResponse.error("供应商" + entity.getName() + "已准入，不能删除！");
                }
            }
        }
        service.removeByIds(vos.stream().map(SupplierGroupVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierGroupVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("enterpriseNatureName");
        fuzzyFields.add("taxpayerNum");
        fuzzyFields.add("registerCountryName");
        fuzzyFields.add("areaName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        IPage<SupplierGroupEntity> page = service.queryPage(param,false);
        IPage<SupplierGroupVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierGroupVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("enterpriseNatureName");
        fuzzyFields.add("taxpayerNum");
        fuzzyFields.add("registerCountryName");
        fuzzyFields.add("areaName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<SupplierGroupEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SupplierGroup-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSupplierGroupData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierGroupVO>> refSupplierGroupData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("taxpayerNum");
        fuzzyFields.add("supplierType");
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("supplierType")){
                param.getParams().put("supplierType", new Parameter(QueryParam.LIKE, "subPerson"));
            }else {
                param.getParams().put("supplierType", new Parameter(QueryParam.NE, "subPerson"));
            }
        }else {
            param.getParams().put("supplierType", new Parameter(QueryParam.NE, "subPerson"));
        }
        //非黑名单
        param.getParams().put("blacklistFlag", new Parameter(QueryParam.EQ, 0));

        IPage<SupplierGroupEntity> page = service.queryPage(param,false);
        IPage<SupplierGroupVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierGroupVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




    /**
     * 更新供应商库
     *
     * @return
     */
    @PostMapping(value = "/pushSupplierToPool")
    @ResponseBody
    public CommonResponse<SupplierGroupVO> pushSupplierToPool(@RequestBody Long id) {
        logger.info("id-{}", id);
        return service.pushSupplierToPool(id, true);
    }
}
