package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.business.pro.rmat.api.IRentCalculateApi;
import com.ejianc.business.pro.supplier.consts.ComerateAnalysisEnum;
import com.ejianc.business.pro.supplier.service.ISupplierStatisticsService;
import com.ejianc.business.pro.supplier.vo.CooperateSourceBliVO;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.SourceBliVO;
import com.ejianc.business.prosub.api.IContractApi;
import com.ejianc.business.settle.api.ISettleApi;
import com.ejianc.business.settlement.api.IPurchaseSettleApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("ISupplierStatisticsService")
public class SupplierStatisticsImpl implements ISupplierStatisticsService {

    /**
     * 分包
     */
    @Autowired
    private IContractApi contractApi;
    /**
     * 物资
     */
    @Autowired
    private IBatPlanApi batPlanApi;
    /**
     * 设备采购
     */
    @Autowired
    private IPurchaseSettleApi purchaseSettleApi;
    @Autowired
    private ISettleApi settleApi;
    /**
     * 周转材管理
     */
    @Autowired
    private IRentCalculateApi rentCalculateApi;
    @Override
    public CommonResponse< List<CooperateSourceBliVO>> cooperateAnalysis(Long supplierId, String dateIn) {
        if (ComerateAnalysisEnum.THISYEAR.getCode().equals(dateIn)){
            dateIn= EJCDateUtil.getYear()+"";
        }
        else if (ComerateAnalysisEnum.ALLDATE.getCode().equals(dateIn)){
            dateIn=null;
        }
        //返回的信息
         List<CooperateSourceBliVO> resultList= new ArrayList<>();
        HashMap<String, List<BigDecimal>> linkedHashMap = new LinkedHashMap<>();
        CommonResponse<List<com.ejianc.business.promaterial.plan.vo.SourceBliVO>> materialSourceBliVO = batPlanApi.getSourceBliVO(supplierId, dateIn);
        if (materialSourceBliVO.isSuccess()){
            if (materialSourceBliVO.getData()!=null){
                List<com.ejianc.business.promaterial.plan.vo.SourceBliVO> list = materialSourceBliVO.getData();
                Map<String, SourceBliVO> map =
                        list.stream().collect(Collectors.toMap(k -> k.getType(), (k) -> k));
                if (map.containsKey("material")){
                    com.ejianc.business.promaterial.plan.vo.SourceBliVO material = map.get("material");
                    CooperateSourceBliVO cooperateSourceBliVO = new CooperateSourceBliVO();
                    cooperateSourceBliVO.setSourceNum(material.getSourceNum());
                    cooperateSourceBliVO.setCoordinationNum(material.getCoordinationNum());
                    if (material.getRatio()==null){
                        cooperateSourceBliVO.setRatio(BigDecimal.ZERO);
                    }else {
                        cooperateSourceBliVO.setRatio(material.getRatio());
                    }
                    cooperateSourceBliVO.setType(material.getType());
                    cooperateSourceBliVO.setName("材料管理");
                    resultList.add(cooperateSourceBliVO);
                }
                if (map.containsKey("concrete")){
                    com.ejianc.business.promaterial.plan.vo.SourceBliVO concrete = map.get("concrete");
                    CooperateSourceBliVO cooperateSourceBliVO = new CooperateSourceBliVO();
                    cooperateSourceBliVO.setSourceNum(concrete.getSourceNum());
                    cooperateSourceBliVO.setCoordinationNum(concrete.getCoordinationNum());
                    if (concrete.getRatio()==null){
                        cooperateSourceBliVO.setRatio(BigDecimal.ZERO);
                    }else {
                        cooperateSourceBliVO.setRatio(concrete.getRatio());
                    }
                    cooperateSourceBliVO.setType(concrete.getType());
                    cooperateSourceBliVO.setName("混凝土管理");
                    resultList.add(cooperateSourceBliVO);
                }
            }
        }
        CommonResponse<com.ejianc.business.pro.rmat.vo.SourceBliVO> rmatCommonResponse = rentCalculateApi.getSourceBliVO(supplierId, dateIn);
        if (rmatCommonResponse.isSuccess()){
            if (rmatCommonResponse.getData()!=null){
                com.ejianc.business.pro.rmat.vo.SourceBliVO rmatVo = rmatCommonResponse.getData();
                CooperateSourceBliVO cooperateSourceBliVO = new CooperateSourceBliVO();
                cooperateSourceBliVO.setSourceNum(rmatVo.getSourceNum());
                cooperateSourceBliVO.setCoordinationNum(rmatVo.getCoordinationNum());
                if (rmatVo.getRatio()==null){
                    cooperateSourceBliVO.setRatio(BigDecimal.ZERO);
                }else {
                    cooperateSourceBliVO.setRatio(rmatVo.getRatio());
                }
                cooperateSourceBliVO.setType(rmatVo.getType());
                cooperateSourceBliVO.setName("周转材管理");
                resultList.add(cooperateSourceBliVO);
            }
        }
        List<CooperateSourceBliVO> eqList = new ArrayList<>();
        CommonResponse<com.ejianc.business.settlement.vo.SourceBliVO> purchaseCommonResponse =
                purchaseSettleApi.getSourceBliVO(supplierId, dateIn);
        if (purchaseCommonResponse.isSuccess()){
            com.ejianc.business.settlement.vo.SourceBliVO data = purchaseCommonResponse.getData();
            CooperateSourceBliVO sourceBlivo = new CooperateSourceBliVO();
            sourceBlivo.setSourceNum(data.getSourceNum());
            sourceBlivo.setCoordinationNum(data.getCoordinationNum());
            sourceBlivo.setType(data.getType());
            eqList.add(sourceBlivo);
        }
        CommonResponse<com.ejianc.business.settle.vo.SourceBliVO> commonResponse = settleApi.getSourceBliVO(supplierId,
                dateIn);
        if (commonResponse.isSuccess()){
            com.ejianc.business.settle.vo.SourceBliVO data = commonResponse.getData();
            CooperateSourceBliVO sourceBlivo = new CooperateSourceBliVO();
            sourceBlivo.setSourceNum(data.getSourceNum());
            sourceBlivo.setCoordinationNum(data.getCoordinationNum());
            sourceBlivo.setType(data.getType());
            eqList.add(sourceBlivo);
        }
        BigDecimal sourceNum=BigDecimal.ZERO;
        BigDecimal coordinationNum=BigDecimal.ZERO;
        BigDecimal ratio=BigDecimal.ZERO;
        for (CooperateSourceBliVO sourceBliVO : eqList) {
            sourceNum= ComputeUtil.safeAdd(sourceBliVO.getSourceNum(),sourceNum);
            coordinationNum=ComputeUtil.safeAdd(sourceBliVO.getSourceNum(),coordinationNum);
        }
        ratio = ComputeUtil.safeDiv(sourceNum, coordinationNum);
        CooperateSourceBliVO cooperateSourceBliVO = new CooperateSourceBliVO();
        cooperateSourceBliVO.setSourceNum(sourceNum);
        cooperateSourceBliVO.setCoordinationNum(coordinationNum);
        cooperateSourceBliVO.setRatio(ratio);
        cooperateSourceBliVO.setType("equipment");
        cooperateSourceBliVO.setName("设备管理");
        resultList.add(cooperateSourceBliVO);
        CommonResponse<com.ejianc.business.prosub.vo.SourceBliVO> subCommonResponse = contractApi.getSourceBliVO(supplierId
                , dateIn);
        if (subCommonResponse.isSuccess()){
            com.ejianc.business.prosub.vo.SourceBliVO data = subCommonResponse.getData();
            if (data!=null){
                CooperateSourceBliVO vo = new CooperateSourceBliVO();
                vo.setSourceNum(data.getSourceNum());
                vo.setCoordinationNum(data.getCoordinationNum());
                if (data.getRatio()==null){
                    vo.setRatio(BigDecimal.ZERO);
                }else {
                    vo.setRatio(data.getRatio());
                }
                vo.setType(data.getType());
                vo.setName("分包管理");
                resultList.add(vo);
            }
        }
        return CommonResponse.success("查询详情数据成功！",resultList);
    }
}
