package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.bean.PunishEntity;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.PunishVO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;

@Service("punish") 
public class PunishBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IProSupplierApi iProSupplierApi;
	@Autowired
	private IPunishService punishService;
	@Autowired
	private IAbnormalService abnormalService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		PunishVO punishVO = new PunishVO();
		PunishEntity entity =punishService.selectById(billId);
		punishVO.setSupplierId(entity.getSupplyId());
		punishVO.setPunishType(entity.getPunishType());
		punishVO.setPunishDate(entity.getCreateTime());
		AbnormalEntity abnormalEntity= abnormalService.getById(entity.getPunishType());
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");//注意月份是MM

		try {
			if(abnormalEntity.getLastTime() != null){
				String exceptionEndDate =getLastMonthDate(entity.getCreateTime(),abnormalEntity.getLastTime());
				Date date = simpleDateFormat.parse(exceptionEndDate);
				punishVO.setExceptionEndDate(date);
			}else{
				Date date = simpleDateFormat.parse("3000-01-01");
				punishVO.setExceptionEndDate(date);
			}

		} catch (ParseException e) {
			e.printStackTrace();
		}

		punishVO.setPunishApplyOrg(entity.getApplyOrg());
		punishVO.setPunishApplyPerson(entity.getApplyPerson());
		punishVO.setPunishGrade(entity.getGradeName());
		punishVO.setPunishGradeId(entity.getGradeId());
		punishVO.setPunishMemo(entity.getMemo());
		punishVO.setPunishOldGrade(entity.getOldGradeName());
		CommonResponse<String> response =iProSupplierApi.punishSupplier(punishVO);
		if(response.isSuccess()){
			return CommonResponse.success();
		}else{
			return CommonResponse.error(response.getMsg());
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("供应商处置不支持撤回！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public static String getLastMonthDate(Date dataTime,int num)  {
		SimpleDateFormat sdf =   new SimpleDateFormat("yyyy-MM-dd");
		String date = sdf.format(dataTime);
		//时间字符串转 LocalDate 类型
		LocalDate today = LocalDate.parse(date);
		//当前月份+（-1）
		today = today.minusMonths(-num);
		//LocalDate日期格式是"YYYY-MM-DD"，只需要用toString()就可以转化成字符串类型
		return today.toString();
	}

}
