package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.IInvExpertLeaderService;
import com.ejianc.business.pro.supplier.service.IInvExpertService;
import com.ejianc.business.pro.supplier.service.IInvestigateModleService;
import com.ejianc.business.pro.supplier.service.ISubleaderCanInService;
import com.ejianc.business.pro.supplier.vo.InvExpertLeaderVO;
import com.ejianc.business.pro.supplier.vo.SubcontractYearVO;
import com.ejianc.business.pro.supplier.vo.SubleaderCanInVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SubleadersPushVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("subleaderCanIn") 
public class SubleaderCanInBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProSupplierApi iProSupplierApi;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private ISubleaderCanInService subleaderCanInService;
	@Autowired
	private IInvExpertLeaderService iInvExpertLeaderService;
	@Autowired
	private IInvestigateModleService iInvestigateModleService;
	@Autowired
	private IInvExpertService iInvExpertService;
	@Autowired
	private IPushMessageApi pushMessageApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("分包负责人 准入终审开始~~~~~{}",billId);

		SubleaderCanInEntity entity =subleaderCanInService.selectById(billId);
		if(entity == null){
			return CommonResponse.error("分包负责人准入单不存在！");
		}
		if(entity.getInvestigate() == null || !entity.getInvestigate()){
			//不需要考察 推送到共享中心
			return subleaderCanInService.pushSupplierToShare(billId);
		}else {
			//需要考察 推送生成 专家考察列表 和汇总列表
			InvExpertLeaderEntity leaderEntity = new InvExpertLeaderEntity();
			BillCodeParam billCodeParam = BillCodeParam.build("INVESTIGATE-EX", InvocationInfoProxy.getTenantid(), BeanMapper.map(leaderEntity, InvExpertLeaderVO.class));
			CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
			leaderEntity.setId(IdWorker.getId());
			if(billCode.isSuccess()) {
				leaderEntity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
			}else{
				leaderEntity.setCode(("HZ-"+ IdWorker.getId()).substring(0,8));//此处需要根据实际修改 删除本行或者下一行
			}
			leaderEntity.setCanInId(billId);
			leaderEntity.setSourceFrom("subLeader");
			leaderEntity.setBillState(0);
			leaderEntity.setSupplierName(entity.getSubLeaders());
			leaderEntity.setMainBusiness("labor");
			leaderEntity.setApplyOrgId(entity.getOrgId());
			leaderEntity.setApplyOrgName(entity.getOrgName());
			for (CanInExpertEntity expertEntity : entity.getExportList()) {
				if(expertEntity.getLeader()){
					leaderEntity.setLeader(expertEntity.getExpertName());
					leaderEntity.setLeaderId(expertEntity.getExpertId());
				}
			}
			leaderEntity.setExportIds(Strings.join(entity.getExportList().stream().map(CanInExpertEntity::getExpertId).collect(Collectors.toList()), ','));
			leaderEntity.setExportNames(Strings.join(entity.getExportList().stream().map(CanInExpertEntity::getExpertName).collect(Collectors.toList()), ','));
			leaderEntity.setSchedule("0/"+entity.getExportList().size());
			leaderEntity.setStartDate(new Date());
			leaderEntity.setScore(0);
			leaderEntity.setResult("不合格");
			leaderEntity.setGradeId(entity.getSubleaderCanInSubEntities().get(0).getGrade());
			iInvExpertLeaderService.saveOrUpdate(leaderEntity,false);
			List<InvestigateModleContentEntity> modelContentEntities = iInvestigateModleService.queryTypeName(leaderEntity.getMainBusiness());
			for (CanInExpertEntity canInExpertEntity : entity.getExportList()) {
				InvExpertEntity expertEntity = BeanMapper.map(leaderEntity,InvExpertEntity.class);
				expertEntity.setId(IdWorker.getId());
				expertEntity.setCollectId(leaderEntity.getId());
				billCode = billCodeApi.generateBillCode(billCodeParam);
				if(billCode.isSuccess()) {
					expertEntity.setCode(billCode.getData());
				}else{
					expertEntity.setCode(("HZ-"+ IdWorker.getId()).substring(0,8));
				}
				expertEntity.setCanSubId(canInExpertEntity.getId());
				expertEntity.setExportId(canInExpertEntity.getExpertId());
				expertEntity.setExportName(canInExpertEntity.getExpertName());
				expertEntity.setState("1");
				expertEntity.setScore(0);
				if(ListUtil.isNotEmpty(modelContentEntities)){
					for (InvestigateModleContentEntity modelContentEntity : modelContentEntities) {
						InvestigateContentEntity contentEntity = BeanMapper.map(modelContentEntity,InvestigateContentEntity.class);
						contentEntity.setId(IdWorker.getId());
						contentEntity.setPid(expertEntity.getId());
						contentEntity.setSubScore("0");
						expertEntity.getInvestigateContentEntities().add(contentEntity);
					}
				}
				iInvExpertService.saveOrUpdateNoES(expertEntity);
			}
			/** 发送消息 */
			PushMsgParameter parameter = new PushMsgParameter();
			List<String> channel = new ArrayList<>();
			// 系统消息
			channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
			channel.add(PushMsgParameter.CHANNEL_TYPE_DINGDING);
			JSONObject dingdingParams = new JSONObject();
			dingdingParams.put("maurl", "");
			dingdingParams.put("pcurl", "");
			dingdingParams.put("title", "您有一条新的分包负责人考察信息，分包负责人名称：【"+entity.getSubLeaders()+"】,请及时登录系统处理。");
			dingdingParams.put("content", "您有一条新的分包负责人考察信息，分包负责人名称：【"+entity.getSubLeaders()+"】,请及时登录系统处理。");
			parameter.setDingdingParams(dingdingParams);
			parameter.setReceivers(entity.getExportList().stream().map(CanInExpertEntity::getExpertId).map(String::valueOf).toArray(String[]::new));// 收信人
			parameter.setChannel(channel.toArray(new String[0]));// 消息类型
			parameter.setMsgType("notice");
			parameter.setSubject("您有一条新的分包负责人考察信息，分包负责人名称：【"+entity.getSubLeaders()+"】,请及时登录系统处理。");// 标题
			parameter.setContent( "您有一条新的分包负责人考察信息，分包负责人名称：【"+entity.getSubLeaders()+"】,请及时登录系统处理。");// 内容
			parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
			parameter.setSendUserId(InvocationInfoProxy.getUserid());
			try {
				CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
				if (result.isSuccess()) {
					logger.error("消息发送成功---------------->" + result.getMsg());
				} else {
					logger.error("消息发送失败---------------->" + result.getMsg());
				}
			} catch (Exception e) {
				logger.error("调用消息中心RPC服务异常--------------" + e);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("目前不支持撤回");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
