package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.service.ISubleadersService;
import com.ejianc.business.pro.supplier.vo.CanInVO;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.business.pro.supplier.vo.SubleadersVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.service.ISubcontractCanInService;
import com.ejianc.business.pro.supplier.vo.SubcontractCanInVO;

/**
 * 分包供应商准入表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subcontractCanIn")
public class SubcontractCanInController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "pro-supplier-code";//此处需要根据实际修改

    @Autowired
    private ISubcontractCanInService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISubleadersService subleadersService;

    @Autowired
    private IInviteService inviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi iProSupplierApi;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubcontractCanInVO> saveOrUpdate(@RequestBody SubcontractCanInVO saveOrUpdateVO) {
    	SubcontractCanInEntity entity = BeanMapper.map(saveOrUpdateVO, SubcontractCanInEntity.class);

    	//校验分包负责人是否重复
        List<SubleadersEntity> subLeaders = entity.getSubLeaders();
        if (CollectionUtils.isNotEmpty(subLeaders) && subLeaders.size() > 0){
            List<String> subLeaderIdNumList = subLeaders.stream().map(SubleadersEntity::getIdNum).collect(Collectors.toList());
            List<SubleadersEntity> subLeaderEntityList = service.checkSubLeader(subLeaderIdNumList, entity.getId());
            if (CollectionUtils.isNotEmpty(subLeaderEntityList) && subLeaderEntityList.size() > 0){
                throw new BusinessException("保存失败，该分包负责人" + JSONObject.toJSONString(subLeaderEntityList.stream().map(SubleadersEntity::getName).collect(Collectors.toList())) + "已被供应商-" + subLeaderEntityList.get(0).getSupplierName() + "引用");
            }
        }


        Boolean insertFlag = false;
        if(entity.getCode() == null){
            insertFlag = true;
        }
        if(insertFlag){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        entity.setSupplyQueryType(SupplierQueryType.laborSub);
        String headUserName="";
        if(CollectionUtils.isNotEmpty(entity.getSubLeaders())){
            for(SubleadersEntity subleadersEntity:entity.getSubLeaders()){
                headUserName+=subleadersEntity.getName()+",";
            }
        }
        if(CollectionUtils.isNotEmpty(entity.getHistory())){
            for(HistoryEntity historyEntity:entity.getHistory()){
                if(StringUtils.isNotEmpty(entity.getHeadUserName())){
                    headUserName+=historyEntity.getHeadUserName()+",";
                }
            }
        }
        if(StringUtils.isNotEmpty(headUserName)){
            headUserName = headUserName.substring(0,headUserName.length() -1);
            entity.setHeadUserName(headUserName);
        }

        CommonResponse<Boolean> same = iProSupplierApi.checkTaxpayerNumOrNameIsSame(saveOrUpdateVO.getTaxpayerNum(), saveOrUpdateVO.getName());
        if(!same.isSuccess() || (same.isSuccess()&&!same.getData())){
            logger.info("校验供应商准入前校验信息是否一致结果：{}",JSONObject.toJSONString(same));
            return CommonResponse.error(same.getMsg());
        }
        /** 校验供应商库 */
        CommonResponse<String> exist = iProSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getTaxpayerNum(), saveOrUpdateVO.getPersonal(),saveOrUpdateVO.getSupplyType());
        if(!exist.isSuccess()){
            return CommonResponse.error("供应商库中：该类型供应商已存在，不可重复新增!");
        }

        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum",new Parameter(QueryParam.EQ,saveOrUpdateVO.getTaxpayerNum()));
        String[] supplyType =  saveOrUpdateVO.getSupplyType().split(",");
        ComplexParam c = new ComplexParam();
        c.setLogic(ComplexParam.AND);
        for (int i = 0; i < supplyType.length; i++) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic(ComplexParam.OR);
            t.getParams().put("supplyType",new Parameter(QueryParam.LIKE,type));
            c.getComplexParams().add(t);
        }
        param.getComplexParams().add(c);

        if(!insertFlag && entity.getId() != null){
            param.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
        }
        List<SubcontractCanInEntity> entities = service.queryList(param);
        if(ListUtil.isNotEmpty(entities)){
            return CommonResponse.error("该供应商正在走【"+entities.get(0).getApplyOrgName()+"】的【"+entities.get(0).getSupplyTypeName()+"】准入流程，纳税人识别号重复!");
        }

        QueryParam params = new QueryParam();
        params.getParams().put("name",new Parameter(QueryParam.EQ,saveOrUpdateVO.getName()));
        c = new ComplexParam();
        c.setLogic(ComplexParam.AND);
        for (int i = 0; i < supplyType.length; i++) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic(ComplexParam.OR);
            t.getParams().put("supplyType",new Parameter(QueryParam.LIKE,type));
            c.getComplexParams().add(t);
        }
        params.getComplexParams().add(c);
        if(!insertFlag && entity.getId() != null){
            params.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
        }
        entities = service.queryList(params);
        if(CollectionUtils.isNotEmpty(entities)){
            return CommonResponse.error("该供应商正在走【"+entities.get(0).getApplyOrgName()+"】的【"+entities.get(0).getSupplyTypeName()+"】准入流程，名称重复!");
        }
        if(entity.getSupplyType().contains("labor") && ListUtil.isNotEmpty(entity.getSubLeaders())){
            /** 劳务供应商  同一个供应商下，同一个人只能加一次。用身份证号判断。 提示：分包负责人身份证号:xxxxx重复*/
            List<String> idCards = new ArrayList<>();
            for (SubleadersEntity subLeader : entity.getSubLeaders()) {
                if(idCards.contains(subLeader.getIdNum())){
                    return CommonResponse.error("分包负责人身份证号:"+subLeader.getIdNum()+"重复");
                }
                idCards.add(subLeader.getIdNum());
            }
        }
        service.saveOrUpdate(entity, false);
    	SubcontractCanInVO vo = BeanMapper.map(entity, SubcontractCanInVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractCanInVO> queryDetail(Long id) {
    	SubcontractCanInEntity entity = service.selectById(id);
    	SubcontractCanInVO vo = BeanMapper.map(entity, SubcontractCanInVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractCanInVO> vos) {

        QueryParam param = new QueryParam();
        for (SubcontractCanInVO vo : vos) {
            SubcontractCanInEntity entity = service.selectById(vo.getId());
            param.getParams().put("taxpayerNum",new Parameter(QueryParam.EQ,entity.getTaxpayerNum()));
            List<InviteEntity> list = inviteService.queryList(param);
            if(ListUtil.isNotEmpty(list)){
                for (InviteEntity inviteEntity : list) {
                    inviteEntity.setBillState(0);
                }
                inviteService.saveOrUpdateBatch(list);
            }
        }
        service.removeByIds(vos.stream().map(SubcontractCanInVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubcontractCanInVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("applyOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("supplyQueryType",new Parameter(QueryParam.EQ,"laborSub"));

        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("material_content");
        param.getFuzzyFields().add("equipment_content");
        param.getFuzzyFields().add("major_content");
        param.getFuzzyFields().add("apply_org_name");
        param.getFuzzyFields().add("taxpayerNum");


        IPage<SubcontractCanInEntity> page = service.queryPage(param,false);
        IPage<SubcontractCanInVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SubcontractCanInVO> records = BeanMapper.mapList(page.getRecords(), SubcontractCanInVO.class);

        pageData.setRecords(records);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubcontractCanInEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubcontractCanIn-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubcontractCanInData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubcontractCanInVO>> refSubcontractCanInData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubcontractCanInEntity> page = service.queryPage(param,false);
        IPage<SubcontractCanInVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractCanInVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 分包负责人
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubleadersData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubleadersVO>> refSubleadersData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.getLong("pid")!=null){
                param.getParams().put("pid",new Parameter(QueryParam.EQ,_con.getLong("pid")));
            }
        }

        IPage<SubleadersEntity> page = subleadersService.queryPage(param,false);
        IPage<SubleadersVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubleadersVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
    /**
     * @Description queryInviteEntityDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryInviteEntityDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractCanInVO> queryInviteEntityDetail(Long id,Long userId,String userName) {
        InviteEntity entity = inviteService.selectById(id);
        entity.setHandlePersonId(userId);
        entity.setHandlePerson(userName);
        entity.setHandleTime(new Date());
        entity.setBillState(1);

        InviteVO inviteVO = BeanMapper.map(entity, InviteVO.class);

        SubcontractCanInVO vo = BeanMapper.map(inviteVO, SubcontractCanInVO.class);
        vo.setId(null);
        vo.setCreateTime(null);
        vo.setInviteId(inviteVO.getId());
        vo.setApplyOrgId(InvocationInfoProxy.getOrgId());
        vo.setInOrOut(1);
        vo.setRegisterCountryName("中国");
        vo.setRegisterCountryId(493873812443236045L);
        vo.setBillState(0);
        vo.setCoordination(false);
        CommonResponse<SubcontractCanInVO> responseVO = saveOrUpdate(vo);
        if(responseVO.isSuccess()){
            vo = responseVO.getData();
            entity.setCanInNum(vo.getCode());
            inviteService.saveOrUpdate(entity);
            CommonResponse<String> fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K163938414458",
                    String.valueOf(vo.getId()), "BT211210000000001", "K1639384111794");//法人委托授权书
            fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K163938666354",
                    String.valueOf(vo.getId()), "BT211210000000001", "K1639384112713");//法人身份复印件
            fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1633365485",
                    String.valueOf(vo.getId()), "BT211210000000001", "K1639384499212");//营业执照
            fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1642125492056",
                    String.valueOf(vo.getId()), "BT211210000000001", "K1639384662753");//身份证正面
            fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1642125495124",
                    String.valueOf(vo.getId()), "BT211210000000001", "K1639384663721");//身份证反面
            fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1655538377522",
                    String.valueOf(vo.getId()), "BT211210000000001", "K16393844992144");//开户许可证
        }

        return responseVO;
    }

}
