/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.bean.BankEntity;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.CertsEntity;
import com.ejianc.business.pro.supplier.bean.SubleadersEntity;
import com.ejianc.business.pro.supplier.mapper.CanInMapper;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.impl.PunishBpmServiceImpl;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="canInService")
public class CanInServiceImpl
extends BaseServiceImpl<CanInMapper, CanInEntity>
implements ICanInService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IAbnormalService abnormalService;

    @Override
    public CommonResponse<String> afterInvestigate(Long canInId, Long gradeId, String gradeName) {
        CanInEntity canInEntity = (CanInEntity)((Object)this.selectById(canInId));
        canInEntity.setGradeId(gradeId);
        canInEntity.setGradeName(gradeName);
        canInEntity.setHasInvestigate(true);
        return this.pushSupplierToShare(canInEntity, "BT211210000000001");
    }

    @Override
    public CommonResponse<String> pushSupplierToShare(CanInEntity canInEntity, String billTypeCode) {
        Long billId = canInEntity.getId();
        SupplierVO supplierVO = (SupplierVO)BeanMapper.map((Object)((Object)canInEntity), SupplierVO.class);
        supplierVO.setTaxPayerIdentifier(canInEntity.getTaxpayerNum());
        supplierVO.setLegal(canInEntity.getLegalPerson());
        supplierVO.setBusinessScope(canInEntity.getBusinessRange());
        supplierVO.setBlTime(canInEntity.getTimeOut());
        supplierVO.setCoordination(canInEntity.getCoordination());
        supplierVO.setTenantUserName(canInEntity.getCoordinationName());
        supplierVO.setTenantPhone(canInEntity.getCoordinationPhone());
        supplierVO.setRegisterTime(canInEntity.getRegisterDate());
        supplierVO.setRegisteredCapital(canInEntity.getRegisterMny());
        supplierVO.setSupplyQueryType(canInEntity.getSupplyQueryType());
        supplierVO.setSupplierGroupId(canInEntity.getSupplierGroupId());
        supplierVO.setUnitI8Code(canInEntity.getUnitI8Code());
        if (!canInEntity.getBanks().isEmpty()) {
            ArrayList<BankAccountVO> list = new ArrayList<BankAccountVO>();
            for (BankEntity bank : canInEntity.getBanks()) {
                BankAccountVO vo1 = (BankAccountVO)BeanMapper.map((Object)((Object)bank), BankAccountVO.class);
                vo1.setBankAddress(bank.getAddress());
                list.add(vo1);
            }
            supplierVO.setBanks(list);
        }
        supplierVO.setAccessId(billId);
        if (canInEntity.getInException() != null && canInEntity.getInException().booleanValue()) {
            supplierVO.setInException(canInEntity.getInException());
            AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)this.abnormalService.getById(canInEntity.getPunishType()));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                if (abnormalEntity.getLastTime() != null) {
                    String exceptionEndDate = PunishBpmServiceImpl.getLastMonthDate(new Date(), abnormalEntity.getLastTime());
                    Date date = simpleDateFormat.parse(exceptionEndDate);
                    supplierVO.setExceptionEndDate(date);
                } else {
                    Date date = simpleDateFormat.parse("3000-01-01");
                    supplierVO.setExceptionEndDate(date);
                }
                supplierVO.setPunishApplyOrg(canInEntity.getApplyOrgName());
                supplierVO.setPunishDate(new Date());
                supplierVO.setPunishGrade(canInEntity.getGradeName());
                supplierVO.setPunishMemo("\u51c6\u5165\u65f6\u76f4\u63a5\u62c9\u9ed1\uff01");
                supplierVO.setPunishType(canInEntity.getPunishType());
            }
            catch (Exception e) {
                this.logger.info("\u51c6\u5165\u65f6\u5019 \u76f4\u63a5\u62c9\u9ed1\u51fa\u9519---{},----billId : {}", (Object)e.getMessage(), (Object)billId);
            }
        }
        this.logger.info("billTypeCode---{}", (Object)billTypeCode);
        CommonResponse fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "attachMgr", String.valueOf(billId), "BT200422000000028", "attachMgr");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384111794", String.valueOf(billId), "BT200422000000028", "K1639384111794");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384112713", String.valueOf(billId), "BT200422000000028", "K1639384112713");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384499212", String.valueOf(billId), "BT200422000000028", "K1639384499212");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384662753", String.valueOf(billId), "BT200422000000028", "K1639384662753");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384663721", String.valueOf(billId), "BT200422000000028", "K1639384663721");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K16393844992144", String.valueOf(billId), "BT200422000000028", "K16393844992144");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        if (ListUtil.isNotEmpty(canInEntity.getCerts())) {
            for (CertsEntity cert : canInEntity.getCerts()) {
                this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(cert.getId()), billTypeCode, "K1639386256873", String.valueOf(cert.getId()), "BT200422000000028", "K1639386256873");
            }
        }
        if (ListUtil.isNotEmpty(canInEntity.getSubLeaders())) {
            for (SubleadersEntity subLeader : canInEntity.getSubLeaders()) {
                this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(subLeader.getId()), billTypeCode, "K1639443798330", String.valueOf(subLeader.getId()), "BT200422000000028", "K1639443798330");
            }
        }
        this.logger.info("pushSupplierToShare----{}", (Object)JSONObject.toJSONString((Object)supplierVO));
        return this.iProSupplierApi.pushSupplierToShare(JSONObject.toJSONString((Object)supplierVO).getBytes(StandardCharsets.UTF_8));
    }
}

