package com.ejianc.business.pro.supplier.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 分包供应商考察
 * 
 * @author generator
 * 
 */
 @TableName("ejc_pro_supplier_investigate")
public class SubcontractInvestigateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 考察单位id
    @TableField(value="org_name")
    private String orgName; // 考察单位
    @TableField(value="member_id")
    private Long memberId; // 考察成员
    @TableField(value="member")
    private String member; // 考察成员
    @TableField(value="date")
    private Date date; // 考察日期
    @TableField(value="grade_id")
    private Long gradeId; // 评定等级
    @TableField(value="grade")
    private String grade; // 评定等级
    @TableField(value="process_id")
    private Long processId; // 经办人
    @TableField(value="process")
    private String process; // 经办人
    @TableField(value="memo")
    private String memo; // 综合评价
    @TableField(value="can_in_id")
    private Long canInId; // 准入表id
    @TableField(value="code")
    private String code; // 供应商编码
    @TableField(value="supply_query_type")
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub

    @TableField(exist=false)
    @SubEntity(serviceName="investigateContentService")
    private List<InvestigateContentEntity> investigateContentEntities = new ArrayList<>(); // 供应商考察内容

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }
    public String getMember() {
        return member;
    }

    public void setMember(String member) {
        this.member = member;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public Long getGradeId() {
        return gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    public String getGrade() {
        return grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }
    public Long getProcessId() {
        return processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }
    public String getProcess() {
        return process;
    }

    public void setProcess(String process) {
        this.process = process;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getCanInId() {
        return canInId;
    }

    public void setCanInId(Long canInId) {
        this.canInId = canInId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<InvestigateContentEntity> getInvestigateContentEntities() {
        return investigateContentEntities;
    }

    public void setInvestigateContentEntities(List<InvestigateContentEntity> investigateContentEntities) {
        this.investigateContentEntities = investigateContentEntities;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }
}
