package com.ejianc.business.pro.supplier.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.pro.supplier.bean.SubleaderCanInSubEntity;
/**
 * 分包供应商分包负责人准入
 * 
 * @author generator
 * 
 */
 @TableName("ejc_pro_supplier_subleader_allow_in")
public class SubleaderCanInEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="supply_id")
    private Long supplyId; // 供应商名称
    @TableField(value="supply_name")
    private String supplyName; // 供应商名称
    @TableField(value="supply_tax_num")
    private String supplyTaxNum; // 供应商纳税人识别号
    @TableField(value="apply_person")
    private String applyPerson; // 申请人
    @TableField(value="org_id")
    private Long orgId; // 申请单位
    @TableField(value="org_name")
    private String orgName; // 申请单位
    @TableField(value="apply_date")
    private java.util.Date applyDate; // 申请日期
    @TableField(value="supply_type_name")
    private String supplyTypeName; // 供应商类别
    @TableField(value="supply_content")
    private String supplyContent; // 供货内容
    @TableField(value="area")
    private String area; // 所在地区
    @TableField(value="supply_grade")
    private String supplyGrade; // 供应商等级
    @TableField(value="sub_leaders")
    private String subLeaders; // 分包负责人
    @TableField(value="sub_leaders_grade")
    private String subLeadersGrade; // 分包负责人等级
    @TableField(value="sub_leaders_grade_id")
    private String subLeadersGradeId;
    @TableField(value="supply_grade_id")
    private String supplyGradeId; // 供应商等级id
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(exist=false)
    @SubEntity(serviceName="subleaderCanInSubService")
    private List<SubleaderCanInSubEntity> subleaderCanInSubEntities = new ArrayList<>(); // 分包负责人准入--分包负责人

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 供应商名称
     */
    public Long getSupplyId() {
        return supplyId;
    }

    /**
     * 供应商名称
     */
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    /**
     * 供应商名称
     */
    public String getSupplyName() {
        return supplyName;
    }

    /**
     * 供应商名称
     */
    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    /**
     * 供应商纳税人识别号
     */
    public String getSupplyTaxNum() {
        return supplyTaxNum;
    }

    /**
     * 供应商纳税人识别号
     */
    public void setSupplyTaxNum(String supplyTaxNum) {
        this.supplyTaxNum = supplyTaxNum;
    }
    /**
     * 申请人
     */
    public String getApplyPerson() {
        return applyPerson;
    }

    /**
     * 申请人
     */
    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }
    /**
     * 申请单位
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 申请单位
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 申请单位
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 申请单位
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 申请日期
     */
    public java.util.Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(java.util.Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 供应商类别
     */
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    /**
     * 供应商类别
     */
    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    /**
     * 供货内容
     */
    public String getSupplyContent() {
        return supplyContent;
    }

    /**
     * 供货内容
     */
    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }
    /**
     * 所在地区
     */
    public String getArea() {
        return area;
    }

    /**
     * 所在地区
     */
    public void setArea(String area) {
        this.area = area;
    }
    /**
     * 供应商等级
     */
    public String getSupplyGrade() {
        return supplyGrade;
    }

    /**
     * 供应商等级
     */
    public void setSupplyGrade(String supplyGrade) {
        this.supplyGrade = supplyGrade;
    }
    /**
     * 分包负责人
     */
    public String getSubLeaders() {
        return subLeaders;
    }

    /**
     * 分包负责人
     */
    public void setSubLeaders(String subLeaders) {
        this.subLeaders = subLeaders;
    }
    /**
     * 分包负责人等级
     */
    public String getSubLeadersGrade() {
        return subLeadersGrade;
    }

    /**
     * 分包负责人等级
     */
    public void setSubLeadersGrade(String subLeadersGrade) {
        this.subLeadersGrade = subLeadersGrade;
    }
    
    /**
     * 分包负责人准入--分包负责人
     */
    public List<SubleaderCanInSubEntity> getSubleaderCanInSubEntities() {
        return subleaderCanInSubEntities;
    }

    /**
     * 分包负责人准入--分包负责人
     */
    public void setSubleaderCanInSubEntities(List<SubleaderCanInSubEntity> subleaderCanInSubEntities) {
        this.subleaderCanInSubEntities = subleaderCanInSubEntities;
    }

    public String getSubLeadersGradeId() {
        return subLeadersGradeId;
    }

    public void setSubLeadersGradeId(String subLeadersGradeId) {
        this.subLeadersGradeId = subLeadersGradeId;
    }

    public String getSupplyGradeId() {
        return supplyGradeId;
    }

    public void setSupplyGradeId(String supplyGradeId) {
        this.supplyGradeId = supplyGradeId;
    }
}
