package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.utils.OuterInterface;
import com.ejianc.business.pro.supplier.vo.BankVO;
import com.ejianc.business.pro.supplier.vo.CertsVO;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.util.QRCodeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.vo.CanInVO;

/**
 * 供应商准入表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("canIn")
public class CanInController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "pro-supplier-code";//此处需要根据实际修改

    @Autowired
    private ICanInService service;

    @Autowired
    private IInviteService inviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private QRCodeUtil qrCodeUtil;

    @Autowired
    private OuterInterface outerInterface;

    @Autowired
    private IProSupplierApi iProSupplierApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CanInVO> saveOrUpdate(@RequestBody CanInVO saveOrUpdateVO) {
    	CanInEntity entity = BeanMapper.map(saveOrUpdateVO, CanInEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(getBillCode(entity),InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        /** 校验供应商库 */
        CommonResponse<Boolean> same = iProSupplierApi.checkTaxpayerNumOrNameIsSame(saveOrUpdateVO.getTaxpayerNum(), saveOrUpdateVO.getName());
        if(!same.isSuccess() || (same.isSuccess()&&!same.getData())){
            return CommonResponse.error(same.getMsg());
        }
        CommonResponse<String> exist = iProSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getTaxpayerNum(), saveOrUpdateVO.getPersonal(),saveOrUpdateVO.getSupplyType());
        if(!exist.isSuccess()){
            return CommonResponse.error("供应商库中：该类型供应商已存在，不可重复新增!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum",new Parameter(QueryParam.EQ,saveOrUpdateVO.getTaxpayerNum()));
        String[] supplyType =  saveOrUpdateVO.getSupplyType().split(",");
        ComplexParam c = new ComplexParam();
        c.setLogic(ComplexParam.AND);
        for (int i = 0; i < supplyType.length; i++) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic(ComplexParam.OR);
            t.getParams().put("supplyType",new Parameter(QueryParam.LIKE,type));
            c.getComplexParams().add(t);
        }
        param.getComplexParams().add(c);

        if(entity.getId() != null){
            param.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
        }
        List<CanInEntity> entities = service.queryList(param);
        if(ListUtil.isNotEmpty(entities)){
            return CommonResponse.error("该供应商正在走【"+entities.get(0).getApplyOrgName()+"】的【"+entities.get(0).getSupplyTypeName()+"】准入流程，纳税人识别号重复!");
        }
    	/** 物资设备供应商 */
        entity.setSupplyQueryType(SupplierQueryType.materialEquipment);

        QueryParam params = new QueryParam();
        params.getParams().put("name",new Parameter(QueryParam.EQ,saveOrUpdateVO.getName()));
        c = new ComplexParam();
        c.setLogic(ComplexParam.AND);
        for (int i = 0; i < supplyType.length; i++) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic(ComplexParam.OR);
            t.getParams().put("supplyType",new Parameter(QueryParam.LIKE,type));
            c.getComplexParams().add(t);
        }
        params.getComplexParams().add(c);
        if(entity.getId() != null){
            params.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
        }
        entities = service.queryList(params);
        if(CollectionUtils.isNotEmpty(entities)){
            throw new BusinessException("该供应商正在走【"+entities.get(0).getApplyOrgName()+"】的【"+entities.get(0).getSupplyTypeName()+"】准入流程，名称重复!");
        }

        service.saveOrUpdate(entity, false);

        CanInVO vo = BeanMapper.map(entity, CanInVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    private String getBillCode(CanInEntity canInEntity){
        if("material".equals(canInEntity.getSupplyType())){
            return "pro-supplier-zr-wz";
        }else if("equipment".equals(canInEntity.getSupplyType())){
            return "pro-supplier-zr-sb";
        }else if("other".equals(canInEntity.getSupplyType())){
            return "pro-supplier-zr-qt";
        }
        return "pro-supplier-zr-wz";
    }
    /**
     * @Description saveOrUpdate 选择供应商信新增
     */
    @RequestMapping(value = "/saveSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CanInVO> saveSupplier(@RequestBody CanInVO saveOrUpdateVO) {

    	CanInEntity entity = BeanMapper.map(saveOrUpdateVO, CanInEntity.class);
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
        }else{

            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        if(entity.getInviteId()!=null){
            InviteEntity inviteEntity = inviteService.selectById(entity.getInviteId());
            inviteEntity.setCanInNum("1");
            inviteService.saveOrUpdate(inviteEntity,false);
        }
        /** 物资设备供应商 */
        entity.setSupplyQueryType(SupplierQueryType.materialEquipment);
        service.saveOrUpdate(entity, false);

        CanInVO vo = BeanMapper.map(entity, CanInVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CanInVO> queryDetail(Long id) {
    	CanInEntity entity = service.selectById(id);
    	CanInVO vo = BeanMapper.map(entity, CanInVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CanInVO> vos) {
        List<Long> ids = vos.stream().map(CanInVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<CanInEntity> canInEntityList = service.queryList(queryParam);
        List<Long> inviteIds = new ArrayList<>();
        if(canInEntityList.size() != 0){
            for(CanInEntity canInEntity:canInEntityList){
                if(canInEntity.getInviteId()!=null){
                    inviteIds.add(canInEntity.getInviteId());
                }
            }
        }
        if(ListUtil.isNotEmpty(inviteIds)){
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter(QueryParam.IN, inviteIds));
            List<InviteEntity> inviteEntities = inviteService.queryList(param);

            if(inviteEntities.size() != 0){
                for(InviteEntity inviteEntity : inviteEntities){
                    inviteEntity.setCanInNum("0");
                    inviteService.saveOrUpdate(inviteEntity);
                }
            }
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("material_content");
        param.getFuzzyFields().add("equipment_content");
        param.getFuzzyFields().add("major_content");
        param.getFuzzyFields().add("apply_org_name");
        param.getFuzzyFields().add("taxpayerNum");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("applyOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<CanInEntity> page = service.queryPage(param,false);
        IPage<CanInVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CanInVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CanInEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CanIn-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCanInData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> refCanInData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CanInEntity> page = service.queryPage(param,false);
        IPage<CanInVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CanInVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * @Description queryInviteEntityDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryInviteEntityDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CanInVO> queryInviteEntityDetail(Long id,String supplyType, Long userId,String userName) {
        InviteEntity entity = inviteService.selectById(id);


        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum",new Parameter(QueryParam.EQ,entity.getTaxpayerNum()));
        param.getParams().put("supplyType",new Parameter(QueryParam.EQ,entity.getSupplyType()));
        /** 校验准入表 */
        List<CanInEntity> canInEntities = service.queryList(param,false);
        if(ListUtil.isNotEmpty(canInEntities)){
            return CommonResponse.error("准入已存在该供应商，无法再次准入!");
        }

        entity.setHandlePersonId(userId);
        entity.setHandlePerson(userName);
        entity.setHandleTime(new Date());
        entity.setCanInNum("1");
        inviteService.saveOrUpdate(entity);
        InviteVO inviteVO = BeanMapper.map(entity, InviteVO.class);

        CanInVO vo = BeanMapper.map(inviteVO, CanInVO.class);
        if(supplyType.equals("material")){
            vo.setSupplyType("material");
        }else if(supplyType.equals("equipment")){
            vo.setSupplyType("equipment");
        }else if(supplyType.equals("other")){
            vo.setSupplyType("other");
        }
        vo.setId(IdWorker.getId());
        vo.setCreateTime(null);
        vo.setInviteId(inviteVO.getId());
        vo.setApplyOrgId(InvocationInfoProxy.getOrgId());
        vo.setInOrOut(1);
        BillCodeParam billCodeParam = BillCodeParam.build(getBillCode(BeanMapper.map(vo,CanInEntity.class)),InvocationInfoProxy.getTenantid(),vo);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            vo.setCode(billCode.getData());
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        vo.setRegisterCountryName("中国");
        vo.setApplyOrgName(iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData().getName());
        vo.setBillState(0);
        vo.setRegisterCountryId(493873812443236045L);
        if(ListUtil.isNotEmpty(vo.getBanks())){
            for (int i = 0; i < vo.getBanks().size(); i++) {
                BankVO bankVO = vo.getBanks().get(i);
                bankVO.setPid(vo.getId());
                bankVO.setId(IdWorker.getId());
                bankVO.setRowState("add");
            }
        }
        if(ListUtil.isNotEmpty(vo.getCerts())){
            for (int i = 0; i < vo.getCerts().size(); i++) {
                CertsVO certsVO = vo.getCerts().get(i);
                certsVO.setId(IdWorker.getId());
                certsVO.setRowState("add");
                certsVO.setPid(vo.getId());
            }
        }

        CommonResponse<CanInVO> responseVO = saveOrUpdate(vo);
        if(responseVO.isSuccess()){
            vo = responseVO.getData();
            CommonResponse<String> fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384111794",
                    String.valueOf(vo.getId()), "BT211210000000001", "K1639384111794");//法人委托授权书
            fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384112713",
                    String.valueOf(vo.getId()), "BT211210000000001", "K1639384112713");//法人身份复印件
            fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384499212",
                    String.valueOf(vo.getId()), "BT211210000000001", "K1639384499212");//营业执照
            fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384662753",
                    String.valueOf(vo.getId()), "BT211210000000001", "K1639384662753");//身份证正面
            fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384663721",
                    String.valueOf(vo.getId()), "BT211210000000001", "K1639384663721");//身份证反面
        }

        return responseVO;
    }

    /**
     * 获取二维码实例
     * @return
     */
    @RequestMapping(value = "/getQrCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getQrCode(){
        return CommonResponse.success("",qrCodeUtil.getBase64QRCode("https://www.baidu.com/"));
    }

    /**
     * 获取营业执照ocr信息
     * @return
     */
    @RequestMapping(value = "/getLicenceOcrInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getLicenceOcrInfo(@RequestParam String imageUrl){
        return CommonResponse.success("",JSONObject.parseObject(JSONObject.toJSONString(outerInterface.getBusinessLicenseInfoFromBaidu(imageUrl))));
    }

    /**
     * 获取身份证ocr信息
     * @return
     */
    @RequestMapping(value = "/getIdCardOcrInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getIdCardOcrInfo(@RequestParam String imageUrl){
        return CommonResponse.success("",JSONObject.parseObject(JSONObject.toJSONString(outerInterface.getIdCardInfoFromBaidu(imageUrl))));
    }

    /**
     * 校验企业信息是否通过
     * @return
     */
    @RequestMapping(value = "/checkEnterprise", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkEnterprise(@RequestParam("name") String name,@RequestParam("code") String code){
        return CommonResponse.success("成功",outerInterface.checkEnterpriseFromQcc(name,code));
    }

    /**
     * 校验企业信息是否通过
     * @return
     */
    @RequestMapping(value = "/checkPerson", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkPerson(@RequestParam("name") String name,@RequestParam("code") String code){
        return CommonResponse.success("成功",outerInterface.checkPersonFromAly(name,code));
    }

}
