package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.vo.GradeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商等级设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("grade")
public class GradeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IGradeService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GradeVO> saveOrUpdate(@RequestBody GradeVO saveorUpdateVO) {
    	GradeEntity entity = BeanMapper.map(saveorUpdateVO, GradeEntity.class);
    	service.saveOrUpdate(entity, false);
    	GradeVO vo = BeanMapper.map(entity, GradeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @GetMapping(value = "/getOneByWeight")
    @ResponseBody
    public CommonResponse<GradeVO> getOneByWeight(@RequestParam Integer weight) {
        GradeVO resp = null;
        QueryWrapper<GradeEntity> query = new QueryWrapper<>();
        query.eq("weight", weight);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<GradeEntity> list = service.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.map(list.get(0), GradeVO.class);
        }
        return CommonResponse.success(resp);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GradeVO> queryDetail(Long id) {
    	GradeEntity entity = service.selectById(id);
    	GradeVO vo = BeanMapper.map(entity, GradeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GradeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (GradeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                 CommonResponse<String> resp = billTypeApi.checkQuote("BT211225000000005", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }
            }
        }
        service.removeByIds(vos.stream().map(GradeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GradeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("weight", "desc");
        param.setOrderMap(orderMap);
        IPage<GradeEntity> page = service.queryPage(param,false);
        IPage<GradeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), GradeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<GradeVO>> list(){
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("weight", "desc");
        param.setOrderMap(orderMap);
        List<GradeEntity> list =service.queryList(param);
        List<GradeVO> voList =BeanMapper.mapList(list, GradeVO.class);
        return CommonResponse.success("查询列表数据成功！",voList);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<GradeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Grade-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refGradeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<GradeVO>> refGradeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.getBoolean("allowInCanUse")!=null){
                param.getParams().put("allowInCanUse", new Parameter(QueryParam.EQ, _con.getBoolean("allowInCanUse")));
            }

            if(_con.getBoolean("investigate")!=null){
                param.getParams().put("investigate", new Parameter(QueryParam.EQ, _con.getBoolean("investigate")));
            }
            if(_con.getString("operationMap") != null){
                Map<String,String>  operationMap = (Map<String, String>) _con.get("operationMap");
                if(operationMap.containsKey("=")){
                    param.getParams().put("weight", new Parameter(QueryParam.EQ,operationMap.get("=")));
                }else if(operationMap.containsKey(">")){
                    param.getParams().put("weight", new Parameter(QueryParam.GT,operationMap.get(">")));
                }else if(operationMap.containsKey("<")){
                    param.getParams().put("weight", new Parameter(QueryParam.LT,operationMap.get("<")));
                }else if(operationMap.containsKey(">=")){
                    param.getParams().put("weight", new Parameter(QueryParam.GE,operationMap.get(">=")));
                }else if(operationMap.containsKey("<=")){
                    param.getParams().put("weight", new Parameter(QueryParam.LE,operationMap.get("<=")));
                }
                param.getParams().remove("operationMap");
            }
        }

        IPage<GradeEntity> page = service.queryPage(param,false);
        IPage<GradeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GradeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @RequestMapping(value = "/getDefaultGrade", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GradeVO> getDefaultGrade(@RequestParam("weight") Integer weight){
        QueryParam param = new QueryParam();

        param.getParams().put("weight",new Parameter(QueryParam.EQ,weight));
        List<GradeEntity> list = service.queryList(param);
        if(ListUtil.isNotEmpty(list)){
            return  CommonResponse.success(BeanMapper.map(list.get(0),GradeVO.class));
        }
        return CommonResponse.error("没有查到默认等级！");
    }
}
