package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.pro.supplier.bean.InvestigateModleContentEntity;
import com.ejianc.business.pro.supplier.service.IInvestigateModleContentService;
import com.ejianc.business.pro.supplier.utils.ExcelImportUtil;
import com.ejianc.business.pro.supplier.vo.CommentModleContentVO;
import com.ejianc.business.pro.supplier.vo.InvestigateModleContentVO;
import com.ejianc.business.pro.supplier.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.InvestigateModleEntity;
import com.ejianc.business.pro.supplier.service.IInvestigateModleService;
import com.ejianc.business.pro.supplier.vo.InvestigateModleVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 供应商考察模板
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("investigateModle")
public class InvestigateModleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IInvestigateModleService service;

    @Autowired
    private IInvestigateModleContentService investigateModleContentService;


    private static final String CODE = "INVESTIGATE_MODLE";//此处需要根据实际修改

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvestigateModleVO> saveOrUpdate(@RequestBody InvestigateModleVO saveorUpdateVO) {
    	InvestigateModleEntity entity = BeanMapper.map(saveorUpdateVO, InvestigateModleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> code = billCodeApi.getCodeBatchByRuleCode(CODE, InvocationInfoProxy.getTenantid());
            if(code.isSuccess()) {
                entity.setCode(code.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            List<InvestigateModleContentVO> listbs = saveorUpdateVO.getInvestigateModleContentEntities();
            listbs.forEach(e->{
                e.setId(null);
            });
        }

        service.saveOrUpdates(entity);

        InvestigateModleVO vo = BeanMapper.map(entity, InvestigateModleVO.class);
        vo.setInvestigateModleContentEntities(TreeNodeBUtil.buildTree(vo.getInvestigateModleContentEntities()));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvestigateModleVO> queryDetail(Long id) {
    	InvestigateModleEntity entity = service.selectById(id);

    	InvestigateModleVO vo = BeanMapper.map(entity, InvestigateModleVO.class);
        if(CollectionUtils.isNotEmpty(entity.getInvestigateModleContentEntities())){
            vo.setInvestigateModleContentEntities(TreeNodeBUtil.buildTree(vo.getInvestigateModleContentEntities()));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvestigateModleVO> queryCopyDetail(Long id) {
        InvestigateModleEntity entity = service.selectById(id);

        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(entity.getInvestigateModleContentEntities())){
            entity.getInvestigateModleContentEntities().forEach(vo -> {
                vo.setRowState("add");
            });
        }
        InvestigateModleVO vo = BeanMapper.map(entity, InvestigateModleVO.class);
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(vo.getInvestigateModleContentEntities())){
            vo.setInvestigateModleContentEntities(TreeNodeBUtil.buildTree(vo.getInvestigateModleContentEntities()));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvestigateModleVO> vos) {
        service.removeByIds(vos.stream().map(InvestigateModleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvestigateModleVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvestigateModleEntity> page = service.queryPage(param,false);
        IPage<InvestigateModleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvestigateModleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InvestigateModleEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InvestigateModle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refInvestigateModleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InvestigateModleVO>> refInvestigateModleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        String supplyType =null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            JSONObject conditionJson = JSONObject.parseObject(condition);
            supplyType = conditionJson.getString("supplyType");
        }
        //类型
        if(StringUtils.isNotEmpty(supplyType)){
            param.getParams().put("supplyType", new Parameter(QueryParam.IN, supplyType));
        }
        IPage<InvestigateModleEntity> page = service.queryPage(param,false);
        IPage<InvestigateModleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvestigateModleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 根据主表id查询子数据
     * @param zid
     * @return
     */
    @RequestMapping(value = "/querySubList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<InvestigateModleContentVO>> querySubList(Long zid) {
        QueryParam param = new QueryParam();
        param.getParams().put("zid", new Parameter(QueryParam.EQ, zid));
        List<InvestigateModleContentEntity> list =investigateModleContentService.queryList(param);
        List<InvestigateModleContentVO> voList =BeanMapper.mapList(list,InvestigateModleContentVO.class);
        return CommonResponse.success("查询数据成功！",voList);
    }

    /**
     * 根据主表id查询子数据
     * @param zid
     * @return
     */
    @RequestMapping(value = "/queryTypeNameList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<InvestigateModleContentVO>> queryTypeNameList(String supplyTypeName) {
        List<InvestigateModleContentEntity> list =service.queryTypeName(supplyTypeName);
        List<InvestigateModleContentVO> voList =BeanMapper.mapList(list,InvestigateModleContentVO.class);

        return CommonResponse.success("查询数据成功！",voList);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "investigateModle-import.xlsx", "评价内容导入模板");
    }

    /**
     * 导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<InvestigateModleContentVO> detailVoList = new ArrayList<>();
                Map<String, Long> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    InvestigateModleContentVO vo = new InvestigateModleContentVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    //维护父子关系
                    Long id = Long.valueOf(IdWorker.getId());
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }else{
                            vo.setParentId(999L);
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                        vo.setParentId(999L);
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(0))) {
                        vo.setCode(null);
                        flag = true;
                    } else {
                        vo.setCode(datas.get(0));
                    }

                    if (StringUtils.isNotEmpty(datas.get(1))) {
                        vo.setNameContent(datas.get(1));
                    }

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setShadowId(vo.getTid());
                    vo.setRowState("add");
                    detailVoList.add(vo);
                }

                for (InvestigateModleContentVO tVo : detailVoList) {
                    tVo.setTpid(String.valueOf(tidMap.get(tVo.getTpid())));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - 1 - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    /**
     * 修改状态
     * @param param
     * @return
     */
    @RequestMapping(value = "/updateState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateState(@RequestBody Map<String,String> param){
        Long id = Long.parseLong(param.get("id"));
        Boolean state =  Boolean.parseBoolean(param.get("state"));
        service.updateState(id,state);
        return CommonResponse.success("修改状态成功!");
    }
}
