package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IInviteLinkService;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.utils.OuterInterface;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.api.IBankApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 供应商准入邀请表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("noAuth/invite")
public class InviteNoAuthController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBankApi bankApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IInviteService service;

    @Autowired
    private OuterInterface outerInterface;

    @Autowired
    private ICanInService iCanInService;

    @Autowired
    private IInviteLinkService iInviteLinkService;

    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRoleApi roleApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdate(@RequestBody InviteVO saveorUpdateVO) {
        logger.info("无鉴权新增或者修改:{}",JSONObject.toJSONString(saveorUpdateVO));
        if(StringUtils.isEmpty(saveorUpdateVO.getTaxpayerNum())){
            if("e".equals(saveorUpdateVO.getPersonal())){
                return CommonResponse.error("纳税人识别号不能为空");
            }
            return CommonResponse.error("身份证号不能为空");
        }
        CommonResponse<String> exist = service.checkExist(saveorUpdateVO.getId(),saveorUpdateVO.getTaxpayerNum(),saveorUpdateVO.getPersonal(),saveorUpdateVO.getName());
        if(!exist.isSuccess()){
            return CommonResponse.error("供应商已存在，不可重复提交!");
        }
        InviteEntity entity = BeanMapper.map(saveorUpdateVO, InviteEntity.class);
        if(entity.getId() == null){
            entity.setCode("S-"+ IdWorker.getId());
        }
        entity.setTenantId(999999L);
        service.saveOrUpdate(entity, false);
        InviteVO vo = BeanMapper.map(entity, InviteVO.class);
        entity.setCanInNum("0");
        if(entity.getCheckResult() ==1){
            entity.setBillState(1);
            SupplierVO supplierVO = BeanMapper.map(entity,SupplierVO.class);
            QueryParam params = new QueryParam();
            params.getParams().put("id",new Parameter(QueryParam.IN,saveorUpdateVO.getInviteId()));

            List<InviteLinkEntity> linkEntityList = iInviteLinkService.queryList(params);
            for(InviteLinkEntity linkEntity:linkEntityList){
                supplierVO.setOrgId(linkEntity.getOrgId());
                supplierVO.setOrgName(linkEntity.getOrgName());
            }
            supplierVO.setTaxPayerIdentifier(vo.getTaxpayerNum());//纳税人识别号/身份证号
            supplierVO.setLegal(vo.getLegalPerson());//法人代表/别名
            supplierVO.setBusinessScope(vo.getBusinessRange());//经营范围
            supplierVO.setBlTime(vo.getTimeOut());//营业执照有效期
            supplierVO.setRegisterTime(vo.getRegisterDate());//注册日期
            supplierVO.setRegisteredCapital(vo.getRegisterMny());// 注册资金
            supplierVO.setSupplyQueryType(vo.getSupplyQueryType());//查询类型
            supplierVO.setName(entity.getName());
            if(!entity.getBanks().isEmpty()){
                List<BankAccountVO> list = new ArrayList<>();
                for (BankEntity bank : entity.getBanks()) {
                    BankAccountVO vo1 = BeanMapper.map(bank,BankAccountVO.class);
                    vo1.setBankAddress(bank.getAddress());
                    vo1.setDefaultFlag(bank.getDefaultable());
                    vo1.setSupplierId(bank.getPid());
                    vo1.setSupplierFlag(1);
                    vo1.setSupplierCode(supplierVO.getCode());
                    vo1.setCategoryId(bank.getCategoryId());
                    vo1.setCategoryName(bank.getCategoryName());
                    vo1.setBankAccount(bank.getBankAccount());

                    if(vo1.getDefaultFlag() == null){
                        vo1.setDefaultFlag(0);
                    }
                    list.add(vo1);
                }
                supplierVO.setBanks(list);
            }

            logger.info("pushSupplierToShare----{}", JSONObject.toJSONString(supplierVO));
            bankApi.pushToBank(JSONObject.toJSONString(supplierVO).getBytes(StandardCharsets.UTF_8));
        }

        service.saveOrUpdate(entity, false);
        if(entity.getCheckResult() !=1){
            // 发消息
            List<Long> roleList = new ArrayList<>();
            List<String> list = new ArrayList();
            roleList.add(586487600554999860L);
            CommonResponse<List<RoleUserRelationVO>> commonResponse =roleApi.getRoleUser(roleList,null);
            logger.info("data{}",commonResponse.getCode());
            if(commonResponse.isSuccess()){
                for(RoleUserRelationVO roleUserRelationVO:commonResponse.getData()){
                    list.add(roleUserRelationVO.getUserId()+"");
                    logger.info("role{}",roleUserRelationVO.getUserId());

                }
            }
            String url = baseHost+"ejc-prosupplier-frontend/#/invitationSupplier/enterpriseCard?id="+entity.getId();
            logger.info("发送消息开始！===========");
            logger.info("list{}",list.size());
            PushMsgParameter parameter = new PushMsgParameter();
            List<String> channel = new ArrayList<>();
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
            parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
            parameter.setReceivers(list.toArray(new String[list.size()]));// 收信人
            parameter.setMsgType("notice");
            parameter.setSubject("您有一个新供应商准入消息");// 标题
            if(saveorUpdateVO.getPersonal().equals("p")){
                url.replace("enterpriseCard","personalCard");
            }
            parameter.setContent( "【<a href="+'"'+url+'"'+">"+entity.getName()+"</a>】供应商，信息未审核通过！提交时间："+ DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT,new Date()) +",请及时处理！");// 内容
            parameter.setTenantId("999999");
            //parameter.setSendUserId(InvocationInfoProxy.getUserid());
            /*try {
                CommonResponse<String> result = pushMessageApi.pushNoAuthMessage(parameter);
                if (result.isSuccess()) {
                    logger.error("消息发送成功---------------->" + result.getMsg());
                } else {
                    logger.error("消息发送失败---------------->" + result.getMsg());
                }
            } catch (Exception e) {
                logger.error("调用消息中心RPC服务异常--------------" + e);
            }*/
        }
        return CommonResponse.success("提交成功！",vo);
    }

    @RequestMapping(value = "/checkExist", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkExist(Long id,String taxNum,String personal){
        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum",new Parameter(QueryParam.EQ,taxNum));
        List<InviteEntity> list = service.queryList(param,false);

        /** 校验供应商库 */
        CommonResponse<String> exist = iProSupplierApi.judgeTaxpayerNumIsRepeat(taxNum, personal,"-");
        if(!exist.isSuccess()){
            return CommonResponse.error("该供应商已经在供应商库，无需再次提交！");
        }
        /** 校验准入表 */
        List<CanInEntity> canInEntities = iCanInService.queryList(param,false);
        if(ListUtil.isNotEmpty(canInEntities)){
            throw new BusinessException("该供应商正在走【"+canInEntities.get(0).getApplyOrgName()+"】的【"+canInEntities.get(0).getSupplyTypeName()+"】准入流程，无需再次提交！");
        }
        /** 校验邀请表 */
        if(id == null && ListUtil.isNotEmpty(list)){
            return CommonResponse.error("该供应商在邀请流程中，不可重复提交!");
        } else if(id != null && ListUtil.isNotEmpty(list) && !list.get(0).getId().equals(id)){
            return CommonResponse.error("该供应商在邀请流程中，不可重复提交!");
        }
        return CommonResponse.success();
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteVO> queryDetail(Long id) {
    	InviteEntity entity = service.selectById(id);
    	InviteVO vo = BeanMapper.map(entity, InviteVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteVO> vos) {
        service.removeByIds(vos.stream().map(InviteVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InviteEntity> page = service.queryPage(param,false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Invite-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> refInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InviteEntity> page = service.queryPage(param,false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 获取营业执照ocr信息
     * @return
     */
    @RequestMapping(value = "/getLicenceOcrInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getLicenceOcrInfo(@RequestParam String imageUrl){
        return CommonResponse.success("",JSONObject.parseObject(JSONObject.toJSONString(outerInterface.getBusinessLicenseInfoFromBaidu(imageUrl))));
    }

    /**
     * 获取身份证ocr信息
     * @return
     */
    @RequestMapping(value = "/getIdCardOcrInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getIdCardOcrInfo(@RequestParam String imageUrl){
        return CommonResponse.success("",JSONObject.parseObject(JSONObject.toJSONString(outerInterface.getIdCardInfoFromBaidu(imageUrl))));
    }

    /**
     * 校验企业信息是否通过
     * @return
     */
    @RequestMapping(value = "/checkEnterprise", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkEnterprise(@RequestParam("name") String name,@RequestParam("code") String code){
        return CommonResponse.success("成功",outerInterface.checkEnterpriseFromQcc(name,code));
    }

    /**
     * 校验人员信息是否通过
     * @return
     */
    @RequestMapping(value = "/checkPerson", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkPerson(@RequestParam("name") String name,@RequestParam("code") String code){
        return CommonResponse.success("成功",outerInterface.checkPersonFromAly(name,code));
    }
}
