package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.vo.CanInVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.LimitEntity;
import com.ejianc.business.pro.supplier.service.ILimitService;
import com.ejianc.business.pro.supplier.vo.LimitVO;

/**
 * 供应商限额设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("limit")
public class LimitController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ILimitService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LimitVO> saveOrUpdate(@RequestBody LimitVO saveorUpdateVO) {
    	LimitEntity entity = BeanMapper.map(saveorUpdateVO, LimitEntity.class);
        QueryParam param = new QueryParam();
        param.getParams().put("supplyType",new Parameter(QueryParam.EQ,saveorUpdateVO.getSupplyType()));
        param.getParams().put("contentId",new Parameter(QueryParam.EQ,saveorUpdateVO.getContentId()));
        param.getParams().put("supplyTypeName",new Parameter(QueryParam.EQ,saveorUpdateVO.getSupplyTypeName()));

        if(saveorUpdateVO.getId() != null){
            param.getParams().put("id",new Parameter(QueryParam.EQ,saveorUpdateVO.getId()));
        }


        List<LimitEntity> list =service.queryList(param);
        if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
            return CommonResponse.error("供应商类型不能重复！");
        }

        if(CollectionUtil.isNotEmpty(saveorUpdateVO.getTableWidget())){
            for (LimitVO vo : saveorUpdateVO.getTableWidget()){
                LimitEntity en = BeanMapper.map(vo, LimitEntity.class);
                en.setSupplyTypeName(entity.getSupplyTypeName());
                en.setSupplyType(entity.getSupplyType());
                en.setContentId(entity.getContentId());
                en.setContentName(entity.getContentName());
                en.setState(entity.getState());
                service.saveOrUpdate(en, false);
            }
        }

    	LimitVO vo = BeanMapper.map(entity, LimitVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LimitVO> queryDetail(Long id) {
    	LimitEntity entity = service.selectById(id);
    	LimitVO vo = BeanMapper.map(entity, LimitVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody Map<String,String> param) {
        String supplyType = (String)param.get("supplyType");
        Long contentId = Long.parseLong(param.get("contentId"));

        service.deleteData(supplyType,contentId);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *//*
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<LimitVO>> queryList(@RequestBody QueryParam param) {
        *//** 模糊搜索配置字段示例 *//*
        List<String> fuzzyFields = param.getFuzzyFields();
        *//** 租户隔离 *//*
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        *//** 数据隔离 本下 没有组织orgId的删除下面代码 *//*
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LimitVO> voList = new ArrayList<>();
        LinkedHashMap linkedHashMap = new LinkedHashMap<>();
        linkedHashMap.put("supplyType","desc");

        param.setOrderMap(linkedHashMap);
        List<LimitEntity> list =service.queryList(param);
        voList =BeanMapper.mapList(list,LimitVO.class);
        return CommonResponse.success("查询列表数据成功！",voList);
    }*/

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LimitVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */

        IPage<LimitEntity> page = service.queryPage(param,false);
        IPage<LimitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LimitVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 修改状态
     * @param param
     * @return
     */
    @RequestMapping(value = "/updateState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateState(@RequestBody Map<String,Object> param){
        String supplyTypeName = (String)param.get("supplyTypeName");
        String supplyType = (String) param.get("supplyType");
        Boolean state = (Boolean) param.get("state");
        service.updateState(supplyTypeName,state,supplyType);
        return CommonResponse.success(state?"开启成功":"关闭成功");
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LimitEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Limit-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLimitData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LimitVO>> refLimitData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LimitEntity> page = service.queryPage(param,false);
        IPage<LimitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LimitVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
