package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.bean.PunishEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractPunishEntity;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.UpgradeEntity;
import com.ejianc.business.pro.supplier.service.IUpgradeService;
import com.ejianc.business.pro.supplier.vo.UpgradeVO;

/**
 * 供应商评级
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("upgrade")
public class UpgradeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "UPGRADE-CODE";//此处需要根据实际修改

    @Autowired
    private IUpgradeService service;

    @Autowired
    private IGradeService gradeService;

    @Autowired
    private IPunishService punishService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UpgradeVO> saveOrUpdate(@RequestBody UpgradeVO saveorUpdateVO) {
    	UpgradeEntity entity = BeanMapper.map(saveorUpdateVO, UpgradeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> code = billCodeApi.getCodeBatchByRuleCode(getBillCode(entity), InvocationInfoProxy.getTenantid());
            if(code.isSuccess()) {
                entity.setCode(code.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        GradeEntity gradeEntity =gradeService.getById(saveorUpdateVO.getGradeId());
        GradeEntity gradeOldEntity =gradeService.getById(saveorUpdateVO.getOldGradeId());
        if(null != gradeOldEntity) {
            if(gradeEntity.getWeight() < gradeOldEntity.getWeight()){
                return CommonResponse.error("评定等级不能小于原等级！");
            }
        }

        QueryParam param = new QueryParam();
        param.getParams().put("supplyId",new Parameter(QueryParam.EQ,saveorUpdateVO.getSupplyId()));
        param.getParams().put("billState",new Parameter(QueryParam.IN,"0,4"));
        param.getParams().put("supplyQueryType", new Parameter(QueryParam.EQ, saveorUpdateVO.getSupplyQueryType()));
        List<UpgradeEntity> list =service.queryList(param);

        if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
            return CommonResponse.error("该供应商存在未生效的单据！");
        }


        QueryParam punishParam = new QueryParam();
        punishParam.getParams().put("supplyId",new Parameter(QueryParam.EQ,saveorUpdateVO.getSupplyId()));
        punishParam.getParams().put("billState",new Parameter(QueryParam.IN,"0,4"));
        param.getParams().put("supplyType", new Parameter(QueryParam.EQ, saveorUpdateVO.getSupplyQueryType()));
        List<PunishEntity> punishList= punishService.queryList(punishParam);
        if(ListUtil.isNotEmpty(punishList)){
            return CommonResponse.error("该供应商处置有流程尚未审批不能添加！");
        }

    	service.saveOrUpdate(entity, false);
    	UpgradeVO vo = BeanMapper.map(entity, UpgradeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    private String getBillCode(UpgradeEntity entity){
        if("material".equals(entity.getSupplyQueryType())){
            return "pro-supplier-pji-wz";
        }else if("equipment".equals(entity.getSupplyQueryType())){
            return "pro-supplier-pji-sb";
        }else if("other".equals(entity.getSupplyQueryType())){
            return "pro-supplier-pji-qt";
        }
        return "pro-supplier-pji-wz";
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UpgradeVO> queryDetail(Long id) {
    	UpgradeEntity entity = service.selectById(id);
    	UpgradeVO vo = BeanMapper.map(entity, UpgradeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UpgradeVO> vos) {
        service.removeByIds(vos.stream().map(UpgradeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UpgradeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<UpgradeEntity> page = service.queryPage(param,false);
        IPage<UpgradeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), UpgradeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplyQueryType", new Parameter(QueryParam.EQ, SupplierQueryType.materialEquipment));

        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<UpgradeEntity> list = service.queryList(param);
        List<UpgradeVO> voList = new ArrayList<>();
        if(list.size()>0){
            voList = BeanMapper.mapList(list,UpgradeVO.class);
            for (UpgradeVO vo: voList){
                if(StringUtils.isNotEmpty(vo.getPersonal()) && vo.getPersonal().equals("e")){
                    vo.setPersonal("企业");
                }else if(StringUtils.isNotEmpty(vo.getPersonal()) && vo.getPersonal().equals("p")){
                    vo.setPersonal("个人");
                }

                if(StringUtils.isNotEmpty(vo.getGroupInOrOut()) && vo.getGroupInOrOut().equals("in")){
                    vo.setGroupInOrOut("内");
                }else if(StringUtils.isNotEmpty(vo.getGroupInOrOut()) && vo.getGroupInOrOut().equals("out")){
                    vo.setGroupInOrOut("外");
                }

                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("upgrader-export.xlsx", beans, response);
    }


    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refUpgradeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UpgradeVO>> refUpgradeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<UpgradeEntity> page = service.queryPage(param,false);
        IPage<UpgradeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UpgradeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
