package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.dto.HearUserDTO;
import com.ejianc.business.pro.supplier.service.*;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.*;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.api.IShareSubleadersApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Component("yearAppraiseService")
public class YearAppraiseService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "YEAY_EVALUATE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAbnormalService abnormalService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    IProSupplierApi proSupplierApi;
    @Autowired
    IShareSubleadersApi shareSubleadersApi;
    @Autowired
    private IYearService yearService;
    @Autowired
    private ILimitService limitService;
    @Autowired
    private IGradeService gradeService;

    @Autowired
    IContractPoolApi contractPoolApi;


    private static final BigDecimal level1_10 = new BigDecimal(-10L);
    private static final BigDecimal level2_20 = new BigDecimal(-20L);
    private static final BigDecimal level3_30 = new BigDecimal(-30L);
    private static final BigDecimal level4_40 = new BigDecimal(-40L);


    private static final BigDecimal YJ_LEVEL1_GT_N10 = new BigDecimal(-10);
    private static final BigDecimal YJ_LEVEL2_GT_N40 = new BigDecimal(-40);
    private static final BigDecimal YJ_LEVEL3_LE_N40 = new BigDecimal(-40);

    /**
     * @param appraiseParamVO
     * @description: 判断今日是否是推送日期，并且获取本次推送年度的起始时间
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author xuannl
     * @date: 2022/5/06
     */
    public String getStartDate(AppraiseParamVO appraiseParamVO) {
      /*  String nowDateStr = DateUtil.format(new Date(), DateUtil.DATE);
        String substring = nowDateStr.substring(5,10);
        // 如果今日不是设置的结算周期，返回空
        if(!appraiseParamVO.getYearPushDate().equals(substring)){
            return null;
        }
        // 如果之前有过年度评价，起始日期就取上一次的年度评价日期，避免周期修改值后，取值不准确。
        // 供应商年度评价不可手动新增！！！，如后续需要支持手动新增，需要对获取起始日期重新处理！
        QueryWrapper<YearEntity> wrapper = new QueryWrapper<>();
        wrapper.isNotNull("old_start_date");
        wrapper.orderByDesc("create_time");
        List<YearEntity> list = yearService.list(wrapper);
        if(list.size() != 0){
            Date createTime = list.get(0).getCreateTime();
            return DateUtil.format(createTime, DateUtil.DATE);
        }else{*/
        Integer startYear = DateUtil.getYear() - 1;
        return startYear + "-" + appraiseParamVO.getYearPushDate();
        // }
    }

    // 累计扣分项 (事件、过程)
    public Map<Long, SupplySubVo> sumSubGrade(List<ProcessEntity> processList, List<IncidentEntity> incidentList) {
        Map<Long, SupplySubVo> supplySubMap = new HashMap<>();
        for (ProcessEntity entity : processList
        ) {
            SupplySubVo supplySubVo = supplySubMap.get(entity.getSupplyId());

            logger.info("ProcessEntity");
            logger.info(entity.getId().toString());
            logger.info(entity.getSupplyId() + "" + entity.getBuckleBranch());
            entity.setBuckleBranch(null == entity.getBuckleBranch() ? BigDecimal.ZERO : entity.getBuckleBranch());
            String supplySubVoStr = JSONObject.toJSONString(supplySubVo);
            logger.info("supplySubVoStr:" + supplySubVoStr);
            String entityStr = JSONObject.toJSONString(entity);
            logger.info("entityStr:" + entityStr);
            if (null == supplySubVo) {
                // 添加到project数据集
                ProjectSubVo projectSubVo1 = new ProjectSubVo();
                projectSubVo1.setPrijectId(entity.getProjectId());
                projectSubVo1.setSubGrade(entity.getBuckleBranch());
                Map<Long, ProjectSubVo> projectSubMap = new HashMap<>();
                projectSubMap.put(entity.getProjectId(), projectSubVo1);
                // 添加到供应商数据集
                SupplySubVo supplySubVo1 = new SupplySubVo();
                supplySubVo1.setSupplyId(entity.getSupplyId());
                supplySubVo1.setSubGrade(entity.getBuckleBranch());
                supplySubVo1.setProjectMap(projectSubMap);
                supplySubVo1.setSjSubGrade(entity.getBuckleBranch());
                supplySubVo1.setGcSubGrade(BigDecimal.ZERO);
                supplySubMap.put(entity.getSupplyId(), supplySubVo1);
            } else {
                Map<Long, ProjectSubVo> projectMap = supplySubVo.getProjectMap();
                ProjectSubVo projectSubVo = projectMap.get(entity.getProjectId());
                if (null == projectSubVo) {
                    // 添加到project数据集
                    ProjectSubVo projectSubVo1 = new ProjectSubVo();
                    projectSubVo1.setPrijectId(entity.getProjectId());
                    projectSubVo1.setSubGrade(entity.getBuckleBranch());
                    projectMap.put(entity.getProjectId(), projectSubVo1);
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSjSubGrade(supplySubVo.getSjSubGrade().add(entity.getBuckleBranch()));
                } else {
                    projectSubVo.setSubGrade(projectSubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSjSubGrade(supplySubVo.getSjSubGrade().add(entity.getBuckleBranch()));
                }
            }
        }

        for (IncidentEntity entity : incidentList
        ) {
            SupplySubVo supplySubVo = supplySubMap.get(entity.getSupplyId());
            logger.info("IncidentEntity");
            logger.info(entity.getId().toString());
            logger.info(entity.getSupplyId() + "" + entity.getBuckleBranch());
            entity.setBuckleBranch(null == entity.getBuckleBranch() ? BigDecimal.ZERO : entity.getBuckleBranch());
            String supplySubVoStr = JSONObject.toJSONString(supplySubVo);
            logger.info("supplySubVoStr:" + supplySubVoStr);
            String entityStr = JSONObject.toJSONString(entity);
            logger.info("entityStr:" + entityStr);

            if (null == supplySubVo) {
                // 添加到project数据集
                ProjectSubVo projectSubVo1 = new ProjectSubVo();
                projectSubVo1.setPrijectId(entity.getProjectId());
                projectSubVo1.setSubGrade(entity.getBuckleBranch());
                Map<Long, ProjectSubVo> projectSubMap = new HashMap<>();
                projectSubMap.put(entity.getProjectId(), projectSubVo1);
                // 添加到供应商数据集
                SupplySubVo supplySubVo1 = new SupplySubVo();
                supplySubVo1.setSupplyId(entity.getSupplyId());
                supplySubVo1.setSubGrade(entity.getBuckleBranch());
                supplySubVo1.setGcSubGrade(entity.getBuckleBranch());
                supplySubVo1.setProjectMap(projectSubMap);
                supplySubMap.put(entity.getSupplyId(), supplySubVo1);
            } else {
                Map<Long, ProjectSubVo> projectMap = supplySubVo.getProjectMap();
                ProjectSubVo projectSubVo = projectMap.get(entity.getProjectId());
                if (null == projectSubVo) {
                    // 添加到project数据集
                    ProjectSubVo projectSubVo1 = new ProjectSubVo();
                    projectSubVo1.setPrijectId(entity.getProjectId());
                    projectSubVo1.setSubGrade(entity.getBuckleBranch());
                    projectMap.put(entity.getProjectId(), projectSubVo1);
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setGcSubGrade(supplySubVo.getGcSubGrade().add(entity.getBuckleBranch()));
                } else {
                    projectSubVo.setSubGrade(projectSubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setGcSubGrade(supplySubVo.getGcSubGrade().add(entity.getBuckleBranch()));
                }
            }
        }
        return supplySubMap;
    }

    // 获取统计数据集
    public Map<Long, SupplyBaseVo> getSupplyResult(String rule, List<ContractDTO> dtos) {
        Map<Long, SupplyBaseVo> supplyBaseMap = new HashMap<>();
        for (ContractDTO dto : dtos
        ) {
            String contractType = SupplyQueryTypeUtil.get(rule, dto.getContractType());
            if (StringUtils.isEmpty(contractType)) {
                continue;
            }
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(dto.getSupplyId());
            // 如果供应商还未添加到map中
            if (null == supplyBaseVo) {
                Map<Long, ContractDTO> contractMap = new HashMap<>();
                contractMap.put(dto.getContractId(), dto);
                // 添加项目数据集
                ProjectBaseVo projectBaseVo = new ProjectBaseVo();
                projectBaseVo.setProjectId(dto.getProjectId());
                projectBaseVo.setSupplyId(dto.getSupplyId());
                projectBaseVo.setProjectMny(dto.getContractTaxMny());
                projectBaseVo.setContracts(contractMap);
                // 添加分类数据集
                Map<Long, ProjectBaseVo> projectMap = new HashMap<>();
                projectMap.put(dto.getProjectId(), projectBaseVo);
                TypeBaseVo typeBaseVo = new TypeBaseVo();

                typeBaseVo.setContractType(contractType);
                typeBaseVo.setContractDetailType(dto.getContractType());
                typeBaseVo.setSupplyId(dto.getSupplyId());
                typeBaseVo.setTypeMny(dto.getContractTaxMny());
                typeBaseVo.setProjectMap(projectMap);
                // 添加到供应商数据集
                Map<String, TypeBaseVo> typeMap = new HashMap<>();
                typeMap.put(contractType, typeBaseVo);
                SupplyBaseVo supplyBaseVo1 = new SupplyBaseVo();
                supplyBaseVo1.setSumMny(dto.getContractTaxMny());
                supplyBaseVo1.setSupplyId(dto.getSupplyId());
                supplyBaseVo1.setTypeBaseMap(typeMap);
                supplyBaseVo1.setCount(1);
                supplyBaseVo1.addProjectIds(dto.getProjectId());
                // 汇总
                supplyBaseMap.put(supplyBaseVo1.getSupplyId(), supplyBaseVo1);
            } else {
                Map<String, TypeBaseVo> typeBaseMap = supplyBaseVo.getTypeBaseMap();
                TypeBaseVo typeBaseVo = typeBaseMap.get(contractType);
                // 如果分类还未添加到对应供应商中
                if (null == typeBaseVo) {
                    Map<Long, ContractDTO> contractMap = new HashMap<>();
                    contractMap.put(dto.getContractId(), dto);
                    // 添加项目数据集
                    ProjectBaseVo projectBaseVo = new ProjectBaseVo();
                    projectBaseVo.setProjectId(dto.getProjectId());
                    projectBaseVo.setSupplyId(dto.getSupplyId());
                    projectBaseVo.setProjectMny(dto.getContractTaxMny());
                    projectBaseVo.setContracts(contractMap);
                    // 添加分类数据集
                    Map<Long, ProjectBaseVo> projectMap = new HashMap<>();
                    projectMap.put(dto.getProjectId(), projectBaseVo);
                    TypeBaseVo typeBaseVo1 = new TypeBaseVo();
                    typeBaseVo1.setContractType(contractType);
                    typeBaseVo1.setContractDetailType(dto.getContractType());
                    typeBaseVo1.setSupplyId(dto.getSupplyId());
                    typeBaseVo1.setTypeMny(dto.getContractTaxMny());
                    typeBaseVo1.setProjectMap(projectMap);
                    // 添加到供应商数据集
                    typeBaseMap.put(contractType, typeBaseVo1);
                    supplyBaseVo.setTypeBaseMap(typeBaseMap);
                    // 累计钱
                    supplyBaseVo.setSumMny(supplyBaseVo.getSumMny().add(dto.getContractTaxMny()));
                    supplyBaseVo.addProjectIds(dto.getProjectId());
                    supplyBaseVo.setCount(supplyBaseVo.getCount() + 1);
                } else {
                    Map<Long, ProjectBaseVo> projectMap = typeBaseVo.getProjectMap();
                    ProjectBaseVo projectBaseVo = projectMap.get(dto.getProjectId());
                    if (null == projectBaseVo) {
                        Map<Long, ContractDTO> contractMap = new HashMap<>();
                        contractMap.put(dto.getContractId(), dto);
                        // 添加项目数据集
                        ProjectBaseVo projectBaseVo1 = new ProjectBaseVo();
                        projectBaseVo1.setProjectId(dto.getProjectId());
                        projectBaseVo1.setSupplyId(dto.getSupplyId());
                        projectBaseVo1.setContracts(contractMap);
                        projectBaseVo1.setProjectMny(dto.getContractTaxMny());
                        // 添加分类数据集
                        projectMap.put(dto.getProjectId(), projectBaseVo1);
                        typeBaseVo.setProjectMap(projectMap);
                        // 累计钱
                        typeBaseVo.setTypeMny(typeBaseVo.getTypeMny().add(dto.getContractTaxMny()));
                        supplyBaseVo.setSumMny(supplyBaseVo.getSumMny().add(dto.getContractTaxMny()));
                        supplyBaseVo.addProjectIds(dto.getProjectId());
                        supplyBaseVo.setCount(supplyBaseVo.getCount() + 1);
                    } else {
                        Map<Long, ContractDTO> contractMap = projectBaseVo.getContracts();
                        contractMap.put(dto.getContractId(), dto);
                        // 添加项目数据集
                        projectBaseVo.setContracts(contractMap);
                        // 累计钱
                        projectBaseVo.setProjectMny(projectBaseVo.getProjectMny().add(dto.getContractTaxMny()));
                        supplyBaseVo.setSumMny(typeBaseVo.getTypeMny().add(dto.getContractTaxMny()));
                        typeBaseVo.setTypeMny(typeBaseVo.getTypeMny().add(dto.getContractTaxMny()));
                        supplyBaseVo.addProjectIds(dto.getProjectId());
                        supplyBaseVo.setCount(supplyBaseVo.getCount() + 1);
                    }
                }
            }
        }
        return supplyBaseMap;
    }

    // 获取供应商下最大的类别额
    public TypeBaseVo getMaxType(SupplyBaseVo supplyBaseVo) {
        Map<String, TypeBaseVo> typeBaseMap = supplyBaseVo.getTypeBaseMap();
        BigDecimal maxMny = BigDecimal.ZERO;
        TypeBaseVo resultVo = new TypeBaseVo();
        for (TypeBaseVo vo : typeBaseMap.values()
        ) {
            if (vo.getTypeMny().compareTo(maxMny) > 0) {
                maxMny = vo.getTypeMny();
                resultVo = vo;
            }
        }
        return resultVo;
    }

    // 计算最终扣分结果
    public List<AppraiseResultVO> calGradeA(Map<Long, SupplyBaseVo> supplyBaseMap, Map<Long, SupplierVO> shareSupplierMap, Map<Long, SupplySubVo> longSupplySubVoMap, List<Long> supplierIds, String startDate) {
        QueryWrapper<LimitEntity> wrapper = new QueryWrapper<>();
        List<LimitEntity> list = limitService.list(wrapper);
        // 引用双键map key 供应商分类 等级 val 限额
        Table<String, Long, BigDecimal> doubleMap = HashBasedTable.create();
        for (LimitEntity limitEntity : list) {
            // 是否开启 如果限额为空代表不限制，等于没有开启
            if (limitEntity.getState() && null != limitEntity.getAllYear()) {
                doubleMap.put(limitEntity.getSupplyType(), limitEntity.getGreadId(), limitEntity.getAllYear());
            }

        }
        // 获取等级
        Map<Integer, GradeEntity> weightMap = new HashMap<>();
        Map<Long, GradeEntity> weightIdMap = new HashMap<>();
        QueryWrapper<GradeEntity> gradeWrapper = new QueryWrapper<>();
        List<GradeEntity> gradeList = gradeService.list(gradeWrapper);
        for (GradeEntity entity : gradeList
        ) {
            weightMap.put(entity.getWeight(), entity);
            weightIdMap.put(entity.getId(), entity);
        }
        // 获取异常等级
        Map<Integer, AbnormalEntity> errWeightMap = new HashMap<>();
        QueryWrapper<AbnormalEntity> abnormalWrapper = new QueryWrapper<>();
        List<AbnormalEntity> errlist = abnormalService.list(abnormalWrapper);
        for (AbnormalEntity entity : errlist
        ) {
            errWeightMap.put(entity.getWeight(), entity);
        }


        // 开始计算
        List<AppraiseResultVO> appraiseResultVOList = new ArrayList<>();

        logger.info("supplyBaseMap:" + JSONObject.toJSONString(supplyBaseMap));
        for (Long supplierId : supplierIds
        ) {
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(supplierId);
            // 获取大最大额度的类别
            logger.info("supplyBaseVo:" + JSONObject.toJSONString(supplyBaseVo));
            TypeBaseVo maxTypeVo = getMaxType(supplyBaseVo);
            logger.info("maxTypeVo:" + JSONObject.toJSONString(maxTypeVo));
            // 获取供应商信息(拿等级、权重)
            SupplierVO supplierVO = shareSupplierMap.get(supplierId);
            // 获取该等级下最大合同额的 最大限额
            String supplyType = maxTypeVo.getContractType();
            logger.info("supplyType:" + supplyType);
            logger.info("maxTypeVo:" + JSONObject.toJSONString(maxTypeVo));
            logger.info("doubleMap:" + JSONObject.toJSONString(doubleMap));
            BigDecimal maxMny = doubleMap.get(supplyType, supplierVO.getGradeId());
            // 获取供应商现在的等级信息
            GradeEntity gradeEntity = weightIdMap.get(supplierVO.getGradeId());
            Integer nowWeight = gradeEntity.getWeight();

            SupplySubVo supplySubVo = longSupplySubVoMap.get(supplierId);
            Map<Long, ProjectSubVo> projectMap = supplySubVo.getProjectMap();
            Map<Long, BigDecimal> proSubGrade = new HashMap<>();
            for (ProjectSubVo vo : projectMap.values()
            ) {
                proSubGrade.put(vo.getPrijectId(), vo.getSubGrade());
            }
            // 调用计算规则
            CalRuleVo calRuleVo = calRuleA(nowWeight, proSubGrade, supplySubVo.getSubGrade(), supplyBaseVo.getSumMny(), maxMny, new BigDecimal(90L));
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            appraiseResultVO.setSupplyId(supplierId);
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(supplyBaseVo.getProjectIds().size() + "");
            // 获取最大类别下的  最大金额的合同，取他的合作单位
            Long maxContract = getMaxConBytype(maxTypeVo);
            CommonResponse<ContractPoolVO> contractPoolVOCommonResponse = contractPoolApi.queryById(maxContract);
            if (contractPoolVOCommonResponse.isSuccess() && contractPoolVOCommonResponse.getData() != null) {
                ContractPoolVO data = contractPoolVOCommonResponse.getData();
                appraiseResultVO.setCooperationOrgId(data.getOrgId());
                appraiseResultVO.setCooperationOrgName(data.getOrgName());
            }

            appraiseResultVO.setPrimaryGrade(gradeEntity.getName());
            appraiseResultVO.setTotalAmount(supplyBaseVo.getSumMny());
            appraiseResultVO.setTotalNum(supplyBaseVo.getCount());
            appraiseResultVO.setProcessBranch(supplySubVo.getGcSubGrade());
            appraiseResultVO.setIncidentBranch(supplySubVo.getSjSubGrade());
            appraiseResultVO.setSupplyType(SupplyQueryTypeUtil.getEName(maxTypeVo.getContractDetailType()));
            appraiseResultVO.setSupplyTypeName(SupplyQueryTypeUtil.getName(maxTypeVo.getContractDetailType()));
            appraiseResultVO.setThiYearNum(supplyBaseVo.getCount());
            appraiseResultVO.setSupplyQueryType(maxTypeVo.getContractType());
            GradeEntity gradeEntity1 = weightMap.get(calRuleVo.getNewWeight());
            if (null == gradeEntity1) {
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(gradeEntity1.getId());
            appraiseResultVO.setGradeName(gradeEntity1.getName());
            appraiseResultVO.setContractType(maxTypeVo.getContractDetailType());
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if (null != calRuleVo.getNewErrWeight()) {
                AbnormalEntity abnormalEntity = errWeightMap.get(calRuleVo.getNewErrWeight());
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            appraiseResultVOList.add(appraiseResultVO);
        }
        return appraiseResultVOList;
    }


    private Long getMaxConBytype(TypeBaseVo maxTypeVo) {
        Long maxContract = null;
        BigDecimal max = BigDecimal.ZERO;
        Map<Long, ProjectBaseVo> projectMap = maxTypeVo.getProjectMap();
        for (ProjectBaseVo item : projectMap.values()) {
            for (ContractDTO t : item.getContracts().values()) {
                if (t.getContractTaxMny().compareTo(max) > 0) {
                    maxContract = t.getContractId();
                }
            }
        }
        return maxContract;
    }

    /**
     * @param nowWeight   原等级
     * @param proSubGrade 项目对应的扣分值
     * @param sumGrade    总扣分
     * @param sumMny      总合同额
     * @param maxMny      限制最大值
     * @param rercent     阈值百分比(整数 90、80、100)
     */
    private CalRuleVo calRuleA(Integer nowWeight, Map<Long, BigDecimal> proSubGrade, BigDecimal sumGrade, BigDecimal sumMny, BigDecimal maxMny, BigDecimal rercent) {
        // 新的正常权重 异常权重
        logger.info("计算等级开始打印入参");
        logger.info("nowWeight:" + nowWeight);
        logger.info("proSubGrade:" + JSONObject.toJSONString(proSubGrade));
        logger.info("sumGrade:" + sumGrade);
        logger.info("sumMny:" + sumMny);
        logger.info("maxMny:" + maxMny);
        logger.info("rercent:" + rercent);
        Integer newWeight = null;
        Integer newErrWeight = null;
        // 额度*倍数
        maxMny = null == maxMny ? BigDecimal.ZERO : maxMny.multiply(rercent);
        sumMny = null == sumMny ? BigDecimal.ZERO : sumMny.multiply(new BigDecimal(100L));
        // 年度得值大于-10分
        if (sumGrade.compareTo(level1_10) > 0) {
            if (nowWeight < 9 && sumMny.compareTo(maxMny) > 0) {
                // 现在的等级小于9  并且 合同额大于限额
                newWeight = nowWeight + 1;
            } else if (nowWeight == 9 && sumMny.compareTo(maxMny) > 0) {
                // 现在的等级小于9  并且 合同额大于限额 并且超过三个项目 每个项目扣分小于10分
                // 是否满足增加权重规则
                boolean res = true;
                if (proSubGrade.values().size() >= 3) {
                    for (BigDecimal dec : proSubGrade.values()
                    ) {
                        if (dec.compareTo(level1_10) <= 0) {
                            res = false;
                            break;
                        }
                    }
                } else {
                    res = false;
                }
                if (res) {
                    newWeight = nowWeight + 1;
                }
            }
        } else if (sumGrade.compareTo(level3_30) <= 0) {
            newErrWeight = 10;
        } else if (sumGrade.compareTo(level2_20) <= 0) {
            if (nowWeight > 8) {
                // 现在的等级大于8
                newWeight = nowWeight - 1;
            }
        }
        CalRuleVo vo = new CalRuleVo();
        vo.setNewWeight(newWeight);
        vo.setNewErrWeight(newErrWeight);
        return vo;
    }


    /**
     * 实际按照规则计算新权重方法
     *
     * @param sumGrade 总扣分
     */
    public CalRuleVo calRuleB(BigDecimal sumGrade) {
        // 新的正常权重 异常权重
        Integer newWeight = null;
        Integer newErrWeight = null;
        // 年度扣分小于10
        if (sumGrade.compareTo(YJ_LEVEL1_GT_N10) > 0) {
            newWeight = 10;
        } else if (sumGrade.compareTo(YJ_LEVEL1_GT_N10) <= 0 && sumGrade.compareTo(YJ_LEVEL2_GT_N40) > 0) {
            newWeight = 9;
        } else if (sumGrade.compareTo(YJ_LEVEL3_LE_N40) <= 0) {
            newWeight = 8;
        }
        CalRuleVo vo = new CalRuleVo();
        vo.setNewWeight(newWeight);
        vo.setNewErrWeight(newErrWeight);
        return vo;
    }

    public static void main(String[] args) {
        BigDecimal sumGrade = new BigDecimal("-20");
        // 新的正常权重 异常权重
        Integer newWeight = null;
        Integer newErrWeight = null;
        // 年度扣分小于10
//        if (sumGrade.compareTo(level1_10) > 0) {
//            newWeight = 10;
//        } else if (sumGrade.compareTo(level1_10) <= 0 && sumGrade.compareTo(level2_20) > 0) {
//            newWeight = 9;
//        } else if (sumGrade.compareTo(level2_20) <= 0 && sumGrade.compareTo(level4_40) > 0) {
//            newWeight = 8;
//        } else if (sumGrade.compareTo(level4_40) <= 0) {
//            newErrWeight = 10;
//        }

        System.out.println(newWeight);
        System.out.println(newErrWeight);
    }


    public List<AppraiseResultVO> calSubleader(Map<Long, HearUserDTO> hearUserDTOMap, List<SubleadersVO> vos, Map<Long, SupplierVO> shareSupplierMap, String startDate) {
        // 获取等级
        Map<Integer, GradeEntity> weightMap = new HashMap<>();
        Map<Long, GradeEntity> weightIdMap = new HashMap<>();
        QueryWrapper<GradeEntity> gradeWrapper = new QueryWrapper<>();
        List<GradeEntity> gradeList = gradeService.list(gradeWrapper);
        for (GradeEntity entity : gradeList
        ) {
            weightMap.put(entity.getWeight(), entity);
            weightIdMap.put(entity.getId(), entity);
        }
        // 获取异常等级
        Map<Integer, AbnormalEntity> errWeightMap = new HashMap<>();
        QueryWrapper<AbnormalEntity> abnormalWrapper = new QueryWrapper<>();
        List<AbnormalEntity> errlist = abnormalService.list(abnormalWrapper);
        for (AbnormalEntity entity : errlist
        ) {
            errWeightMap.put(entity.getWeight(), entity);
        }
        // 开始计算
        List<AppraiseResultVO> appraiseResultVOList = new ArrayList<>();
        for (SubleadersVO vo : vos
        ) {
            // 计算新的权重
            HearUserDTO hearUserDTO = hearUserDTOMap.get(vo.getId());
            if (null == hearUserDTO) {
                logger.info("负责人数据异常:" + vo.getId());
                continue;
            }
            // 获取供应商现在的等级信息
            GradeEntity gradeEntity = weightIdMap.get(vo.getGrade());

            CalRuleVo calRuleVo = calRuleB(hearUserDTO.getSumBranch());
            SupplierVO supplierVO = shareSupplierMap.get(vo.getPid());
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            appraiseResultVO.setTotalBranch(hearUserDTO.getSumBranch());
            appraiseResultVO.setSupplyId(vo.getPid());
            appraiseResultVO.setHeadUserId(vo.getId());
            appraiseResultVO.setHeadUserName(vo.getName());
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(hearUserDTO.getProCount() + "");
            appraiseResultVO.setCooperationOrgId(hearUserDTO.getMaxOrgId());
            appraiseResultVO.setCooperationOrgName(hearUserDTO.getMaxOrgName());

            appraiseResultVO.setPrimaryGrade(gradeEntity.getName());
            appraiseResultVO.setTotalAmount(hearUserDTO.getContractTaxMny());
            appraiseResultVO.setTotalNum(hearUserDTO.getContCount());
            appraiseResultVO.setProcessBranch(hearUserDTO.getGcBranch());
            appraiseResultVO.setIncidentBranch(hearUserDTO.getSjBranch());
            appraiseResultVO.setSupplyType("labor");
            appraiseResultVO.setSupplyTypeName("劳务分包");
            appraiseResultVO.setThiYearNum(hearUserDTO.getContCount());
            appraiseResultVO.setSupplyQueryType("laborSub");
            GradeEntity gradeEntity1 = weightMap.get(calRuleVo.getNewWeight());
            if (null == gradeEntity1) {
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(gradeEntity1.getId());
            appraiseResultVO.setGradeName(gradeEntity1.getName());
            appraiseResultVO.setContractType("laborSub");
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if (null != calRuleVo.getNewErrWeight()) {
                AbnormalEntity abnormalEntity = errWeightMap.get(calRuleVo.getNewErrWeight());
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            if (null != appraiseResultVO.getSupplyType() && appraiseResultVO.getSupplyType().equals("labor")) {
                appraiseResultVO.setEvaluationObjState(2);
                appraiseResultVO.setEvaluationObjName("分包负责人");
            }
            appraiseResultVOList.add(appraiseResultVO);
        }

        return appraiseResultVOList;
    }

    ;

    // 计算最终扣分结果
    public List<AppraiseResultVO> calGradeB(Map<Long, SupplyBaseVo> supplyBaseMap, Map<Long, SupplierVO> shareSupplierMap, Map<Long, SupplySubVo> longSupplySubVoMap, List<Long> supplierIds, String startDate) {
        // 获取等级
        Map<Integer, GradeEntity> weightMap = new HashMap<>();
        Map<Long, GradeEntity> weightIdMap = new HashMap<>();
        QueryWrapper<GradeEntity> gradeWrapper = new QueryWrapper<>();
        List<GradeEntity> gradeList = gradeService.list(gradeWrapper);
        for (GradeEntity entity : gradeList
        ) {
            weightMap.put(entity.getWeight(), entity);
            weightIdMap.put(entity.getId(), entity);
        }
        // 获取异常等级
        Map<Integer, AbnormalEntity> errWeightMap = new HashMap<>();
        QueryWrapper<AbnormalEntity> abnormalWrapper = new QueryWrapper<>();
        List<AbnormalEntity> errlist = abnormalService.list(abnormalWrapper);
        for (AbnormalEntity entity : errlist
        ) {
            errWeightMap.put(entity.getWeight(), entity);
        }
        // 开始计算
        List<AppraiseResultVO> appraiseResultVOList = new ArrayList<>();
        for (Long supplierId : supplierIds
        ) {
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(supplierId);
            // 获取大最大额度的类别
            TypeBaseVo maxTypeVo = getMaxType(supplyBaseVo);
            // 获取供应商信息(拿等级、权重)
            SupplierVO supplierVO = shareSupplierMap.get(supplierId);
            SupplySubVo supplySubVo = longSupplySubVoMap.get(supplierId);
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            // 获取供应商现在的等级信息
            GradeEntity gradeEntity = weightIdMap.get(supplierVO.getGradeId());
            // 计算新的权重
            CalRuleVo calRuleVo = calRuleB(supplySubVo.getSubGrade());

            appraiseResultVO.setTotalBranch(supplySubVo.getSubGrade());
            appraiseResultVO.setSupplyId(supplierId);
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(supplyBaseVo.getProjectIds().size() + "");
            // 获取最大类别下的  最大金额的合同，取他的合作单位
            Long maxContract = getMaxConBytype(maxTypeVo);
            CommonResponse<ContractPoolVO> contractPoolVOCommonResponse = contractPoolApi.queryById(maxContract);
            if (contractPoolVOCommonResponse.isSuccess() && contractPoolVOCommonResponse.getData() != null) {
                ContractPoolVO data = contractPoolVOCommonResponse.getData();
                appraiseResultVO.setCooperationOrgId(data.getOrgId());
                appraiseResultVO.setCooperationOrgName(data.getOrgName());
            }
            appraiseResultVO.setPrimaryGrade(null != gradeEntity ? gradeEntity.getName() : null);
            appraiseResultVO.setTotalAmount(supplyBaseVo.getSumMny());
            appraiseResultVO.setTotalNum(supplyBaseVo.getCount());
            appraiseResultVO.setProcessBranch(supplySubVo.getGcSubGrade());
            appraiseResultVO.setIncidentBranch(supplySubVo.getSjSubGrade());
            appraiseResultVO.setSupplyType(SupplyQueryTypeUtil.getEName(maxTypeVo.getContractDetailType()));
            appraiseResultVO.setSupplyTypeName(SupplyQueryTypeUtil.getName(maxTypeVo.getContractDetailType()));
            appraiseResultVO.setThiYearNum(supplyBaseVo.getCount());
            appraiseResultVO.setSupplyQueryType(maxTypeVo.getContractType());
            GradeEntity gradeEntity1 = weightMap.get(calRuleVo.getNewWeight());
            if (null == gradeEntity1) {
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(null != gradeEntity1 ? gradeEntity1.getId() : null);
            appraiseResultVO.setGradeName(null != gradeEntity1 ? gradeEntity1.getName() : null);
            appraiseResultVO.setContractType(maxTypeVo.getContractDetailType());
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if (null != calRuleVo.getNewErrWeight()) {
                AbnormalEntity abnormalEntity = errWeightMap.get(calRuleVo.getNewErrWeight());
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            if (null != appraiseResultVO.getSupplyType() && appraiseResultVO.getSupplyType().equals("labor")) {
                appraiseResultVO.setEvaluationObjState(1);
                appraiseResultVO.setEvaluationObjName("劳务供应商");
            } else {
                appraiseResultVO.setEvaluationObjState(1);
                appraiseResultVO.setEvaluationObjName("供应商");
            }
            appraiseResultVOList.add(appraiseResultVO);
        }
        return appraiseResultVOList;
    }


    public void sendData(List<AppraiseResultVO> appraiseResultVOList) {
        List<YearEntity> yearEntities = BeanMapper.mapList(appraiseResultVOList, YearEntity.class);
        for (YearEntity entity : yearEntities
        ) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setStatus(0);
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            entity.setEndDate(new Date());
            entity.setYearDeduct(0);
            entity.setYearBranch(entity.getTotalBranch());
            entity.setYearGrade(entity.getGrade());
            entity.setYearGradeName(entity.getGradeName());
        }

        if (yearEntities.size() > 0) {
            yearService.saveOrUpdateBatch(yearEntities, yearEntities.size());
        }
    }

    // 获取合同维度的扣分  (包含项目扣分)
    public List<ContVo> sumSubProGrade(List<SubcontractProcessEntity> processlist, List<SubcontractIncidentEntity> incidentList) {
        Map<Long, BigDecimal> con = new HashMap<>();
        Map<Long, BigDecimal> gc = new HashMap<>();
        Map<Long, BigDecimal> sj = new HashMap<>();
        BigDecimal sum = BigDecimal.ZERO;
        for (SubcontractProcessEntity entity : processlist
        ) {
            Long contractId = entity.getContractId();
            if (null == con.get(contractId)) {
                con.put(contractId, entity.getBuckleBranch());
            } else {
                con.put(contractId, con.get(contractId).add(entity.getBuckleBranch()));
            }
            if (null == sj.get(contractId)) {
                sj.put(contractId, entity.getBuckleBranch());
            } else {
                sj.put(contractId, sj.get(contractId).add(entity.getBuckleBranch()));
            }
            sum = sum.add(entity.getBuckleBranch());
        }
        for (SubcontractIncidentEntity entity : incidentList
        ) {
            Long contractId = entity.getContractId();
            if (null == con.get(contractId)) {
                con.put(contractId, entity.getBuckleBranch());
            } else {
                con.put(contractId, con.get(contractId).add(entity.getBuckleBranch()));
            }
            if (null == gc.get(contractId)) {
                gc.put(contractId, entity.getBuckleBranch());
            } else {
                gc.put(contractId, gc.get(contractId).add(entity.getBuckleBranch()));
            }
            sum = sum.add(entity.getBuckleBranch());
        }
        // 总合同数
        BigDecimal count = BigDecimal.valueOf(con.size());
        BigDecimal divide = BigDecimal.ZERO;
        logger.info("sum:" + sum);
        logger.info("count:" + count);
        if (sum.compareTo(BigDecimal.ZERO) != 0 && count.compareTo(BigDecimal.ZERO) != 0) {
            divide = sum.divide(count, 0, BigDecimal.ROUND_UP);
        }

        Map<Long, SubcontractProcessEntity> processMap = processlist.stream()
                .collect(HashMap::new, (m, s) -> m.put(s.getContractId(), s), HashMap::putAll);
        Map<Long, SubcontractIncidentEntity> incidentMap = incidentList.stream()
                .collect(HashMap::new, (m, s) -> m.put(s.getContractId(), s), HashMap::putAll);

        List<ContVo> resultList = new ArrayList<>();
        for (Long item : con.keySet()) {
            SubcontractProcessEntity subcontractProcessEntity = processMap.get(item);
            SubcontractIncidentEntity subcontractIncidentEntity = incidentMap.get(item);
            if (null != subcontractProcessEntity) {
                ContVo contVo = getContVo(subcontractProcessEntity, con, sj, divide);
                resultList.add(contVo);
            } else {
                if ((null != subcontractIncidentEntity)) {
                    ContVo contVo = getContVo(subcontractIncidentEntity, con, sj, divide);
                    resultList.add(contVo);
                } else {
                    logger.info("数据出错，合同id:" + item);
                }
            }
        }
        ;
        return resultList;
    }

    ;

    private ContVo getContVo(SubcontractProcessEntity entity, Map<Long, BigDecimal> con, Map<Long, BigDecimal> sj, BigDecimal divide) {
        ContVo contVo = new ContVo();
        contVo.setContractId(entity.getContractId());
        contVo.setContractName(entity.getContractName());
        contVo.setContractType(entity.getContractType());
        contVo.setProjectName(entity.getProjectName());
        contVo.setOrgName(entity.getCheckOrgName());
        contVo.setContractMny(entity.getContractAmount());
        contVo.setSubProGrade(con.get(entity.getContractId()));
        contVo.setSubSjGrade(sj.get(entity.getContractId()));
        contVo.setSubGcGrade(divide);
        return contVo;
    }

    private ContVo getContVo(SubcontractIncidentEntity entity, Map<Long, BigDecimal> con, Map<Long, BigDecimal> sj, BigDecimal divide) {
        ContVo contVo = new ContVo();
        contVo.setContractId(entity.getContractId());
        contVo.setContractName(entity.getContractName());
        contVo.setContractType(entity.getContractType());
        contVo.setProjectName(entity.getProjectName());
        contVo.setOrgName(entity.getCheckOrgName());
        contVo.setContractMny(entity.getContractAmount());
        contVo.setSubProGrade(con.get(entity.getContractId()));
        contVo.setSubSjGrade(sj.get(entity.getContractId()));
        contVo.setSubGcGrade(divide);
        return contVo;
    }


    // 获取合同维度的扣分  (包含项目扣分)
    public List<Map<String, Object>> sumSubProGrade2(List<SubcontractProcessEntity> processlist, List<SubcontractIncidentEntity> incidentList, Long supplyId, String contractType) {
        HashMap<Long, SubContVo> contractMap = new HashMap<>();
        for (SubcontractProcessEntity entity : processlist
        ) {
            Long contractId = entity.getContractId();
            SubContVo contVo1 = new SubContVo();
            if(ContractTypeEnum.专业分包合同.getTypeCode().equals(contractType)){
                contVo1.setHeadUserId(1L);
                contVo1.setHeadUserName("专业分包默认分包负责人(无意义)");
            } else {
                contVo1.setHeadUserId(entity.getHeadUserId() != null ? entity.getHeadUserId() : 1L);
                contVo1.setHeadUserName(entity.getHeadUserName() != null ? entity.getHeadUserName() : "无");
            }
            contVo1.setContractId(contractId);
            contVo1.setContractName(entity.getContractName());
            contVo1.setContractType(entity.getContractType());
            contVo1.setProjectName(entity.getProjectName());
            contVo1.setOrgName(entity.getCheckOrgName());
            contVo1.setContractMny(entity.getContractAmount());
            contVo1.setSubProGrade(entity.getBuckleBranch());
            contVo1.setSubSjGrade(entity.getBuckleBranch());
            contVo1.setSubGcGrade(BigDecimal.ZERO);
            contractMap.put(contractId, contVo1);
        }
        for (SubcontractIncidentEntity entity : incidentList
        ) {
            Long contractId = entity.getContractId();
            SubContVo contVo1 = new SubContVo();
            if(ContractTypeEnum.专业分包合同.getTypeCode().equals(contractType)){
                contVo1.setHeadUserId(1L);
                contVo1.setHeadUserName("专业分包默认分包负责人(无意义)");
            } else {
                contVo1.setHeadUserId(entity.getHeadUserId() != null ? entity.getHeadUserId() : 1L);
                contVo1.setHeadUserName(entity.getHeadUserName() != null ? entity.getHeadUserName() : "无");
            }
            contVo1.setContractId(contractId);
            contVo1.setContractName(entity.getContractName());
            contVo1.setContractType(entity.getContractType());
            contVo1.setProjectName(entity.getProjectName());
            contVo1.setOrgName(entity.getCheckOrgName());
            contVo1.setContractMny(entity.getContractAmount());
            contVo1.setSubProGrade(entity.getBuckleBranch());
            contVo1.setSubSjGrade(BigDecimal.ZERO);
            contVo1.setSubGcGrade(entity.getBuckleBranch());
            contVo1.setProjectId(entity.getProjectId());
            SubContVo subContVo = contractMap.get(contractId);
            //将同一合同的过程和事件评价扣分合并
            if (subContVo != null) {
                subContVo.setSubProGrade(ComputeUtil.safeAdd(subContVo.getSubProGrade(), entity.getBuckleBranch()));
                subContVo.setSubSjGrade(ComputeUtil.safeAdd(subContVo.getSubSjGrade(), entity.getBuckleBranch()));
            } else {
                contractMap.put(contractId, contVo1);
            }
        }
        List<SubContVo> vos = new ArrayList<>(contractMap.values());
        vos = vos.stream().filter(u -> null != u.getHeadUserId()).collect(Collectors.toList());
        Map<Long, List<SubContVo>> map = vos.stream().collect(Collectors.groupingBy(t -> t.getHeadUserId()));
        List<Map<String, Object>> result = new ArrayList<>();
        Integer code = 1;
        for (Map.Entry<Long, List<SubContVo>> entry : map.entrySet()) {
            //Long headUserId = entry.getKey();
            List<SubContVo> list = entry.getValue();
            // 总合同额  总项目扣分
            BigDecimal sumCon = BigDecimal.ZERO;
            BigDecimal sumProGrade = BigDecimal.ZERO;
            //BigDecimal gcGrade = BigDecimal.ZERO;
            //Map<Long, BigDecimal> proGrade = new HashMap<>();

            for (SubContVo vo : list
            ) {
                sumCon = sumCon.add(vo.getContractMny());
                sumProGrade = sumProGrade.add(vo.getSubProGrade());
               /* gcGrade = gcGrade.add(vo.getSubGcGrade());
                BigDecimal grade = proGrade.get(vo.getContractId());
                if (null == grade) {
                    proGrade.put(vo.getContractId(), vo.getSubProGrade());
                } else {
                    proGrade.put(vo.getContractId(), grade.add(vo.getSubProGrade()));
                }*/
            }

            // 计算对应等级

           /* QueryWrapper<LimitEntity> wrapper = new QueryWrapper<>();
            List<LimitEntity> limitList = limitService.list(wrapper);
            // 引用双键map key 供应商分类 等级 val 限额
            Table<String, Long, BigDecimal> doubleMap = HashBasedTable.create();
            for (LimitEntity limitEntity : limitList) {
                // 是否开启 如果限额为空代表不限制，等于没有开启
                if (limitEntity.getState() && null != limitEntity.getAllYear()) {
                    doubleMap.put(limitEntity.getSupplyType(), limitEntity.getGreadId(), limitEntity.getAllYear());
                }
            }
            // 获取等级
            Map<Integer, GradeEntity> weightMap = new HashMap<>();
            Map<Long, GradeEntity> weightIdMap = new HashMap<>();
            QueryWrapper<GradeEntity> gradeWrapper = new QueryWrapper<>();
            List<GradeEntity> gradeList = gradeService.list(gradeWrapper);
            for (GradeEntity entity : gradeList
            ) {
                weightMap.put(entity.getWeight(), entity);
                weightIdMap.put(entity.getId(), entity);
            }
            // 获取异常等级
            Map<Integer, AbnormalEntity> errWeightMap = new HashMap<>();
            QueryWrapper<AbnormalEntity> abnormalWrapper = new QueryWrapper<>();
            List<AbnormalEntity> errlist = abnormalService.list(abnormalWrapper);
            for (AbnormalEntity entity : errlist
            ) {
                errWeightMap.put(entity.getWeight(), entity);
            }

            Map<String, List<Long>> idsMap = new HashMap<>();
            List<Long> ids = new ArrayList<>();
            ids.add(headUserId);
            idsMap.put("ids", ids);
            CommonResponse<List<SubleadersVO>> subleaderList = shareSubleadersApi.getSubleaderList(idsMap);
            logger.info("subleaderList", JSONObject.toJSONString(subleaderList));
            if (!subleaderList.isSuccess() || subleaderList.getData() == null || subleaderList.getData().size() == 0) {
                logger.info("获取分包负责人数据失败");
            }
            SubleadersVO subleadersVO = subleaderList.getData().get(0);
            Long grade = subleadersVO.getGrade();
            // 现在的等级
            GradeEntity gradeEntity = weightIdMap.get(grade);
            // 最大限额
            BigDecimal labor = doubleMap.get("labor", gradeEntity.getId()) == null ? BigDecimal.ZERO : doubleMap.get("labor", gradeEntity.getId());
            BigDecimal major = doubleMap.get("major", gradeEntity.getId()) == null ? BigDecimal.ZERO : doubleMap.get("major", gradeEntity.getId());

            calRuleB(sumProGrade);*/

            //合作记录过程平均分值= 项目分值合计 / 项目个数
            BigDecimal gcGrade = ComputeUtil.safeDiv(sumProGrade, ComputeUtil.toBigDecimal(list.size())).setScale(0, BigDecimal.ROUND_UP);
            Integer i = 0;

            List<Map<String, Object>> children = new ArrayList<>();
            for (SubContVo vo : list
            ) {
                Map<String, Object> resultMap = new HashMap<>();
                resultMap.put("headUserId", vo.getHeadUserId());
                resultMap.put("headUserName", vo.getHeadUserName());
                resultMap.put("contractId", vo.getContractId());
                resultMap.put("contractName", vo.getContractName());
                resultMap.put("projectId", vo.getProjectId());
                resultMap.put("projectName", vo.getProjectName());
                resultMap.put("contractMny", vo.getContractMny());
                resultMap.put("sumCon", sumCon);
                resultMap.put("gcGrade", gcGrade);
                resultMap.put("proGrade", vo.getSubProGrade());
                if (i == 0) {
                    resultMap.put("rowCol", list.size());
                } else {
                    resultMap.put("rowCol", 0);
                }
                i++;
                children.add(resultMap);
            }
            Map<String, Object> map1 = new HashMap<>();
            map1.put("code", code);
            map1.put("children", children);
            map1.put("sumProGrade", sumProGrade);
            map1.put("headUserName", list.get(0).getHeadUserName());
            map1.put("sumCon", sumCon);
            map1.put("hzNum", list.size());
            map1.put("gcGrade", gcGrade);
            result.add(map1);
        }
        return result;
    }

    ;

    // 更新供应商数据 等级 处置
    public void updateSup(YearEntity entity) {
        // 更新等级
        Long grade = entity.getGrade();
        String gradeName = entity.getGradeName();
        try {
            // 分包负责人
            if (entity.getEvaluationObjState() != null && entity.getEvaluationObjState() == 2) {
                shareSubleadersApi.upgradeSupplier(entity.getHeadUserId(), grade, gradeName);
            } else {
                // 供应商
                proSupplierApi.upgradeSupplier(entity.getSupplyId(), grade, gradeName);
            }
        } catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw, true));
            String infomsg = sw.toString();
            logger.error(infomsg);
        }
        // 更新处置方式
        if (null != entity.getPunishType()) {
            PunishVO punishVO = new PunishVO();
            punishVO.setSupplierId(entity.getSupplyId());
            punishVO.setPunishType(entity.getPunishType());
            punishVO.setPunishDate(new Date());
            AbnormalEntity abnormalEntity = abnormalService.selectById(entity.getPunishType());
            if (null == abnormalEntity) {
                logger.error("没有查询到对应异常等级的数据");
                return;
            }
            Date endDate = DateUtil.monthAdd(new Date(), abnormalEntity.getLastTime() == null ? 0 : abnormalEntity.getLastTime());
            punishVO.setExceptionEndDate(endDate);
            punishVO.setPunishApplyPerson(entity.getProcess());
            punishVO.setPunishGradeId(entity.getGrade());
            punishVO.setPunishGrade(entity.getGradeName());
            punishVO.setPunishOldGrade(entity.getPrimaryGrade());
            punishVO.setPunishApplyOrg(entity.getOrgName());

            if (entity.getEvaluationObjState() != null && entity.getEvaluationObjState() == 2) {
                punishVO.setSubLeaderId(entity.getHeadUserId());
            }

            String punishVOStr = JSONObject.toJSONString(punishVO);
            logger.info("punishVOStr:" + punishVOStr);
            try {
                proSupplierApi.punishSupplier(punishVO);
            } catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw, true));
                String infomsg = sw.toString();
                logger.error(infomsg);
            }
        }
    }


    /**
     * @param year               年份
     * @param evaluationObjState 1 供应商 2 分包负责人 全部 null
     * @description: 获取已推送的分包负责人或者供应商id
     * @return: java.util.List<java.lang.Long>
     * @author songlx
     * @date: 2022/7/1
     */
    public List<Long> getPushedHeadUserIdsOrSupplyIds(int year, Integer evaluationObjState) {
        QueryWrapper<YearEntity> yearWrapper = new QueryWrapper<>();
        yearWrapper.eq(evaluationObjState != null, "evaluation_obj_state", evaluationObjState);
        yearWrapper.eq("date_format(create_time,'%Y')", year);
        List<YearEntity> yearEntities = yearService.list(yearWrapper);
        List<Long> longList = new ArrayList<>();
        if (evaluationObjState == null) {
            for (YearEntity yearEntity : yearEntities) {
                Long headUserId = yearEntity.getHeadUserId();
                if (headUserId != null) {
                    longList.add(headUserId);
                }
                Long supplyId = yearEntity.getSupplyId();
                if (supplyId != null) {
                    longList.add(supplyId);
                }
            }
        } else if (evaluationObjState == 1) {
            longList = yearEntities.stream().filter(u -> null != u.getSupplyId()).map(YearEntity::getSupplyId).collect(Collectors.toList());
        } else {
            longList = yearEntities.stream().filter(u -> null != u.getHeadUserId()).map(YearEntity::getHeadUserId).collect(Collectors.toList());
        }
        return longList;
    }


}
