package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.business.pro.supplier.vo.AlreadyInvestigateVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.InvestigateMapper;
import com.ejianc.business.pro.supplier.bean.InvestigateEntity;
import com.ejianc.business.pro.supplier.service.IInvestigateService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 供应商考察主表
 * 
 * @author generator
 * 
 */
@Service("investigateService")
public class InvestigateServiceImpl extends BaseServiceImpl<InvestigateMapper, InvestigateEntity> implements IInvestigateService{
    @Autowired
    private InvestigateMapper investigateMapper;

    /**
     * 查询已登记
     * @param queryParam
     * @return
     */
    public IPage<AlreadyInvestigateVO> queryAlreadyList(QueryParam queryParam) {
        IPage<AlreadyInvestigateVO> page = new Page<AlreadyInvestigateVO>();
        Map<String, Object> param = new HashMap<>();
        Map<String, Parameter> params = queryParam.getParams();
        Parameter supplyType = null;
        for(Map.Entry<String, Parameter> vo :params.entrySet()){
            if("supplyQueryType".equals(vo.getKey())) {
                supplyType =  vo.getValue();
            }
            vo.getKey();

            System.out.println(vo.getKey()+"  "+vo.getValue());
        }
        param.put("supplyQueryType", supplyType.getValue());
        param.put("pageIndex", queryParam.getPageIndex());
        param.put("pageSize", queryParam.getPageSize());
        if(param.get("pageIndex")!=null){
            Integer pn = queryParam.getPageIndex() - 1 < 0 ? 1 : queryParam.getPageIndex();
            long startLine = (pn - 1) * queryParam.getPageSize();
            param.put("startLine", startLine);
        }
        if(StringUtils.isNotBlank(queryParam.getSearchText())){
            param.put("searchText", queryParam.getSearchText());
        }
        String billState = null != queryParam.getParams().get("billState") ? queryParam.getParams().get("billState").getValue().toString() : null;

        param.put("billState",billState);

        param.put("personal",queryParam.getParams().get("personal")!= null ?queryParam.getParams().get("personal").getValue():null);
        param.put("groupInOrOut",queryParam.getParams().get("groupInOrOut")!= null ?queryParam.getParams().get("groupInOrOut").getValue():null);
        param.put("supplyType",queryParam.getParams().get("supplyType")!= null ?queryParam.getParams().get("supplyType").getValue():null);
        param.put("gradeId",queryParam.getParams().get("gradeId")!= null ?queryParam.getParams().get("gradeId").getValue():null);

        param.put("tenantId",InvocationInfoProxy.getTenantid());

        Integer count = investigateMapper.countNumber(param);
        if(count>0){
            List<AlreadyInvestigateVO> appEntity = investigateMapper.queryAlreadyList(param);
            page.setRecords(appEntity);
        }else{
            page.setRecords(new ArrayList<>());
        }
        if(param.get("pageIndex")!=null){
            page.setCurrent(Integer.parseInt(param.get("pageIndex").toString()));
            page.setSize(Integer.parseInt(param.get("pageSize").toString()));
            page.setTotal(count);
        }

        return page;
    }
}
