package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.InviteMapper;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.service.IInviteService;

import java.util.List;

/**
 * 供应商准入邀请表
 * 
 * @author generator
 * 
 */
@Service("inviteService")
public class InviteServiceImpl extends BaseServiceImpl<InviteMapper, InviteEntity> implements IInviteService{
    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Autowired
    private ICanInService iCanInService;

    @Override
    public CommonResponse<String> checkExist(Long id, String taxNum, String personal, String name) {
        /** 校验供应商库 */
        CommonResponse<Boolean> same = iProSupplierApi.checkTaxpayerNumOrNameIsSame(taxNum, name);
        if(!same.isSuccess() || (same.isSuccess()&&!same.getData())){
            if(!"p".equals(personal)){
                return CommonResponse.error(same.getMsg());
            }
        }

        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum",new Parameter(QueryParam.EQ,taxNum));
        List<InviteEntity> list = queryList(param,false);

        /** 校验供应商库 */
        CommonResponse<String> exist = iProSupplierApi.judgeTaxpayerNumIsRepeat(taxNum, personal,"-");
        if(!exist.isSuccess()){
            return CommonResponse.error("该供应商已经在供应商库，无需再次提交！");
        }
        /** 校验准入表 */
        List<CanInEntity> canInEntities = iCanInService.queryList(param,false);
        if(ListUtil.isNotEmpty(canInEntities)){
            throw new BusinessException("该供应商正在走【"+canInEntities.get(0).getApplyOrgName()+"】的【"+canInEntities.get(0).getSupplyTypeName()+"】准入流程，无需再次提交！");
        }
        /** 校验邀请表 */
        if(id == null && ListUtil.isNotEmpty(list)){
            return CommonResponse.error("该供应商在邀请流程中，不可重复提交!");
        } else if(id != null && ListUtil.isNotEmpty(list) && !list.get(0).getId().equals(id)){
            return CommonResponse.error("该供应商在邀请流程中，不可重复提交!");
        }
        return CommonResponse.success();
    }
}
