package com.ejianc.business.pro.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.LimitMapper;
import com.ejianc.business.pro.supplier.bean.LimitEntity;
import com.ejianc.business.pro.supplier.service.ILimitService;

import java.sql.Wrapper;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 供应商限额设置
 * 
 * @author generator
 * 
 */
@Service("limitService")
public class LimitServiceImpl extends BaseServiceImpl<LimitMapper, LimitEntity> implements ILimitService{

    /**
     * 修改状态
     * @param supplyTypeName
     * @param state
     */
    public void updateState(String supplyTypeName, Boolean state,String supplyType) {
        UpdateWrapper<LimitEntity> wrapper = new UpdateWrapper<LimitEntity>();
        wrapper.set("state",state);
        wrapper.eq("supply_type_name",supplyTypeName);
        wrapper.eq("supply_type",supplyType);
        this.update(wrapper);
    }

    /**
     * 根据supplyTypeName删数据
     * @param supplyType
     */
    public void deleteData(String supplyType,Long contentId) {
        QueryWrapper<LimitEntity> query = new QueryWrapper<>();
        query.in("supply_type", supplyType);
        query.eq("content_id", contentId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<LimitEntity> delList = super.list(query);
        if(CollectionUtils.isNotEmpty(delList)) {
            super.removeByIds(delList.stream().map(LimitEntity::getId).collect(Collectors.toList()), false);
        }
    }
}
