package com.ejianc.business.pro.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.pro.supplier.bean.SubcontractIncidentEntity;
import com.ejianc.business.pro.supplier.service.ISubcontractIncidentService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("subcontractIncident") 
public class SubcontractIncidentBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISubcontractIncidentService subcontractIncidentService;
	@Autowired
	private SessionManager sessionManager;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		SubcontractIncidentEntity entity = subcontractIncidentService.selectById(billId);
		UpdateWrapper<SubcontractIncidentEntity> wrapper = new UpdateWrapper<>();
		wrapper.eq("id",billId);
		//如果提交时没有经办人，赋值经办人为当前登录人
		UserContext userContext = sessionManager.getUserContext();
		if(entity.getCheckOrgId()==null || entity.getCheckOrgId()==null){
			if(entity.getProcessId()==null){
				wrapper.set("process_id",userContext.getUserId());
				wrapper.set("process",userContext.getUserName());
			}
			if(entity.getCheckOrgId()==null){
				wrapper.set("check_org_id",userContext.getOrgId());
				wrapper.set("check_org_name",userContext.getOrgName());
			}
			subcontractIncidentService.update(wrapper);
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SubcontractIncidentEntity entity = subcontractIncidentService.selectById(billId);
		//如果提交时没有经办人，赋值经办人为当前登录人
		UserContext userContext = sessionManager.getUserContext();
		UpdateWrapper<SubcontractIncidentEntity> wrapper = new UpdateWrapper<>();
		wrapper.eq("id",billId);
		wrapper.set("status",1);
		if(entity.getProcessId()==null || entity.getCheckOrgId()==null){
			if(entity.getProcessId()==null){
				wrapper.set("process_id",userContext.getUserId());
				wrapper.set("process",userContext.getUserName());
			}
			if(entity.getCheckOrgId()==null){
				wrapper.set("check_org_id",userContext.getOrgId());
				wrapper.set("check_org_name",userContext.getOrgName());
			}
		}
		subcontractIncidentService.update(wrapper);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		UpdateWrapper<SubcontractIncidentEntity> wrapper = new UpdateWrapper<>();
		wrapper.eq("id",billId);
		wrapper.set("status",0);
		subcontractIncidentService.update(wrapper);
		return CommonResponse.success();
	}

}
