package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.pro.supplier.bean.SubleaderCanInEntity;
import com.ejianc.business.pro.supplier.bean.SubleaderCanInSubEntity;
import com.ejianc.business.pro.supplier.service.ISubleaderCanInService;
import com.ejianc.business.pro.supplier.vo.SubcontractYearVO;
import com.ejianc.business.pro.supplier.vo.SubleaderCanInVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SubleadersPushVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("subleaderCanIn") 
public class SubleaderCanInBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IProSupplierApi iProSupplierApi;
	@Autowired
	private ISubleaderCanInService subleaderCanInService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("到了~~~~~~~~~~~~~~~~~~~~~~~~~~~~{}");

		SubleadersPushVO pushVO = new SubleadersPushVO();
		SubleaderCanInEntity entity =subleaderCanInService.selectById(billId);
		pushVO.setSupplierId(entity.getSupplyId());
		List<SubleadersVO> allList = new ArrayList<>();
		for(SubleaderCanInSubEntity subEntity :entity.getSubleaderCanInSubEntities()){
			SubleadersVO subleadersVO = new SubleadersVO();
			subleadersVO.setName(subEntity.getName());
			subleadersVO.setIdNum(subEntity.getIdNum());
			subleadersVO.setPhone(subEntity.getPhone());
			subleadersVO.setGrade(subEntity.getGrade());
			subleadersVO.setGradeName(subEntity.getGradeName());
			subleadersVO.setId(subEntity.getId());
			allList.add(subleadersVO);
		}

		pushVO.setSubLeaders(allList);
		CommonResponse<String> response =iProSupplierApi.pushSubLeadersToShare(pushVO);
		if(response.isSuccess()){
			return CommonResponse.success();
		}else{
			return CommonResponse.error(response.getMsg());
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("目前不支持撤回");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
