package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.bean.YearEntity;
import com.ejianc.business.pro.supplier.mapper.YearMapper;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.YearBatchOperateParam;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 年度评价
 * 
 * @author generator
 * 
 */
@Service("yearService")
public class YearServiceImpl extends BaseServiceImpl<YearMapper, YearEntity> implements IYearService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private YearMapper yearMapper;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IAbnormalService abnormalService;

    @Autowired
    IProSupplierApi proSupplierApi;

    @Override
    public Map<Long, Integer> queryGrade(Map<String, List<Long>> map) {
        List<Long> suplyIds = map.get("suplyIds");
        List<YearEntity> yearEntities = yearMapper.queryGrade(suplyIds);
        Map<Long,Integer> resultMap = new HashMap<>();
        yearEntities.forEach(item->{
            resultMap.put(item.getSupplyId(),item.getYearDeduct());
        });
        return resultMap;
    }

    /**
     * 年度评价批量通过、调整
     * 1、批量通过、调整都会将年度评价审批状态设置为已提交，且将对应年度评价走一遍审批生效后的逻辑
     * 2、若操作为批量调整，还将对年度评价的调整后得分、调整后等级评定进行修改，修改逻辑如下：
     *  2.1 如果调整前后评定等级一致，那么跳过对年度评价的调整
     *  2.2 若果调整前后评定等级不一致，那么则将年度评价 调整后评定等级及得分字段 设置为 新的得分和等级评定
     *
     * @param yearBatchOperateParam
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchOperate(YearBatchOperateParam yearBatchOperateParam) {
        List<YearEntity> yearList = yearMapper.selectBatchIds(yearBatchOperateParam.getYearIdList());

        List<AbnormalEntity> abnormalEntities = null;
        Map<Long, AbnormalEntity> abnormalMap = null;
        for(YearEntity year : yearList) {
            if(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(year.getBillState())
                    || BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(year.getBillState())) {
                throw new BusinessException("只能批量调整自由态的单据！");
            }
        }
        List<Long> punishIds= yearList.stream().filter(item -> null != item.getPunishType()).map(YearEntity::getPunishType).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(punishIds)) {
            QueryWrapper<AbnormalEntity> abnormalQuery = new QueryWrapper<>();
            abnormalQuery.in("id", punishIds);
            abnormalQuery.eq("dr", BaseVO.DR_UNDELETE);
            abnormalEntities = abnormalService.list(abnormalQuery);
            abnormalMap = abnormalEntities.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        }

        //更新供应商/分包负责人参数
        List<JSONObject> updateParams = new ArrayList<>();
        JSONObject updateParam = null;

        //供应商、分包负责人处置列表
        List<PunishVO> punishVOS = new ArrayList<>();
        for(YearEntity year : yearList) {
            year.setBillState(1); //审批状态设置为已提交

            if(YearBatchOperateParam.OPERATE_TYPE_ADJUST.equals(yearBatchOperateParam.getOperateType()) && !year.getGrade().equals(yearBatchOperateParam.getAdjustedGrade())) {
                year.setGrade(yearBatchOperateParam.getAdjustedGrade());
                year.setGradeName(yearBatchOperateParam.getAdjustedGradeName());
                year.setTotalBranch(yearBatchOperateParam.getAdjustedScore());
            }

            //审批后逻辑
            year.setStatus(1);
            if(year.getProcessId()==null){
                UserContext userContext = sessionManager.getUserContext();
                year.setProcessId(userContext.getUserId());
                year.setProcess(userContext.getUserName());
            }

            updateParam = new JSONObject();
            //更新对应供应商、分包负责人
            if (year.getEvaluationObjState() != null && year.getEvaluationObjState() == 2) {
                updateParam.put("id", year.getHeadUserId());
                updateParam.put("type", "subLeader");
            } else {
                // 供应商
                updateParam.put("id", year.getSupplyId());
                updateParam.put("type", "supplier");
            }
            updateParam.put("grade", year.getGrade());
            updateParam.put("gradeName", year.getGradeName());
            updateParams.add(updateParam);

            //更新处置方式
            if (null != year.getPunishType()) {
                PunishVO punishVO = new PunishVO();
                punishVO.setSupplierId(year.getSupplyId());
                punishVO.setPunishType(year.getPunishType());
                punishVO.setPunishDate(new Date());
                AbnormalEntity abnormalEntity = abnormalMap.get(year.getPunishType());
                if (null == abnormalEntity) {
                    logger.error("没有查询到对应异常等级的数据");
                    return;
                }
                Date endDate = DateUtil.monthAdd(new Date(), abnormalEntity.getLastTime() == null ? 0 : abnormalEntity.getLastTime());
                punishVO.setExceptionEndDate(endDate);
                punishVO.setPunishApplyPerson(year.getProcess());
                punishVO.setPunishGradeId(year.getGrade());
                punishVO.setPunishGrade(year.getGradeName());
                punishVO.setPunishOldGrade(year.getPrimaryGrade());
                punishVO.setPunishApplyOrg(year.getOrgName());

                if (year.getEvaluationObjState() != null && year.getEvaluationObjState() == 2) {
                    punishVO.setSubLeaderId(year.getHeadUserId());
                }

                punishVOS.add(punishVO);
            }
        }

        if(CollectionUtils.isNotEmpty(updateParams)) {
            CommonResponse<String> updateRs = proSupplierApi.updateSupplierAndSubLeaderBatch(JSONObject.toJSONString(updateParams));
            if(!updateRs.isSuccess()) {
                logger.error("更新分包负责人/供应商等级信息失败, {}", JSONObject.toJSONString(updateRs));
                throw new BusinessException("更新分包负责人/供应商等级信息失败！");
            }
        }

        if(CollectionUtils.isNotEmpty(punishVOS)) {
            CommonResponse<String> punishRs = proSupplierApi.punishSupplierBatch(punishVOS);
            if(!punishRs.isSuccess()) {
                logger.error("供应商、分包负责人处置失败, {}", JSONObject.toJSONString(punishRs));
                throw new BusinessException("供应商、分包负责人处置失败！");
            }
        }

        super.saveOrUpdateBatch(yearList, yearList.size(), false);
    }

    @Override
    public Map<Long, BigDecimal> queryTotalBranch(Map<String, List<Long>> map) {
        Map<Long,BigDecimal> resultMap = new HashMap<>();
        List<Long> suplyIds = map.get("suplyIds");
        if(CollectionUtils.isEmpty(suplyIds)) {
            return resultMap;
        }
        List<YearEntity> yearEntities = yearMapper.queryGrade(suplyIds);
        yearEntities.forEach(item->{
            resultMap.put(item.getSupplyId(), item.getTotalBranch());
        });
        return resultMap;
    }

}
