package com.ejianc.business.pro.supplier.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 供应商准入表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_pro_supplier_can_in")
public class CanInEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private String code; // 供应商编号
    @TableField(value="name")
    private String name; // 供应商名称/个人姓名
    @TableField(value="supply_query_type")
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    @TableField(value="supply_type")
    private String supplyType; // 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
    @TableField(value="supply_type_name")
    private String supplyTypeName; // 供方类别名称
    @TableField(value="personal")
    private String personal; // 个人：p，企业：e
    @TableField(value="group_in_or_out")
    private String groupInOrOut; // 集团内外：内in，外out
    @TableField(value="material_content_id")
    private String materialContentId; // 物资供货内容id
    @TableField(value="material_content")
    private String materialContent; // 物资供货内容名称
    @TableField(value="material_memo")
    private String materialMemo; // 物资补充描述
    @TableField(value="equipment_content_id")
    private String equipmentContentId; // 设备供货内容id
    @TableField(value="equipment_content")
    private String equipmentContent; // 设备供货内容
    @TableField(value="equipment_memo")
    private String equipmentMemo; // 设备补充描述
    @TableField(value="major_content_id")
    private String majorContentId; // 专业分包供货内容id
    @TableField(value="major_content")
    private String majorContent; // 专业分包供货内容
    @TableField(value="major_memo")
    private String majorMemo; // 专业分包补充描述
    @TableField(value="labor_content_id")
    private String laborContentId; // 劳务分包供货内容id
    @TableField(value="labor_content")
    private String laborContent; // 劳务分包供货内容
    @TableField(value="labor_memo")
    private String laborMemo; // 劳务分包补充描述
    @TableField(value="sub_content_id")
    private String subContentId; // 分包班组供货内容id
    @TableField(value="sub_content")
    private String subContent; // 分包班组供货内容
    @TableField(value="sub_memo")
    private String subMemo; // 分包班组补充描述
    @TableField(value="other_content_id")
    private String otherContentId; // 其他供货内容id
    @TableField(value="other_content")
    private String otherContent; // 其他供货内容
    @TableField(value="other_memo")
    private String otherMemo; // 其他补充描述
    @TableField(value="apply_org_name")
    private String applyOrgName; // 申请单位
    @TableField(value="apply_org_id")
    private Long applyOrgId; // 申请单位id
    @TableField(value="enterprise_nature")
    private Long enterpriseNature; // 企业性质id
    @TableField(value="enterprise_nature_name")
    private String enterpriseNatureName; // 企业性质名称

    @TableField(value="register_country_id")
    private Long registerCountryId; // 注册国家id
    @TableField(value="register_country_name")
    private String registerCountryName; // 注册国家名称

    @TableField(value="taxpayer_num")
    private String taxpayerNum; // 纳税人识别号/身份证号
    @TableField(value="legal_person")
    private String legalPerson; // 法人代表/别名
    @TableField(value="legal_phone")
    private String legalPhone; // 法人电话/联系电话
    @TableField(value="area")
    private String area; // 所在地区
    @TableField(value="area_name")
    private String areaName; // 所在地区
    @TableField(value="in_or_out")
    private Integer inOrOut; // 国内外：1国内，2国外
    @TableField(value="address")
    private String address; // 公司地址
    @TableField(value="grade_id")
    private Long gradeId; // 供应商等级
    @TableField(value="grade_name")
    private String gradeName; // 供应商等级
    @TableField(value="business_range")
    private String businessRange; // 经营范围
    @TableField(value="memo")
    private String memo; // 准入说明
    @TableField(value="time_out")
    private java.util.Date timeOut; // 有效期
    @TableField(value="coordination")
    private Boolean coordination; // 是否协同
    @TableField(value="coordination_name")
    private String coordinationName; // 协同姓名
    @TableField(value="coordination_phone")
    private String coordinationPhone; // 协同手机号
    @TableField(value="register_date")
    private java.util.Date registerDate; // 注册日期
    @TableField(value="register_mny")
    private java.math.BigDecimal registerMny; // 注册资金
    @TableField(value="turnover")
    private java.math.BigDecimal turnover; // 年营业额
    @TableField(value="investigate")
    private Boolean investigate; // 是否需要考察
    @TableField(value="has_investigate")
    private Boolean hasInvestigate; // 是否考察
    @TableField(value="business_person")
    private String businessPerson;	//业务代表
    @TableField(value="business_phone")
    private String businessPhone;	//业务代表电话
    @TableField(value="weight")
    private String weight; // 权重
    @TableField(value="ocr_json_str")
    private String ocrJsonStr; // 营业执照或者身份证百度OCR识别结果
    @TableField(value="info_pass")
    private Boolean infoPass; // 企业或者个人信息是否校验通过
    @TableField(value="invite_id")
    private Long inviteId;//邀请供应商主键

    @TableField(exist=false)
    @SubEntity(serviceName="bankService")
    private List<BankEntity> banks = new ArrayList<>(); // 供应商准入---单位银行信息
    @TableField(exist=false)
    @SubEntity(serviceName="certsService")
    private List<CertsEntity> certs = new ArrayList<>(); // 供应商准入---证书
    @TableField(exist=false)
    @SubEntity(serviceName="historyService")
    private List<HistoryEntity> history = new ArrayList<>(); // 供应商准入---历史业绩
    @TableField(exist=false)
    @SubEntity(serviceName="subleadersService")
    private List<SubleadersEntity> subLeaders = new ArrayList<>(); // 供应商准入---分包供应商

    @TableField(value = "scattered_supplier_flag")
    private String scatteredSupplierFlag; //零星供应商标识：0-否，1-是

    public String getScatteredSupplierFlag() {
        return scatteredSupplierFlag;
    }

    public void setScatteredSupplierFlag(String scatteredSupplierFlag) {
        this.scatteredSupplierFlag = scatteredSupplierFlag;
    }

    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public String getBusinessPerson() {
        return businessPerson;
    }

    public void setBusinessPerson(String businessPerson) {
        this.businessPerson = businessPerson;
    }

    public String getBusinessPhone() {
        return businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 供应商编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 供应商编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 供应商名称/个人姓名
     */
    public String getName() {
        return name;
    }

    /**
     * 供应商名称/个人姓名
     */
    public void setName(String name) {
        this.name = name;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }

    /**
     * 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
     */
    public String getSupplyType() {
        return supplyType;
    }

    /**
     * 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
     */
    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }
    /**
     * 供方类别名称
     */
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    /**
     * 供方类别名称
     */
    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    /**
     * 个人：p，企业：e
     */
    public String getPersonal() {
        return personal;
    }

    /**
     * 个人：p，企业：e
     */
    public void setPersonal(String personal) {
        this.personal = personal;
    }
    /**
     * 集团内外：内in，外out
     */
    public String getGroupInOrOut() {
        return groupInOrOut;
    }

    /**
     * 集团内外：内in，外out
     */
    public void setGroupInOrOut(String groupInOrOut) {
        this.groupInOrOut = groupInOrOut;
    }
    /**
     * 物资供货内容id
     */
    public String getMaterialContentId() {
        return materialContentId;
    }

    /**
     * 物资供货内容id
     */
    public void setMaterialContentId(String materialContentId) {
        this.materialContentId = materialContentId;
    }
    /**
     * 物资供货内容名称
     */
    public String getMaterialContent() {
        return materialContent;
    }

    /**
     * 物资供货内容名称
     */
    public void setMaterialContent(String materialContent) {
        this.materialContent = materialContent;
    }
    /**
     * 物资补充描述
     */
    public String getMaterialMemo() {
        return materialMemo;
    }

    /**
     * 物资补充描述
     */
    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }
    /**
     * 设备供货内容id
     */
    public String getEquipmentContentId() {
        return equipmentContentId;
    }

    /**
     * 设备供货内容id
     */
    public void setEquipmentContentId(String equipmentContentId) {
        this.equipmentContentId = equipmentContentId;
    }
    /**
     * 设备供货内容
     */
    public String getEquipmentContent() {
        return equipmentContent;
    }

    /**
     * 设备供货内容
     */
    public void setEquipmentContent(String equipmentContent) {
        this.equipmentContent = equipmentContent;
    }
    /**
     * 设备补充描述
     */
    public String getEquipmentMemo() {
        return equipmentMemo;
    }

    /**
     * 设备补充描述
     */
    public void setEquipmentMemo(String equipmentMemo) {
        this.equipmentMemo = equipmentMemo;
    }
    /**
     * 专业分包供货内容id
     */
    public String getMajorContentId() {
        return majorContentId;
    }

    /**
     * 专业分包供货内容id
     */
    public void setMajorContentId(String majorContentId) {
        this.majorContentId = majorContentId;
    }
    /**
     * 专业分包供货内容
     */
    public String getMajorContent() {
        return majorContent;
    }

    /**
     * 专业分包供货内容
     */
    public void setMajorContent(String majorContent) {
        this.majorContent = majorContent;
    }
    /**
     * 专业分包补充描述
     */
    public String getMajorMemo() {
        return majorMemo;
    }

    /**
     * 专业分包补充描述
     */
    public void setMajorMemo(String majorMemo) {
        this.majorMemo = majorMemo;
    }
    /**
     * 劳务分包供货内容id
     */
    public String getLaborContentId() {
        return laborContentId;
    }

    /**
     * 劳务分包供货内容id
     */
    public void setLaborContentId(String laborContentId) {
        this.laborContentId = laborContentId;
    }
    /**
     * 劳务分包供货内容
     */
    public String getLaborContent() {
        return laborContent;
    }

    /**
     * 劳务分包供货内容
     */
    public void setLaborContent(String laborContent) {
        this.laborContent = laborContent;
    }
    /**
     * 劳务分包补充描述
     */
    public String getLaborMemo() {
        return laborMemo;
    }

    /**
     * 劳务分包补充描述
     */
    public void setLaborMemo(String laborMemo) {
        this.laborMemo = laborMemo;
    }
    /**
     * 分包班组供货内容id
     */
    public String getSubContentId() {
        return subContentId;
    }

    /**
     * 分包班组供货内容id
     */
    public void setSubContentId(String subContentId) {
        this.subContentId = subContentId;
    }
    /**
     * 分包班组供货内容
     */
    public String getSubContent() {
        return subContent;
    }

    /**
     * 分包班组供货内容
     */
    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }
    /**
     * 分包班组补充描述
     */
    public String getSubMemo() {
        return subMemo;
    }

    /**
     * 分包班组补充描述
     */
    public void setSubMemo(String subMemo) {
        this.subMemo = subMemo;
    }
    /**
     * 其他供货内容id
     */
    public String getOtherContentId() {
        return otherContentId;
    }

    /**
     * 其他供货内容id
     */
    public void setOtherContentId(String otherContentId) {
        this.otherContentId = otherContentId;
    }
    /**
     * 其他供货内容
     */
    public String getOtherContent() {
        return otherContent;
    }

    /**
     * 其他供货内容
     */
    public void setOtherContent(String otherContent) {
        this.otherContent = otherContent;
    }
    /**
     * 其他补充描述
     */
    public String getOtherMemo() {
        return otherMemo;
    }

    /**
     * 其他补充描述
     */
    public void setOtherMemo(String otherMemo) {
        this.otherMemo = otherMemo;
    }
    /**
     * 申请单位
     */
    public String getApplyOrgName() {
        return applyOrgName;
    }

    /**
     * 申请单位
     */
    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    /**
     * 申请单位id
     */
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    /**
     * 申请单位id
     */
    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    /**
     * 企业性质id
     */
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }

    /**
     * 企业性质id
     */
    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }
    /**
     * 企业性质名称
     */
    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    /**
     * 企业性质名称
     */
    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }

    public Long getRegisterCountryId() {
        return registerCountryId;
    }

    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }

    public String getRegisterCountryName() {
        return registerCountryName;
    }

    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }

    /**
     * 纳税人识别号/身份证号
     */
    public String getTaxpayerNum() {
        return taxpayerNum;
    }

    /**
     * 纳税人识别号/身份证号
     */
    public void setTaxpayerNum(String taxpayerNum) {
        this.taxpayerNum = taxpayerNum;
    }
    /**
     * 法人代表/别名
     */
    public String getLegalPerson() {
        return legalPerson;
    }

    /**
     * 法人代表/别名
     */
    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    /**
     * 法人电话/联系电话
     */
    public String getLegalPhone() {
        return legalPhone;
    }

    /**
     * 法人电话/联系电话
     */
    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    /**
     * 所在地区
     */
    public String getArea() {
        return area;
    }

    /**
     * 所在地区
     */
    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    /**
     * 国内外：1国内，2国外
     */
    public Integer getInOrOut() {
        return inOrOut;
    }

    /**
     * 国内外：1国内，2国外
     */
    public void setInOrOut(Integer inOrOut) {
        this.inOrOut = inOrOut;
    }
    /**
     * 公司地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 公司地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 供应商等级
     */
    public Long getGradeId() {
        return gradeId;
    }

    /**
     * 供应商等级
     */
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    /**
     * 供应商等级
     */
    public String getGradeName() {
        return gradeName;
    }

    /**
     * 供应商等级
     */
    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    /**
     * 经营范围
     */
    public String getBusinessRange() {
        return businessRange;
    }

    /**
     * 经营范围
     */
    public void setBusinessRange(String businessRange) {
        this.businessRange = businessRange;
    }
    /**
     * 准入说明
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 准入说明
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 有效期
     */
    public java.util.Date getTimeOut() {
        return timeOut;
    }

    /**
     * 有效期
     */
    public void setTimeOut(java.util.Date timeOut) {
        this.timeOut = timeOut;
    }
    /**
     * 是否协同
     */
    public Boolean getCoordination() {
        return coordination;
    }

    /**
     * 是否协同
     */
    public void setCoordination(Boolean coordination) {
        this.coordination = coordination;
    }
    /**
     * 协同姓名
     */
    public String getCoordinationName() {
        return coordinationName;
    }

    /**
     * 协同姓名
     */
    public void setCoordinationName(String coordinationName) {
        this.coordinationName = coordinationName;
    }
    /**
     * 协同手机号
     */
    public String getCoordinationPhone() {
        return coordinationPhone;
    }

    /**
     * 协同手机号
     */
    public void setCoordinationPhone(String coordinationPhone) {
        this.coordinationPhone = coordinationPhone;
    }

    public Boolean getInvestigate() {
        return investigate;
    }

    public void setInvestigate(Boolean investigate) {
        this.investigate = investigate;
    }

    public Boolean getHasInvestigate() {
        return hasInvestigate;
    }

    public void setHasInvestigate(Boolean hasInvestigate) {
        this.hasInvestigate = hasInvestigate;
    }

    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }

    public BigDecimal getRegisterMny() {
        return registerMny;
    }

    public void setRegisterMny(BigDecimal registerMny) {
        this.registerMny = registerMny;
    }

    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }

    public List<BankEntity> getBanks() {
        return banks;
    }

    public void setBanks(List<BankEntity> banks) {
        this.banks = banks;
    }

    public List<CertsEntity> getCerts() {
        return certs;
    }

    public void setCerts(List<CertsEntity> certs) {
        this.certs = certs;
    }

    public List<HistoryEntity> getHistory() {
        return history;
    }

    public void setHistory(List<HistoryEntity> history) {
        this.history = history;
    }

    public List<SubleadersEntity> getSubLeaders() {
        return subLeaders;
    }

    public void setSubLeaders(List<SubleadersEntity> subLeaders) {
        this.subLeaders = subLeaders;
    }

    public String getOcrJsonStr() {
        return ocrJsonStr;
    }

    public void setOcrJsonStr(String ocrJsonStr) {
        this.ocrJsonStr = ocrJsonStr;
    }

    public Boolean getInfoPass() {
        return infoPass;
    }

    public void setInfoPass(Boolean infoPass) {
        this.infoPass = infoPass;
    }
}
