package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.vo.AlreadyInvestigateVO;
import com.ejianc.business.pro.supplier.vo.CanInVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.InvestigateEntity;
import com.ejianc.business.pro.supplier.service.IInvestigateService;
import com.ejianc.business.pro.supplier.vo.InvestigateVO;

/**
 * 供应商考察主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("investigate")
public class InvestigateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "INVESTIGATE";//此处需要根据实际修改

    @Autowired
    private IInvestigateService service;

    @Autowired
    private ICanInService canInService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvestigateVO> saveOrUpdate(@RequestBody InvestigateVO saveorUpdateVO) {
    	InvestigateEntity entity = BeanMapper.map(saveorUpdateVO, InvestigateEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> code = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(code.isSuccess()) {
                entity.setCode(code.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	//修改供应商已考察
        CanInEntity canInEntity =canInService.getById(entity.getCanInId());
        canInEntity.setHasInvestigate(true);
    	canInService.saveOrUpdate(canInEntity);
        if(saveorUpdateVO.getSupplyQueryType().contains("material")){
            entity.setSupplyQueryType("material");
        }else if(saveorUpdateVO.getSupplyQueryType().contains("equipment")){
            entity.setSupplyQueryType("equipment");
        }else if(saveorUpdateVO.getSupplyQueryType().contains("other")){
            entity.setSupplyQueryType("other");
        }
    	service.saveOrUpdate(entity, false);
    	InvestigateVO vo = BeanMapper.map(entity, InvestigateVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvestigateVO> queryDetail(Long id) {
    	InvestigateEntity entity = service.selectById(id);
    	InvestigateVO vo = BeanMapper.map(entity, InvestigateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvestigateVO> vos) {
        service.removeByIds(vos.stream().map(InvestigateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvestigateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvestigateEntity> page = service.queryPage(param,false);
        IPage<InvestigateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvestigateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 查询列表(分页)
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryAlreadyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AlreadyInvestigateVO>> queryMyList(@RequestBody QueryParam queryParam) {

        IPage<AlreadyInvestigateVO> pageData = service.queryAlreadyList(queryParam);
        return CommonResponse.success(pageData);
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InvestigateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Investigate-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refInvestigateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InvestigateVO>> refInvestigateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InvestigateEntity> page = service.queryPage(param,false);
        IPage<InvestigateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvestigateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryStayList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> queryStayList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("materialContent");
        param.getFuzzyFields().add("applyOrgName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("applyOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("investigate", new Parameter(QueryParam.EQ, true));
        param.getParams().put("hasInvestigate", new Parameter(QueryParam.SQL, "has_investigate is not true"));

        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        IPage<CanInEntity> page = canInService.queryPage(param,false);
        IPage<CanInVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CanInVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
