package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.vo.InviteVO;

/**
 * 供应商准入邀请表
 *
 * @author generator
 */
@Controller
@RequestMapping("invite")
public class InviteController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IInviteService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdate(@RequestBody InviteVO saveOrUpdateVO) {
        InviteEntity entity = BeanMapper.map(saveOrUpdateVO, InviteEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        CommonResponse<String> exist = service.checkExist(entity.getId(),entity.getTaxpayerNum(),entity.getPersonal(),entity.getName());
        if(!exist.isSuccess()){
            return CommonResponse.error("保存失败！"+exist.getMsg());
        }
        service.saveOrUpdate(entity, false);
        InviteVO vo = BeanMapper.map(entity, InviteVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description saveOrUpdate 无鉴权新增或者修改
     */
    @RequestMapping(value = "/noAuth/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdateNoAuth(@RequestBody InviteVO saveOrUpdateVO) {
        logger.info("无鉴权新增或者修改:{}",JSONObject.toJSONString(saveOrUpdateVO));
        InviteEntity entity = BeanMapper.map(saveOrUpdateVO, InviteEntity.class);
        service.saveOrUpdate(entity, false);
        InviteVO vo = BeanMapper.map(entity, InviteVO.class);
        return CommonResponse.success("提交成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteVO> queryDetail(Long id) {
        InviteEntity entity = service.selectById(id);
        InviteVO vo = BeanMapper.map(entity, InviteVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteVO> vos) {
        service.removeByIds(vos.stream().map(InviteVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询带准入列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("taxpayer_num");
        param.getFuzzyFields().add("area_name");
        param.getFuzzyFields().add("code");

        /** 租户隔离 */
        //        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
         //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("applyOrgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("applyOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("checkResult", new Parameter(QueryParam.EQ, 1));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");

        param.setOrderMap(orderMap);
        IPage<InviteEntity> page = service.queryPage(param, false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryHandleList 查询已处理列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryHandleList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryHandleList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("taxpayer_num");
        param.getFuzzyFields().add("area_name");

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("applyOrgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("applyOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("checkResult", new Parameter(QueryParam.NE, 1));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");

        param.setOrderMap(orderMap);
        IPage<InviteEntity> page = service.queryPage(param, false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Invite-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> refInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();

        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("taxpayer_num");


        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("checkResult", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("canInNum", new Parameter(QueryParam.EQ, 0));
        param.getOrderMap().put("createTime", "desc");
        IPage<InviteEntity> page = service.queryPage(param, false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param id
     * @Description ignoreData 忽略供应商
     */
    @RequestMapping(value = "/ignoreData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteVO> ignoreData(Long id,Long userId,String userName) {
        InviteEntity entity = service.selectById(id);
        InviteVO inviteVO = BeanMapper.map(entity, InviteVO.class);
        inviteVO.setBillState(2);
        inviteVO.setHandlePerson(userName);
        inviteVO.setHandlePersonId(userId);
        inviteVO.setHandleTime(new Date());
        CommonResponse<InviteVO> inviteVOCommonResponse = saveOrUpdate(inviteVO);
        if (inviteVOCommonResponse.isSuccess()) {
            return CommonResponse.success("忽略成功！",inviteVOCommonResponse.getData());
        } else {
            return CommonResponse.error("忽略失败！");
        }
    }

    /**
     * @param ids
     * @Description ignoreDatas 批量忽略供应商
     */
    @RequestMapping(value = "/ignoreDatas", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> ignoreDatas(@RequestBody String data) {
        QueryParam param = new QueryParam();
        JSONObject json = JSONObject.parseObject(data);
        JSONArray jsonArray = json.getJSONArray("ids");
        List<Long> ids = JSONObject.parseArray(jsonArray.toJSONString(), Long.class);

        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<InviteEntity> inviteEntities = service.queryList(param);
        for (InviteEntity VO : inviteEntities) {
            VO.setBillState(2);
            VO.setHandleTime(new Date());
            VO.setHandlePerson(json.getString("userName"));
            VO.setHandlePersonId(json.getLong("userId"));
        }
        boolean b = service.saveOrUpdateBatch(inviteEntities);
        if (b) {
            return CommonResponse.success("忽略成功！");
        } else {
            return CommonResponse.error("忽略失败！");
        }
    }
}
