package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.api.IidmWebEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.util.QRCodeUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.InviteLinkEntity;
import com.ejianc.business.pro.supplier.service.IInviteLinkService;
import com.ejianc.business.pro.supplier.vo.InviteLinkVO;

/**
 * 供应商准入邀请链接
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("inviteLink")
public class InviteLinkController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IidmWebEnterpriseApi iidmWebEnterpriseApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IInviteLinkService service;

    @Autowired
    private QRCodeUtil qrCodeUtil;

    //后面包含/
    @Value("${common.env.base-host}")
    private String baseHost;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InviteLinkVO> saveOrUpdate(@RequestBody InviteLinkVO saveorUpdateVO) {
    	InviteLinkEntity entity = BeanMapper.map(saveorUpdateVO, InviteLinkEntity.class);
    	service.saveOrUpdate(entity, false);
    	InviteLinkVO vo = BeanMapper.map(entity, InviteLinkVO.class);
    	return CommonResponse.success("保存邀请信息成功！",vo);
    }

    /**
     * @Description 根据当前登录组织 查询分享链接详情11
     */
    @RequestMapping(value = "/queryLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteLinkVO> queryLink(@RequestParam("orgName") String orgName) {
        QueryParam param = new QueryParam();
        param.getParams().put("orgId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getOrgId()));
        List<InviteLinkEntity> list = service.queryList(param,false);
        InviteLinkEntity entity = new InviteLinkEntity();
        if(ListUtil.isNotEmpty(list)){
            entity = list.get(0);
        }else {
            entity.setOrgId(InvocationInfoProxy.getOrgId());
            entity.setOrgName(orgName);
            CommonResponse<EnterpriseVO> response = iidmWebEnterpriseApi.getEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
            if(response.isSuccess()){
                EnterpriseVO enterpriseVO = response.getData();
                entity.setLogoPath(enterpriseVO.getLogoPath());
                entity.setDescription(enterpriseVO.getDescription());
            }
            entity.setStartTime(new Date());
            entity.setEndTime(DateUtil.endOfMonth(new Date()));

            service.saveOrUpdateNoES(entity);
        }

    	InviteLinkVO vo = BeanMapper.map(entity, InviteLinkVO.class);
        if(vo.getEndTime().before(new Date())){
            vo.setPassTime(true);
        }else {
            vo.setPassTime(false);
        }
//        vo.setLinkUrl("http://localhost:8008/apps/prosupplier/#/invitationSupplier/no_auth/enterpriseCertificationCard?_ivt="+vo.getId());
//        vo.setQrCode(qrCodeUtil.getBase64QRCode("http://localhost:8082/#/no_auth/main/inviteIndex?_ivt="+vo.getId()));
          vo.setLinkUrl(baseHost+"/ejc-prosupplier-frontend/#/invitationSupplier/no_auth/enterpriseCertificationCard?_ivt="+vo.getId());
          vo.setQrCode(qrCodeUtil.getBase64QRCode(baseHost+"ejc-prosupplier-mobile/#/no_auth/main/inviteIndex?_ivt="+vo.getId()));

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description 无鉴权查询详情
     * @param id
     */
    @RequestMapping(value = "noAuth/queryLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteLinkVO> queryLinkNoAuth(@RequestParam("id") Long id) {
    	InviteLinkEntity entity = service.selectById(id);
    	InviteLinkVO vo = BeanMapper.map(entity, InviteLinkVO.class);
        if(vo.getEndTime().before(new Date())){
            vo.setPassTime(true);
        }else {
            vo.setPassTime(false);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteLinkVO> queryDetail(Long id) {
    	InviteLinkEntity entity = service.selectById(id);
    	InviteLinkVO vo = BeanMapper.map(entity, InviteLinkVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteLinkVO> vos) {
        service.removeByIds(vos.stream().map(InviteLinkVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InviteLinkVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InviteLinkEntity> page = service.queryPage(param,false);
        IPage<InviteLinkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteLinkVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InviteLinkEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InviteLink-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refInviteLinkData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InviteLinkVO>> refInviteLinkData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InviteLinkEntity> page = service.queryPage(param,false);
        IPage<InviteLinkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteLinkVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
