package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.ISubcontractPunishService;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.business.pro.supplier.vo.UpgradeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.service.ISubcontractUpgradeService;
import com.ejianc.business.pro.supplier.vo.SubcontractUpgradeVO;

/**
 * 分包供应评级申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subcontractUpgrade")
public class SubcontractUpgradeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISubcontractUpgradeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IGradeService gradeService;

    @Autowired
    private ISubcontractPunishService subcontractPunishService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubcontractUpgradeVO> saveOrUpdate(@RequestBody SubcontractUpgradeVO saveOrUpdateVO) {
    	SubcontractUpgradeEntity entity = BeanMapper.map(saveOrUpdateVO, SubcontractUpgradeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(getBillCode(entity),InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        GradeEntity gradeEntity =gradeService.getById(saveOrUpdateVO.getGradeId());
        GradeEntity gradeOldEntity =gradeService.getById(saveOrUpdateVO.getOldGradeId());
        if(null != gradeOldEntity) {
            if(gradeEntity.getWeight() < gradeOldEntity.getWeight()){
                return CommonResponse.error("评定等级不能小于原等级！");
            }
        }

        QueryParam param = new QueryParam();
        param.getParams().put("supplyId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getSupplyId()));
        param.getParams().put("billState",new Parameter(QueryParam.IN,"0,4"));
        param.getParams().put("supplyQueryType", new Parameter(QueryParam.EQ, saveOrUpdateVO.getSupplyQueryType()));
        List<SubcontractUpgradeEntity> list =service.queryList(param);

        if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
            return CommonResponse.error("该供应商存在未生效的单据！");
        }


        QueryParam punishParam = new QueryParam();
        punishParam.getParams().put("supplyId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getSupplyId()));
        punishParam.getParams().put("billState",new Parameter(QueryParam.IN,"0,4"));
        param.getParams().put("supplyType", new Parameter(QueryParam.EQ, saveOrUpdateVO.getSupplyQueryType()));
        List<SubcontractPunishEntity> punishList= subcontractPunishService.queryList(punishParam);
        if(ListUtil.isNotEmpty(punishList)){
            return CommonResponse.error("该供应商处置有流程尚未审批不能添加！");
        }

    	service.saveOrUpdate(entity, false);
    	SubcontractUpgradeVO vo = BeanMapper.map(entity, SubcontractUpgradeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    private String getBillCode(SubcontractUpgradeEntity entity){
        if(entity.getSubcontractType() == 0){
            if("labor".equals(entity.getSupplyQueryType())){
                return "pro-supplier-pji-lw";
            }else if("major".equals(entity.getSupplyQueryType())){
                return "pro-supplier-pji-zy";
            }
        }else {
            return "pro-supplier-pji-fbfzr";
        }
        return "pro-supplier-pji-lw";
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractUpgradeVO> queryDetail(Long id) {
    	SubcontractUpgradeEntity entity = service.selectById(id);
    	SubcontractUpgradeVO vo = BeanMapper.map(entity, SubcontractUpgradeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractUpgradeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SubcontractUpgradeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SubcontractUpgradeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubcontractUpgradeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SubcontractUpgradeEntity> page = service.queryPage(param,false);
        IPage<SubcontractUpgradeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractUpgradeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplyQueryType",new Parameter(QueryParam.EQ,SupplierQueryType.laborSub));

        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubcontractUpgradeEntity> list = service.queryList(param);
        List<SubcontractUpgradeVO> voList = new ArrayList<>();
        if(list.size()>0){
            voList = BeanMapper.mapList(list,SubcontractUpgradeVO.class);
            for (SubcontractUpgradeVO vo: voList){
                if(StringUtils.isNotEmpty(vo.getPersonal()) && vo.getPersonal().equals("e")){
                    vo.setPersonal("企业");
                }else if(StringUtils.isNotEmpty(vo.getPersonal()) && vo.getPersonal().equals("p")){
                    vo.setPersonal("个人");
                }
                if(StringUtils.isNotEmpty(vo.getGroupInOrOut()) && vo.getGroupInOrOut().equals("in")){
                    vo.setGroupInOrOut("内");
                }else if(StringUtils.isNotEmpty(vo.getGroupInOrOut()) && vo.getGroupInOrOut().equals("out")){
                    vo.setGroupInOrOut("外");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("subcontractUpgrader-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubcontractUpgradeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubcontractUpgradeVO>> refSubcontractUpgradeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubcontractUpgradeEntity> page = service.queryPage(param,false);
        IPage<SubcontractUpgradeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractUpgradeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
