package com.ejianc.business.pro.supplier.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.CertificateEntity;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.pro.supplier.service.ICertificateService;
import com.ejianc.business.pro.supplier.service.ICheckSupplierService;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.vo.CertificateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/checkSupplier")
public class CheckSupplierApi implements Serializable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    ICheckSupplierService checkSupplierService;

    @Autowired
    private ICertificateService certificateService;

    @Autowired
    private IYearService yearService;

    /**
     * @param id
     * @Description queryCheckDTO 查询校验对象
     */
    @RequestMapping(value = "/queryCheckDTO", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckSupplierDTO> queryCheckDTO(@RequestParam(value = "id") Long id) {
        CheckSupplierDTO checkSupplierDTO = checkSupplierService.queryCheckDTO(id);
        if (null != checkSupplierDTO) {
            return CommonResponse.success("查询详情数据成功！", checkSupplierDTO);
        } else {
            return CommonResponse.error("查询失败");
        }
    }

    @RequestMapping(value = "/getCertificateVOById", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<CertificateVO> getCertificateVOById(@RequestParam(value = "id") Long id) {
        CertificateEntity byId = certificateService.getById(id);
        CertificateVO certificateVO = BeanMapper.map(byId, CertificateVO.class);
        return CommonResponse.success("查询详情数据成功！", certificateVO);
    }

    @RequestMapping(value = "/queryGrade", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<Map<Long, Integer>> queryGrade(@RequestBody Map<String, List<Long>> map){
        Map<Long, Integer> resultMap = yearService.queryGrade(map);
        return CommonResponse.success(resultMap);
    }

    @PostMapping(value = "/queryTotalBranch")
    @ResponseBody
    CommonResponse<Map<Long, BigDecimal>> queryTotalBranch(@RequestBody Map<String, List<Long>> map){
        logger.info("queryTotalBranch 查询参数：{}", JSONObject.toJSONString(map));
        Map<Long, BigDecimal> resultMap = yearService.queryTotalBranch(map);
        return CommonResponse.success(resultMap);
    }
}
