package com.ejianc.business.pro.supplier.service.appraise;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service("pushProcessRuleBLogic")
public class PushProcessRuleBLogic implements IPushProcessRuleBLogic {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProcessService processService;

    private static final String BILL_CODE = "INCIDENT";//此处需要根据实际修改

    /**
     * 逻辑一
     *  查询合同池中状态为履约中的合同，当前时间-该合同上次推送评价时间（如无取合同签订时间）>=xx天
     * @param appraiseParamVO
     * @return
     */
    @Override
    public void logicOne(AppraiseParamVO appraiseParamVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, ContractPerformanceStateEnum.履约中.getStateCode()));
        List<String> contractType = new ArrayList<>();
        //调度任务中 属于劳务分包-1或分包负责人-2的标识
        String subManageFlag = appraiseParamVO.getSubManageFlag();
        if (StringUtils.isNotBlank(appraiseParamVO.getContractType())) {
            if ("material".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.物资采购合同.getTypeCode());
                contractType.add(ContractTypeEnum.混凝土合同.getTypeCode());
                contractType.add(ContractTypeEnum.周转材合同.getTypeCode());
            }
            if ("equipment".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.设备采购.getTypeCode());
                contractType.add(ContractTypeEnum.设备租赁.getTypeCode());
            }
            if ("proSub".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.专业分包合同.getTypeCode());
            }
            if ("laborSub".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.劳务分包合同.getTypeCode());
            }
            queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN, contractType));
        }

        /*queryParam.getParams().put("sourceType",new Parameter(QueryParam.IN, Arrays.asList(new String[]{ContractTypeEnum.物资采购合同.getTypeCode(),
                ContractTypeEnum.混凝土合同.getTypeCode(),ContractTypeEnum.周转材合同.getTypeCode(),ContractTypeEnum.设备采购.getTypeCode(),
                ContractTypeEnum.设备租赁.getTypeCode(),ContractTypeEnum.劳务分包合同.getTypeCode(),ContractTypeEnum.专业分包合同.getTypeCode()})));*/
        CommonResponse<List<ContractPoolVO>> listCommonResponse = contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()) {
            List<ContractPoolVO> contractPoolVOList = listCommonResponse.getData();
            logger.info("合同池查询成功=============================数量为：" + contractPoolVOList.size());
            if (CollectionUtils.isNotEmpty(contractPoolVOList)) {
                // 劳务供应商项目id、供应商id维度只能存在一条
                HashSet<String> laborPushSet = new HashSet<>();
                //当前时间-该合同上次推送评价时间（如无取合同签订时间）>=xx天
                List<ContractPoolVO> pushList = new ArrayList<>();
                for (ContractPoolVO item : contractPoolVOList) {
                    boolean laborFlag = ContractTypeEnum.劳务分包合同.getTypeCode().equals(item.getSourceType());
                    Date date = new Date();
                    QueryWrapper<IncidentEntity> wrapper = new QueryWrapper<>();
                    // 劳务供应商项目id、供应商id维度只能存在一条
                    if (laborFlag && "1".equals(subManageFlag)) {
                        String laborKey = String.valueOf(item.getProjectId()) + item.getPartybId();
                        if (laborPushSet.contains(laborKey))
                            continue;

                        wrapper.eq("project_id", item.getProjectId());
                        wrapper.eq("supply_id", item.getPartybId());

                        wrapper.orderByDesc("date");
                        //查询当前合同在过程评价表中历史数据
                        List<IncidentEntity> list = incidentService.list(wrapper);

                        //如果有历史数据，取第一条，获取评价时间
                        if (CollectionUtils.isNotEmpty(list)) {
                            date = list.get(0).getDate();
                            int days = DateUtil.differentDays(new Date(), date);
                            //计算天数
                            days = Math.abs(days);
                            if (days < appraiseParamVO.getSpaceLastDays()) {
                                laborPushSet.add(laborKey);
                                continue;
                            }
                        } else {
                            //没有，则取当前合同的合同签订时间
                            date = item.getSignDate();
                        }
                        int days = DateUtil.differentDays(new Date(), date);
                        //计算天数
                        days = Math.abs(days);
                        //天数大于等于平台设置的天数参数则推送过程评价
                        if (days >= appraiseParamVO.getSpaceLastDays()) {
                            laborPushSet.add(laborKey);
                            // 推送过程评价
                            pushList.add(item);
                        }

                    } else {


                        wrapper.eq("contract_id", item.getContractId());
                        wrapper.eq("performance_status", ContractPerformanceStateEnum.履约中.getStateCode());
                        wrapper.eq("dr", 0);
                        if (StringUtils.isNotBlank(subManageFlag)) {
                            wrapper.eq("evaluation_obj_state", subManageFlag);
                        }
                        wrapper.orderByDesc("date");
                        //查询当前合同在过程评价表中历史数据
                        List<IncidentEntity> list = incidentService.list(wrapper);

                        //如果有历史数据，取第一条，获取评价时间
                        if (CollectionUtils.isNotEmpty(list)) {
                            date = list.get(0).getDate();
                        } else {
                            //没有，则取当前合同的合同签订时间
                            date = item.getSignDate();
                        }
                        int days = DateUtil.differentDays(new Date(), date);
                        //计算天数
                        days = Math.abs(days);
                        //天数大于等于平台设置的天数参数则推送过程评价 && 如果是劳务 laborSubExistFlag =false
                        if (days >= appraiseParamVO.getSpaceLastDays()) {
                            // 推送过程评价
                            pushList.add(item);

                        }
                    }
                }

                if (pushList.size() > 0) {
                    saveIncident(pushList, subManageFlag, false);
                    logger.info("最终推送数量=============================数量为：" + pushList.size());
                }
            }
        }
    }

    /**
     * 逻辑二
     *  查询合同池中 已终止的合同并推送
     * @param appraiseParamVO
     * @return
     */
    @Override
    public void logicTwo(AppraiseParamVO appraiseParamVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, ContractPerformanceStateEnum.已终止.getStateCode()));
        List<String> contractType = new ArrayList<>();
        //调度任务中 属于劳务分包-1或分包负责人-2的标识
        String subManageFlag = appraiseParamVO.getSubManageFlag();
        if (StringUtils.isNotBlank(appraiseParamVO.getContractType())) {
            if ("material".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.物资采购合同.getTypeCode());
                contractType.add(ContractTypeEnum.混凝土合同.getTypeCode());
                contractType.add(ContractTypeEnum.周转材合同.getTypeCode());
            }
            if ("equipment".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.设备采购.getTypeCode());
                contractType.add(ContractTypeEnum.设备租赁.getTypeCode());
            }
            if ("proSub".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.专业分包合同.getTypeCode());
            }
            if ("laborSub".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.劳务分包合同.getTypeCode());
            }
            queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN, contractType));
        }

        /*queryParam.getParams().put("sourceType",new Parameter(QueryParam.IN, Arrays.asList(new String[]{ContractTypeEnum.物资采购合同.getTypeCode(),
                ContractTypeEnum.混凝土合同.getTypeCode(),ContractTypeEnum.周转材合同.getTypeCode(),ContractTypeEnum.设备采购.getTypeCode(),
                ContractTypeEnum.设备租赁.getTypeCode(),ContractTypeEnum.劳务分包合同.getTypeCode(),ContractTypeEnum.专业分包合同.getTypeCode()})));*/
        CommonResponse<List<ContractPoolVO>> listCommonResponse = contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()) {
            List<ContractPoolVO> pushList = new ArrayList<>();
            //合同池数据
            List<ContractPoolVO> conList = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(conList)) {
                //获取合同池id集合
                List<Long> contractPoolIds = conList.stream().map(ContractPoolVO::getId).collect(Collectors.toList());
                QueryParam queryIncidentParam = new QueryParam();
                queryIncidentParam.getParams().put("contractId", new Parameter(QueryParam.IN, contractPoolIds));
                queryIncidentParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, ContractPerformanceStateEnum.已终止.getStateCode()));
                if (StringUtils.isNotBlank(subManageFlag)) {
                    queryIncidentParam.getParams().put("evaluationObjState", new Parameter(QueryParam.EQ, subManageFlag));
                }
                //根据合同池id 查询否已经有状态为已终止的过程评价
                List<IncidentEntity> incidentList = incidentService.queryList(queryIncidentParam, false);
                Map<Long, IncidentEntity> map = incidentList.stream().collect(Collectors.toMap(k -> k.getContractId(), (k) -> k));
                if (incidentList.size() == 0) {
                    pushList.addAll(conList);
                } else {
                    conList.forEach(item -> {
                        if (!map.containsKey(item.getContractId())) {
                            pushList.add(item);
                        }
                    });
                }
                saveIncident(pushList, subManageFlag, false);
            }
        }
    }

    @Override
    public void checkAndPushProcessAppraise(AppraiseParamVO appraiseParamVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.IN, new String[]{ContractPerformanceStateEnum.履约中.getStateCode(),
                ContractPerformanceStateEnum.已冻结.getStateCode()}));
        List<String> contractType = new ArrayList<>();
        //调度任务中 属于劳务分包-1或分包负责人-2的标识
//        String subManageFlag = appraiseParamVO.getSubManageFlag();

        contractType.add(ContractTypeEnum.物资采购合同.getTypeCode());
        contractType.add(ContractTypeEnum.混凝土合同.getTypeCode());
        contractType.add(ContractTypeEnum.周转材合同.getTypeCode());
        contractType.add(ContractTypeEnum.设备采购.getTypeCode());
        contractType.add(ContractTypeEnum.设备租赁.getTypeCode());
        contractType.add(ContractTypeEnum.专业分包合同.getTypeCode());
        contractType.add(ContractTypeEnum.劳务分包合同.getTypeCode());
        queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN, contractType));

        queryParam.getOrderMap().put("signDate", QueryParam.ASC);

        CommonResponse<List<ContractPoolVO>> listCommonResponse = contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()) {
            List<ContractPoolVO> contractPoolVOList = listCommonResponse.getData();
            logger.info("合同池查询成功=============================数量为：" + contractPoolVOList.size());

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            //获取到当年年份
            String curYear = sdf.format(new Date());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(contractPoolVOList)) {
                // 劳务供应商项目id、供应商id维度只能存在一条
                HashSet<String> laborPushSet = new HashSet<>();
                //当前时间-该合同上次推送评价时间（如无取合同签订时间）>=xx天
                List<ContractPoolVO> pushList = new ArrayList<>();
                List<ContractPoolVO> pushWithSubLeaderList = new ArrayList<>();
                QueryWrapper<IncidentEntity> wrapper = null;
                QueryWrapper<ProcessEntity> processWrapper = null;
                for (ContractPoolVO item : contractPoolVOList) {
                    wrapper = new QueryWrapper<>();
                    processWrapper = new QueryWrapper<>();
                    boolean laborFlag = ContractTypeEnum.劳务分包合同.getTypeCode().equals(item.getSourceType());
                    // 劳务供应商项目id、供应商id维度只能存在一条
                    if (laborFlag) {
                        String laborKey = String.valueOf(item.getProjectId()) + item.getPartybId();
                        if (!laborPushSet.contains(laborKey)) {
                            wrapper.eq("project_id", item.getProjectId());
                            wrapper.eq("supply_id", item.getPartybId());
                            wrapper.eq("date_format(create_time,'%Y')",curYear);
                            wrapper.eq("evaluation_obj_state", 1); //劳务合同 只查是否存在供应商评价
                            //查询当前合同在过程评价表中历史数据
                            List<IncidentEntity> list = incidentService.list(wrapper);

                            //如果有历史数据，取第一条，获取评价时间
                            if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
                                //查询实付存在已生效的事件评价（本年度内）
                                processWrapper.eq("project_id", item.getProjectId());
                                processWrapper.eq("supply_id", item.getPartybId());
                                processWrapper.eq("date_format(create_time,'%Y')",curYear);
                                processWrapper.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),
                                        BillStateEnum.PASSED_STATE.getBillStateCode()});
                                List<ProcessEntity> processList = processService.list(processWrapper);
                                //如果有历史数据，取第一条，获取评价时间
                                if (org.apache.commons.collections.CollectionUtils.isEmpty(processList)) {
                                    laborPushSet.add(laborKey);
                                    //当前合同在 项目+供应商维度 截止推送年度评价前X天，于本年度未推送过程评价,执行推送过程评价逻辑 推送过程评价
                                    pushList.add(item);
                                } else {
                                    logger.info("合同【id-{},name-{}】存在历史供应商过程事件评价，跳过", item.getId(), item.getContractName());
                                    //已推送过，则排除
                                    laborPushSet.add(laborKey);
                                }
                            } else {
                                logger.info("合同【id-{},name-{}】存在历史过程评价，跳过。", item.getId(), item.getContractName());
                                //已推送过，则排除
                                laborPushSet.add(laborKey);
                            }
                        }
                    }

                    wrapper = new QueryWrapper<>();
                    wrapper.eq("contract_id", item.getId());
                    wrapper.in("performance_status", new String[]{ContractPerformanceStateEnum.履约中.getStateCode(),
                            ContractPerformanceStateEnum.已冻结.getStateCode()});
                    wrapper.eq("date_format(create_time,'%Y')", curYear);
                    if (laborFlag) {
                        wrapper.eq("evaluation_obj_state", 2); //劳务合同 只查是否存在分包负责人评价，其他合同查询是否存在供应商评价
                    }
                    wrapper.eq("dr", 0);
                    //查询当前合同在过程评价表中历史数据
                    List<IncidentEntity> list = incidentService.list(wrapper);
                    //如果有历史数据，取第一条，获取评价时间
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
                        logger.info("合同【id-{},name-{}】存在{}评价，跳过。", item.getId(), laborFlag ? "分包负责人" : "历史供应商过程", item.getContractName());
                        continue;
                    }

                    //查询实付存在已生效的事件评价（本年度内）
                    processWrapper.eq("contract_id", item.getId());
                    processWrapper.eq("date_format(create_time,'%Y')", curYear);
                    processWrapper.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),
                            BillStateEnum.PASSED_STATE.getBillStateCode()});

                    List<ProcessEntity> processList = processService.list(processWrapper);
                    //如果有历史数据，取第一条，获取评价时间
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(processList)) {
                        logger.info("合同【id-{},name-{}】存在历史事件评价，跳过", item.getId(), item.getContractName());
                        //已推送过，则排除
                        continue;
                    }
                    if(laborFlag) {
                        pushWithSubLeaderList.add(item);
                    } else {
                        // 当前合同在截止推送年度评价前X天，于本年度未推送过程评价,执行推送过程评价逻辑
                        pushList.add(item);
                    }
                }

                if (pushList.size() > 0) {
                    saveIncident(pushList, null, true);
                    logger.info("最终推送供应商评价数量=============================数量为：" + pushList.size());
                }
                if (pushWithSubLeaderList.size() > 0) {
                    saveIncident(pushWithSubLeaderList, "2", false);
                    logger.info("最终推送分包负责人评价数量=============================数量为：" + pushWithSubLeaderList.size());
                }
            }
        }
    }

    /**
     * 生成过程评价数据
     * @param list
     */
    public void saveIncident(List<ContractPoolVO> list, String subManageFlag, boolean byContractType) {
        List<IncidentEntity> pushList = new ArrayList<>();
        list.forEach(e -> {
            IncidentEntity entity = new IncidentEntity();
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setContractId(e.getContractId());
            entity.setPerformanceStatus(e.getPerformanceStatus());
            entity.setStatus(0);
            entity.setContractType(e.getSourceType());
            ContractTypeEnum contractTypeEnum = ContractTypeEnum.getByCode(e.getSourceType());
            if (contractTypeEnum != null) {
                String contractTypeName = ContractTypeEnum.getByCode(e.getSourceType()).getTypeName();
                entity.setContractTypeName(contractTypeName);
            }
            entity.setSupplyQueryType(SupplyQueryTypeUtil.get("RULE_B", e.getSourceType()));
            entity.setContractName(e.getContractName());
            entity.setProjectId(e.getProjectId());
            entity.setProjectName(e.getProjectName());
            entity.setContractAmount(e.getContractTaxMny());
            entity.setSupplyId(e.getPartybId());
            entity.setSupplyName(e.getPartybName());
            entity.setOrgId(e.getOrgId());
            entity.setOrgName(e.getOrgName());
            entity.setOrgCode(e.getOrgCode());
            entity.setParentOrgId(e.getParentOrgId());
            entity.setParentOrgName(e.getParentOrgName());
            entity.setParentOrgCode(e.getParentOrgCode());
            entity.setHeadUserId(e.getSupplierProjectManagerId());
            entity.setHeadUserName(e.getSupplierProjectManagerName());
            entity.setDate(new Date());
            if (ContractPerformanceStateEnum.已终止.getStateCode().equals(e.getPerformanceStatus())) {
                entity.setSource("最终结算");
            } else {
                entity.setSource("定时推送");
            }
            entity.setBuckleBranch(BigDecimal.ZERO);
            if(byContractType && ContractTypeEnum.劳务分包合同.getTypeCode().equals(e.getSourceType())) {
                entity.setEvaluationObjState(1);
                entity.setEvaluationObjName("劳务供应商");
            } else {
                if (StringUtils.isNotBlank(subManageFlag)) {
                    entity.setEvaluationObjState(Integer.parseInt(subManageFlag));
                    entity.setEvaluationObjName("2".equals(subManageFlag) ? "分包负责人" : "劳务供应商");
                }
            }

            pushList.add(entity);
        });
        if (pushList.size() > 0) {
            incidentService.saveOrUpdateBatch(pushList, pushList.size());
        }
    }

}
