package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.BankEntity;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.bean.InviteLinkEntity;
import com.ejianc.business.pro.supplier.service.IInviteLinkService;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.foundation.share.api.IBankApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

@Service("invite") 
public class InviteBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IInviteService service;
	@Autowired
	private IInviteLinkService iInviteLinkService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBankApi bankApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		InviteEntity vo = service.selectById(billId);
		return service.checkExist(billId,vo.getTaxpayerNum(),vo.getPersonal(),vo.getName());
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		InviteEntity vo = service.selectById(billId);

		SupplierVO supplierVO = BeanMapper.map(vo,SupplierVO.class);
		supplierVO.setTaxPayerIdentifier(vo.getTaxpayerNum());//纳税人识别号/身份证号
		supplierVO.setLegal(vo.getLegalPerson());//法人代表/别名
		supplierVO.setBusinessScope(vo.getBusinessRange());//经营范围
		supplierVO.setBlTime(vo.getTimeOut());//营业执照有效期
		supplierVO.setRegisterTime(vo.getRegisterDate());//注册日期
		supplierVO.setRegisteredCapital(vo.getRegisterMny());// 注册资金
		supplierVO.setSupplyQueryType(vo.getSupplyQueryType());//查询类型
		supplierVO.setName(vo.getName());
		if(!vo.getBanks().isEmpty()){
			List<BankAccountVO> list = new ArrayList<>();
			for (BankEntity bank : vo.getBanks()) {
				BankAccountVO vo1 = BeanMapper.map(bank,BankAccountVO.class);
				vo1.setDefaultFlag(bank.getDefaultable());
				vo1.setBankAddress(bank.getAddress());
				vo1.setSupplierId(bank.getPid());
				vo1.setSupplierFlag(1);
				vo1.setSupplierCode(supplierVO.getCode());
				vo1.setCategoryId(bank.getCategoryId());
				vo1.setCategoryName(bank.getCategoryName());
				vo1.setBankAccount(bank.getBankAccount());
				list.add(vo1);
			}
			supplierVO.setBanks(list);
		}
		vo.setCheckResult(1);
		service.saveOrUpdate(vo,false);
		logger.info("pushSupplierToShare----{}", JSONObject.toJSONString(supplierVO));
		bankApi.pushToBank(JSONObject.toJSONString(supplierVO).getBytes(StandardCharsets.UTF_8));


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("目前不支持弃审撤回！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
