package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.bean.PunishEntity;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

@Service("punish") 
public class PunishBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IProSupplierApi iProSupplierApi;
	@Autowired
	private IPunishService punishService;
	@Autowired
	private IAbnormalService abnormalService;
	@Autowired
	private IWarnCenterApi warnCenterApi;
	@Autowired
	private IOrgApi orgApi;
	@Autowired
	private IContractPoolApi contractPoolApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		PunishVO punishVO = new PunishVO();
		PunishEntity entity =punishService.selectById(billId);
		logger.info("PunishEntity:{}", JSONObject.toJSONString(entity));
		punishVO.setSupplierId(entity.getSupplyId());
		punishVO.setPunishType(entity.getPunishType());
		punishVO.setPunishDate(entity.getCreateTime());
		AbnormalEntity abnormalEntity= abnormalService.getById(entity.getPunishType());
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");//注意月份是MM

		try {
			if(abnormalEntity.getLastTime() != null){
				String exceptionEndDate =getLastMonthDate(entity.getCreateTime(),abnormalEntity.getLastTime());
				Date date = simpleDateFormat.parse(exceptionEndDate);
				punishVO.setExceptionEndDate(date);
			}else{
				Date date = simpleDateFormat.parse("3000-01-01");
				punishVO.setExceptionEndDate(date);
			}

		} catch (ParseException e) {
			e.printStackTrace();
		}

		punishVO.setPunishApplyOrg(entity.getApplyOrg());
		punishVO.setPunishApplyPerson(entity.getApplyPerson());
		punishVO.setPunishGrade(entity.getGradeName());
		punishVO.setPunishGradeId(entity.getGradeId());
		punishVO.setPunishOldGrade(entity.getOldGradeName());
		punishVO.setPunishMemo(entity.getMemo());
		CommonResponse<String> response =iProSupplierApi.punishSupplier(punishVO);
		if(response.isSuccess()){
			/** 触发预警消息 */
			sendMsg(entity);
			return CommonResponse.success();
		}else{
			return CommonResponse.error(response.getMsg());
		}
	}

	private void sendMsg(PunishEntity entity){
		String CODE = "WARNING000110";
		CommonResponse<WarningDTO>  response = warnCenterApi.getWarnSet(CODE,entity.getApplyOrgId());
		logger.info("查询预警中心设置：{} ",JSONObject.toJSONString(response));
		if(response.isSuccess()){
			WarningDTO orgSet = response.getData();

			QueryParam param = new QueryParam();
			param.getParams().put("partybId",new Parameter(QueryParam.EQ,entity.getSupplyId()));
			CommonResponse<List<ContractPoolVO>> commonResponse = contractPoolApi.queryList(param);
			if(commonResponse.isSuccess() && ListUtil.isNotEmpty(commonResponse.getData())){
				String sendOrgId = commonResponse.getData().stream().map(ContractPoolVO::getOrgId).map(Objects::toString).collect(Collectors.joining(","));
				EarlyWarnTransVO vo = new EarlyWarnTransVO();
				vo.setBillName(orgSet.getModuleName() + "-" + entity.getCode());
				vo.setPcTitle("供应商处置");
				vo.setOrgId(entity.getApplyOrgId());
				OrgVO orgVO = orgApi.getOneById(entity.getApplyOrgId()).getData();
				vo.setOrgName(orgVO==null?"":orgVO.getName());

				vo.setSendOrgId(sendOrgId);
				vo.setSourceId(entity.getId().toString());
				vo.setTenantId(InvocationInfoProxy.getTenantid());
				vo.setWarnSetId(orgSet.getId());
				vo.setEarlywarnName(orgSet.getName());
				vo.setWarnType(orgSet.getWarnType()+"");
				vo.setWarnLevel(orgSet.getWarningSetings().get(0).getWarningLevel());
				vo.setWarnSetParamId(orgSet.getWarningSetings().get(0).getId());
				vo.setEarlywarnContent(
						orgSet.getWarningContentTemplate().replaceAll("#supplierName#", entity.getSupplyName())
								.replaceAll("#applyOrgName#", vo.getOrgName())
								.replaceAll("#punishTypeName#", entity.getPunishTypeName())
				);
				List<EarlyWarnTransVO> earlyWarnTransVOS = new ArrayList<>();
				earlyWarnTransVOS.add(vo);
				CommonResponse<String>  warnCenterByCode = warnCenterApi.sendToWarnCenterByCode(earlyWarnTransVOS,CODE);
				logger.info("预警中心响应：{}",JSONObject.toJSONString(warnCenterByCode));
			}else {
				logger.info("合同池没找到相关供应商合同数据，不发预警！");
			}
		}
	}
	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("供应商处置不支持测回");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public static String getLastMonthDate(Date dataTime,int num)  {
		SimpleDateFormat sdf =   new SimpleDateFormat("yyyy-MM-dd");
		String date = sdf.format(dataTime);
		//时间字符串转 LocalDate 类型
		LocalDate today = LocalDate.parse(date);
		//当前月份+（-1）
		today = today.minusMonths(-num);
		//LocalDate日期格式是"YYYY-MM-DD"，只需要用toString()就可以转化成字符串类型
		return today.toString();
	}

}
