package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.vo.SubcontractCanInVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.SubcontractCanInMapper;
import com.ejianc.business.pro.supplier.service.ISubcontractCanInService;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

/**
 * 分包供应商准入表
 * 
 * @author generator
 * 
 */
@Service("subcontractCanInService")
public class SubcontractCanInServiceImpl extends BaseServiceImpl<SubcontractCanInMapper, SubcontractCanInEntity> implements ISubcontractCanInService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<String> pushSupplierToShare(SubcontractCanInEntity entity, String billTypeCode) {
        Long billId = entity.getId();
        //不需要考察 推送到共享中心
        SupplierVO supplierVO = BeanMapper.map(entity,SupplierVO.class);
        /** 生成新的供方编码 */
        supplierVO.setCode(getBillCode(entity));
        supplierVO.setTaxPayerIdentifier(entity.getTaxpayerNum());//纳税人识别号/身份证号
        supplierVO.setLegal(entity.getLegalPerson());//法人代表/别名
        supplierVO.setBusinessScope(entity.getBusinessRange());//经营范围
        supplierVO.setBlTime(entity.getTimeOut());//营业执照有效期
        supplierVO.setTenantUserName(entity.getCoordinationName());//// 协同姓名
        supplierVO.setTenantPhone(entity.getCoordinationPhone());//// 协同手机号
        supplierVO.setRegisterTime(entity.getRegisterDate());//注册日期
        supplierVO.setRegisteredCapital(entity.getRegisterMny());// 注册资金
        if(!entity.getBanks().isEmpty()){
            List<BankAccountVO> list = new ArrayList<>();
            for (BankEntity bank : entity.getBanks()) {
                BankAccountVO vo1 = BeanMapper.map(bank,BankAccountVO.class);
                vo1.setBankAddress(bank.getAddress());
                vo1.setDefaultFlag(bank.getDefaultable());
                if(vo1.getDefaultFlag() == null){
                    vo1.setDefaultFlag(0);
                }
                list.add(vo1);
            }
            supplierVO.setBanks(list);
        }
        supplierVO.setAccessId(billId);//准入id

        logger.info("billTypeCode---{}",billTypeCode);
        // 处理附件
        CommonResponse<String> fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "attachMgr",
                String.valueOf(billId), "BT200422000000028", "attachMgr");//附件
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384111794",
                String.valueOf(billId), "BT200422000000028", "K1639384111794");//法人委托授权书
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384112713",
                String.valueOf(billId), "BT200422000000028", "K1639384112713");//法人身份复印件
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384499212",
                String.valueOf(billId), "BT200422000000028", "K1639384499212");//营业执照
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384662753",
                String.valueOf(billId), "BT200422000000028", "K1639384662753");//身份证正面
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384663721",
                String.valueOf(billId), "BT200422000000028", "K1639384663721");//身份证反面
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        if(ListUtil.isNotEmpty(entity.getCerts())){
            for (CertsEntity cert : entity.getCerts()) {
                attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(cert.getId()), billTypeCode, "K1639386256873",
                        String.valueOf(cert.getId()), "BT200422000000028", "K1639386256873");//证件附件
            }
        }
        if(ListUtil.isNotEmpty(entity.getSubLeaders())){
            for (SubleadersEntity subLeader : entity.getSubLeaders()) {
                attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(subLeader.getId()), billTypeCode, "K1639443798330",
                        String.valueOf(subLeader.getId()), "BT200422000000028", "K1639443798330");//分包负责人 社保证明
            }
        }

        logger.info("pushSupplierToShare----{}", JSONObject.toJSONString(supplierVO));
        return iProSupplierApi.pushSupplierToShareZzyj(JSONObject.toJSONString(supplierVO).getBytes(StandardCharsets.UTF_8));
    }

    private String getBillCode(SubcontractCanInEntity canInEntity){
        String codeRole = "pro-supplier-code-lw";
        if("labor".equals(canInEntity.getSupplyType())){
            codeRole = "pro-supplier-code-lw";
        }else if("major".equals(canInEntity.getSupplyType())){
            codeRole =  "pro-supplier-code-zy";
        }
        BillCodeParam billCodeParam = BillCodeParam.build(codeRole, InvocationInfoProxy.getTenantid(),BeanMapper.map(canInEntity, SubcontractCanInVO.class));
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            return billCode.getData();
        }else{
            throw new BusinessException("网络异常， 编码生成供应商编码失败， 请稍后再试");
        }
    }

    @Override
    public CommonResponse<String> afterInvestigate(Long canInId, Long gradeId, String gradeName) {
        SubcontractCanInEntity canInEntity = selectById(canInId);
        canInEntity.setGradeId(gradeId);
        canInEntity.setGradeName(gradeName);
        return pushSupplierToShare(canInEntity,"BT211230000000004");

    }
}
