/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.vo.GradeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"grade"})
public class GradeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IGradeService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GradeVO> saveOrUpdate(@RequestBody GradeVO saveorUpdateVO) {
        GradeEntity entity = (GradeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, GradeEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        GradeVO vo = (GradeVO)BeanMapper.map((Object)((Object)entity), GradeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/getOneByWeight"})
    @ResponseBody
    public CommonResponse<GradeVO> getOneByWeight(@RequestParam Integer weight) {
        GradeVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"weight", (Object)weight);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List list = this.service.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = (GradeVO)BeanMapper.map(list.get(0), GradeVO.class);
        }
        return CommonResponse.success(resp);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GradeVO> queryDetail(Long id) {
        GradeEntity entity = (GradeEntity)((Object)this.service.selectById(id));
        GradeVO vo = (GradeVO)BeanMapper.map((Object)((Object)entity), GradeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GradeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (GradeVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote("BT211225000000005", vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GradeVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("weight", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GradeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<GradeVO>> list() {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("weight", "desc");
        param.setOrderMap(orderMap);
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, GradeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)voList);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Grade-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refGradeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<GradeVO>> refGradeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.getBoolean("allowInCanUse") != null) {
                param.getParams().put("allowInCanUse", new Parameter("eq", (Object)_con.getBoolean("allowInCanUse")));
            }
            if (_con.getBoolean("investigate") != null) {
                param.getParams().put("investigate", new Parameter("eq", (Object)_con.getBoolean("investigate")));
            }
            if (_con.getString("operationMap") != null) {
                Map operationMap = (Map)_con.get((Object)"operationMap");
                if (operationMap.containsKey("=")) {
                    param.getParams().put("weight", new Parameter("eq", operationMap.get("=")));
                } else if (operationMap.containsKey(">")) {
                    param.getParams().put("weight", new Parameter("gt", operationMap.get(">")));
                } else if (operationMap.containsKey("<")) {
                    param.getParams().put("weight", new Parameter("lt", operationMap.get("<")));
                } else if (operationMap.containsKey(">=")) {
                    param.getParams().put("weight", new Parameter("ge", operationMap.get(">=")));
                } else if (operationMap.containsKey("<=")) {
                    param.getParams().put("weight", new Parameter("le", operationMap.get("<=")));
                }
                param.getParams().remove("operationMap");
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GradeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getDefaultGrade"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GradeVO> getDefaultGrade(@RequestParam(value="weight") Integer weight) {
        QueryParam param = new QueryParam();
        param.getParams().put("weight", new Parameter("eq", (Object)weight));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.success((Object)BeanMapper.map(list.get(0), GradeVO.class));
        }
        return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u9ed8\u8ba4\u7b49\u7ea7\uff01");
    }
}

