/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractUpgradeEntity;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.ISubcontractPunishService;
import com.ejianc.business.pro.supplier.service.ISubcontractUpgradeService;
import com.ejianc.business.pro.supplier.vo.SubcontractUpgradeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subcontractUpgrade"})
public class SubcontractUpgradeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISubcontractUpgradeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private ISubcontractPunishService subcontractPunishService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubcontractUpgradeVO> saveOrUpdate(@RequestBody SubcontractUpgradeVO saveOrUpdateVO) {
        SubcontractUpgradeEntity entity = (SubcontractUpgradeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SubcontractUpgradeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)this.getBillCode(entity), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        GradeEntity gradeEntity = (GradeEntity)((Object)this.gradeService.getById(saveOrUpdateVO.getGradeId()));
        GradeEntity gradeOldEntity = (GradeEntity)((Object)this.gradeService.getById(saveOrUpdateVO.getOldGradeId()));
        if (null != gradeOldEntity && gradeEntity.getWeight() < gradeOldEntity.getWeight()) {
            return CommonResponse.error((String)"\u8bc4\u5b9a\u7b49\u7ea7\u4e0d\u80fd\u5c0f\u4e8e\u539f\u7b49\u7ea7\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("supplyId", new Parameter("eq", (Object)saveOrUpdateVO.getSupplyId()));
        param.getParams().put("billState", new Parameter("in", (Object)"0,4"));
        param.getParams().put("supplyQueryType", new Parameter("eq", (Object)saveOrUpdateVO.getSupplyQueryType()));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list) && ((SubcontractUpgradeEntity)((Object)list.get(0))).getId() != null && !((SubcontractUpgradeEntity)((Object)list.get(0))).getId().equals(entity.getId())) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff01");
        }
        QueryParam punishParam = new QueryParam();
        punishParam.getParams().put("supplyId", new Parameter("eq", (Object)saveOrUpdateVO.getSupplyId()));
        punishParam.getParams().put("billState", new Parameter("in", (Object)"0,4"));
        param.getParams().put("supplyType", new Parameter("eq", (Object)saveOrUpdateVO.getSupplyQueryType()));
        List punishList = this.subcontractPunishService.queryList(punishParam);
        if (ListUtil.isNotEmpty((List)punishList)) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5904\u7f6e\u6709\u6d41\u7a0b\u5c1a\u672a\u5ba1\u6279\u4e0d\u80fd\u6dfb\u52a0\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        SubcontractUpgradeVO vo = (SubcontractUpgradeVO)BeanMapper.map((Object)((Object)entity), SubcontractUpgradeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private String getBillCode(SubcontractUpgradeEntity entity) {
        if (entity.getSubcontractType() == 0) {
            if ("labor".equals(entity.getSupplyQueryType())) {
                return "pro-supplier-pji-lw";
            }
            if ("major".equals(entity.getSupplyQueryType())) {
                return "pro-supplier-pji-zy";
            }
        } else {
            return "pro-supplier-pji-fbfzr";
        }
        return "pro-supplier-pji-lw";
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractUpgradeVO> queryDetail(Long id) {
        SubcontractUpgradeEntity entity = (SubcontractUpgradeEntity)((Object)this.service.selectById(id));
        SubcontractUpgradeVO vo = (SubcontractUpgradeVO)BeanMapper.map((Object)((Object)entity), SubcontractUpgradeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractUpgradeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SubcontractUpgradeVO subcontractUpgradeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubcontractUpgradeVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractUpgradeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplyQueryType", new Parameter("eq", (Object)"laborSub"));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (list.size() > 0) {
            voList = BeanMapper.mapList((Iterable)list, SubcontractUpgradeVO.class);
            for (SubcontractUpgradeVO vo : voList) {
                if (StringUtils.isNotEmpty((CharSequence)vo.getPersonal()) && vo.getPersonal().equals("e")) {
                    vo.setPersonal("\u4f01\u4e1a");
                } else if (StringUtils.isNotEmpty((CharSequence)vo.getPersonal()) && vo.getPersonal().equals("p")) {
                    vo.setPersonal("\u4e2a\u4eba");
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getGroupInOrOut()) && vo.getGroupInOrOut().equals("in")) {
                    vo.setGroupInOrOut("\u5185");
                } else if (StringUtils.isNotEmpty((CharSequence)vo.getGroupInOrOut()) && vo.getGroupInOrOut().equals("out")) {
                    vo.setGroupInOrOut("\u5916");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("subcontractUpgrader-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubcontractUpgradeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubcontractUpgradeVO>> refSubcontractUpgradeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractUpgradeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

