/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.bean.UpgradeEntity;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.pro.supplier.service.IUpgradeService;
import com.ejianc.business.pro.supplier.vo.UpgradeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"upgrade"})
public class UpgradeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "UPGRADE-CODE";
    @Autowired
    private IUpgradeService service;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private IPunishService punishService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<UpgradeVO> saveOrUpdate(@RequestBody UpgradeVO saveorUpdateVO) {
        UpgradeEntity entity = (UpgradeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, UpgradeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse code = this.billCodeApi.getCodeBatchByRuleCode(this.getBillCode(entity), InvocationInfoProxy.getTenantid());
            if (code.isSuccess()) {
                entity.setCode((String)code.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        GradeEntity gradeEntity = (GradeEntity)((Object)this.gradeService.getById(saveorUpdateVO.getGradeId()));
        GradeEntity gradeOldEntity = (GradeEntity)((Object)this.gradeService.getById(saveorUpdateVO.getOldGradeId()));
        if (null != gradeOldEntity && gradeEntity.getWeight() < gradeOldEntity.getWeight()) {
            return CommonResponse.error((String)"\u8bc4\u5b9a\u7b49\u7ea7\u4e0d\u80fd\u5c0f\u4e8e\u539f\u7b49\u7ea7\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("supplyId", new Parameter("eq", (Object)saveorUpdateVO.getSupplyId()));
        param.getParams().put("billState", new Parameter("in", (Object)"0,4"));
        param.getParams().put("supplyQueryType", new Parameter("eq", (Object)saveorUpdateVO.getSupplyQueryType()));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list) && ((UpgradeEntity)((Object)list.get(0))).getId() != null && !((UpgradeEntity)((Object)list.get(0))).getId().equals(entity.getId())) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff01");
        }
        QueryParam punishParam = new QueryParam();
        punishParam.getParams().put("supplyId", new Parameter("eq", (Object)saveorUpdateVO.getSupplyId()));
        punishParam.getParams().put("billState", new Parameter("in", (Object)"0,4"));
        param.getParams().put("supplyType", new Parameter("eq", (Object)saveorUpdateVO.getSupplyQueryType()));
        List punishList = this.punishService.queryList(punishParam);
        if (ListUtil.isNotEmpty((List)punishList)) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5904\u7f6e\u6709\u6d41\u7a0b\u5c1a\u672a\u5ba1\u6279\u4e0d\u80fd\u6dfb\u52a0\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        UpgradeVO vo = (UpgradeVO)BeanMapper.map((Object)((Object)entity), UpgradeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private String getBillCode(UpgradeEntity entity) {
        if ("material".equals(entity.getSupplyQueryType())) {
            return "pro-supplier-pji-wz";
        }
        if ("equipment".equals(entity.getSupplyQueryType())) {
            return "pro-supplier-pji-sb";
        }
        if ("other".equals(entity.getSupplyQueryType())) {
            return "pro-supplier-pji-qt";
        }
        return "pro-supplier-pji-wz";
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UpgradeVO> queryDetail(Long id) {
        UpgradeEntity entity = (UpgradeEntity)((Object)this.service.selectById(id));
        UpgradeVO vo = (UpgradeVO)BeanMapper.map((Object)((Object)entity), UpgradeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UpgradeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UpgradeVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), UpgradeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplyQueryType", new Parameter("eq", (Object)"materialEquipment"));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (list.size() > 0) {
            voList = BeanMapper.mapList((Iterable)list, UpgradeVO.class);
            for (UpgradeVO vo : voList) {
                if (StringUtils.isNotEmpty((CharSequence)vo.getPersonal()) && vo.getPersonal().equals("e")) {
                    vo.setPersonal("\u4f01\u4e1a");
                } else if (StringUtils.isNotEmpty((CharSequence)vo.getPersonal()) && vo.getPersonal().equals("p")) {
                    vo.setPersonal("\u4e2a\u4eba");
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getGroupInOrOut()) && vo.getGroupInOrOut().equals("in")) {
                    vo.setGroupInOrOut("\u5185");
                } else if (StringUtils.isNotEmpty((CharSequence)vo.getGroupInOrOut()) && vo.getGroupInOrOut().equals("out")) {
                    vo.setGroupInOrOut("\u5916");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("upgrader-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refUpgradeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<UpgradeVO>> refUpgradeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), UpgradeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

