/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.CertificateEntity;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.pro.supplier.service.ICertificateService;
import com.ejianc.business.pro.supplier.service.ICheckSupplierService;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.vo.CertificateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/checkSupplier"})
public class CheckSupplierApi
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ICheckSupplierService checkSupplierService;
    @Autowired
    private ICertificateService certificateService;
    @Autowired
    private IYearService yearService;

    @RequestMapping(value={"/queryCheckDTO"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckSupplierDTO> queryCheckDTO(@RequestParam(value="id") Long id) {
        CheckSupplierDTO checkSupplierDTO = this.checkSupplierService.queryCheckDTO(id);
        if (null != checkSupplierDTO) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)checkSupplierDTO);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    @RequestMapping(value={"/getCertificateVOById"}, method={RequestMethod.GET})
    @ResponseBody
    CommonResponse<CertificateVO> getCertificateVOById(@RequestParam(value="id") Long id) {
        CertificateEntity byId = (CertificateEntity)((Object)this.certificateService.getById(id));
        CertificateVO certificateVO = (CertificateVO)BeanMapper.map((Object)((Object)byId), CertificateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)certificateVO);
    }

    @RequestMapping(value={"/queryGrade"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<Map<Long, Integer>> queryGrade(@RequestBody Map<String, List<Long>> map) {
        Map<Long, Integer> resultMap = this.yearService.queryGrade(map);
        return CommonResponse.success(resultMap);
    }

    @PostMapping(value={"/queryTotalBranch"})
    @ResponseBody
    CommonResponse<Map<Long, BigDecimal>> queryTotalBranch(@RequestBody Map<String, List<Long>> map) {
        this.logger.info("queryTotalBranch \u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(map));
        Map<Long, BigDecimal> resultMap = this.yearService.queryTotalBranch(map);
        return CommonResponse.success(resultMap);
    }
}

