/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.dto.SubleaderContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.vo.HeadUserVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplyVO;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.dto.HearUserDTO;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.service.ISubcontractIncidentService;
import com.ejianc.business.pro.supplier.service.ISubcontractProcessService;
import com.ejianc.business.pro.supplier.service.appraise.AppraiseStrategy;
import com.ejianc.business.pro.supplier.service.appraise.IPushProcessRuleBLogic;
import com.ejianc.business.pro.supplier.service.appraise.YearAppraiseService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.business.pro.supplier.vo.appraise.SupplyBaseVo;
import com.ejianc.business.pro.supplier.vo.appraise.SupplySubVo;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.api.IShareSubleadersApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rule_b_appraise")
public class RuleBAppraiseStrategy
implements AppraiseStrategy {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private YearAppraiseService yearAppraiseService;
    @Autowired
    IShareSupplierApi shareSupplierApi;
    @Autowired
    IShareSubleadersApi shareSubleadersApi;
    @Autowired
    IProSupplierApi proSupplierApi;
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IProcessService processService;
    @Autowired
    IPushProcessRuleBLogic pushProcessRuleBLogic;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private ISubcontractProcessService subcontractProcessService;
    @Autowired
    private ISubcontractIncidentService subcontractIncidentService;

    @Override
    public AppraiseResultVO pushProcessAppraise(AppraiseParamVO appraiseParamVO) {
        this.pushProcessRuleBLogic.logicOne(appraiseParamVO);
        this.pushProcessRuleBLogic.logicTwo(appraiseParamVO);
        AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
        return appraiseResultVO;
    }

    @Override
    public AppraiseResultVO pushYearAppraise(AppraiseParamVO appraiseParamVO) {
        HearUserDTO hearUserDTO;
        String startDate = this.yearAppraiseService.getStartDate(appraiseParamVO);
        String endDate = DateUtil.getYear() + "-" + appraiseParamVO.getYearPushDate();
        if (StringUtils.isEmpty((String)startDate)) {
            this.logger.info("\u5f53\u524d\u672a\u5230\u8bbe\u7f6e\u7684\u5468\u671f\u3002");
            return null;
        }
        if (startDate.equals(endDate)) {
            this.logger.info("\u4eca\u65e5\u5df2\u7ecf\u6267\u884c\u8fc7\u63a8\u9001\u3002");
            return null;
        }
        this.logger.info("\u63a8\u9001\u5206\u5305\u8d1f\u8d23\u4eba\u5e74\u5ea6\u8bc4\u4ef7--start");
        QueryWrapper processWrapper = new QueryWrapper();
        processWrapper.in((Object)"bill_state", new Object[]{1, 3});
        processWrapper.ge((Object)"create_time", (Object)startDate);
        processWrapper.eq((Object)"evaluation_obj_state", (Object)2);
        processWrapper.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List processlist1 = this.processService.list((Wrapper)processWrapper);
        QueryWrapper incidentWrapper = new QueryWrapper();
        incidentWrapper.in((Object)"bill_state", new Object[]{1, 3});
        incidentWrapper.eq((Object)"evaluation_obj_state", (Object)2);
        incidentWrapper.ge((Object)"create_time", (Object)startDate);
        incidentWrapper.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List incidentList1 = this.incidentService.list((Wrapper)incidentWrapper);
        List<Long> pushedHeadUserIdsOrSupplyIds = this.yearAppraiseService.getPushedHeadUserIdsOrSupplyIds(DateUtil.getYear(), null);
        HashSet<Long> headUserIdSet = new HashSet<Long>();
        HashSet<Long> contractIdsForHead = new HashSet<Long>();
        HashMap<Long, HearUserDTO> hearUserDTOMap = new HashMap<Long, HearUserDTO>();
        for (BaseEntity entity : processlist1) {
            headUserIdSet.add(entity.getHeadUserId());
            contractIdsForHead.add(entity.getContractId());
            if (hearUserDTOMap.get(entity.getHeadUserId()) != null) {
                hearUserDTO.setSumBranch(((hearUserDTO = (HearUserDTO)hearUserDTOMap.get(entity.getHeadUserId())).getSumBranch() == null ? BigDecimal.ZERO : hearUserDTO.getSumBranch()).add(entity.getBuckleBranch()));
                hearUserDTO.setSjBranch((hearUserDTO.getSjBranch() == null ? BigDecimal.ZERO : hearUserDTO.getSjBranch()).add(entity.getBuckleBranch()));
                hearUserDTOMap.put(entity.getHeadUserId(), hearUserDTO);
                continue;
            }
            hearUserDTO = new HearUserDTO();
            hearUserDTO.setSumBranch(entity.getBuckleBranch());
            hearUserDTO.setSjBranch(entity.getBuckleBranch());
            hearUserDTOMap.put(entity.getHeadUserId(), hearUserDTO);
        }
        for (BaseEntity entity : incidentList1) {
            headUserIdSet.add(entity.getHeadUserId());
            contractIdsForHead.add(entity.getContractId());
            if (hearUserDTOMap.get(entity.getHeadUserId()) != null) {
                hearUserDTO.setSumBranch(((hearUserDTO = (HearUserDTO)hearUserDTOMap.get(entity.getHeadUserId())).getSumBranch() == null ? BigDecimal.ZERO : hearUserDTO.getSumBranch()).add(entity.getBuckleBranch()));
                hearUserDTO.setGcBranch((hearUserDTO.getGcBranch() == null ? BigDecimal.ZERO : hearUserDTO.getGcBranch()).add(entity.getBuckleBranch()));
                hearUserDTOMap.put(entity.getHeadUserId(), hearUserDTO);
                continue;
            }
            hearUserDTO = new HearUserDTO();
            hearUserDTO.setSumBranch(entity.getBuckleBranch());
            hearUserDTO.setGcBranch(entity.getBuckleBranch());
            hearUserDTOMap.put(entity.getHeadUserId(), hearUserDTO);
        }
        this.logger.info("\u9700\u8981\u63a8\u9001\u7684\u5206\u5305\u8d1f\u8d23\u4ebaid\uff1a{}", headUserIdSet);
        this.logger.info("\u5df2\u63a8\u9001\u7684\u5206\u5305\u8d1f\u8d23\u4ebaid\uff1a{}", pushedHeadUserIdsOrSupplyIds);
        headUserIdSet.removeAll(pushedHeadUserIdsOrSupplyIds);
        if (CollectionUtils.isEmpty(headUserIdSet)) {
            this.logger.info("\u9700\u8981\u63a8\u9001\u7684\u5206\u5305\u8d1f\u8d23\u4ebaid\u96c6\u5408\u4e3a\u7a7a\u3002\u65e0\u9700\u63a8\u9001\uff01");
        } else {
            HashMap idsMap = new HashMap();
            idsMap.put("ids", new ArrayList(headUserIdSet));
            this.logger.info("ids:" + headUserIdSet);
            CommonResponse subleaderListCom = this.shareSubleadersApi.getSubleaderList(idsMap);
            this.logger.info("subleaderListCom:" + JSONObject.toJSONString((Object)subleaderListCom));
            if (subleaderListCom.isSuccess()) {
                List data = (List)subleaderListCom.getData();
                HashSet<Long> suplyIds = new HashSet<Long>();
                for (SubleadersVO item2 : data) {
                    suplyIds.add(item2.getPid());
                }
                Iterator map = new HashMap();
                map.put("ids", new ArrayList(suplyIds));
                CommonResponse shareSupplierList = this.proSupplierApi.queryPostSupplierByIds(map);
                HashMap<Long, SupplierVO> shareSupplierMap = new HashMap<Long, SupplierVO>();
                if (!shareSupplierList.isSuccess() || null == shareSupplierList.getData()) {
                    this.logger.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u6570\u636e\u5931\u8d25\u3002");
                    return null;
                }
                HeadUserVO headUserVO = new HeadUserVO();
                headUserVO.setContractIds(new ArrayList(contractIdsForHead));
                CommonResponse contractList = this.contractPoolApi.getContractListByHeadUser(headUserVO);
                this.logger.info("contractList:" + JSONObject.toJSONString((Object)contractList));
                if (!contractList.isSuccess() || contractList.getData() == null) {
                    this.logger.info("\u67e5\u8be2\u5408\u540c\u6c60\u6570\u636e\u5931\u8d25\uff01");
                    return null;
                }
                ArrayList<SubleaderContractDTO> contractListS = new ArrayList<SubleaderContractDTO>();
                for (Object e : (JSONArray)contractList.getData()) {
                    String str = JSONObject.toJSONString(e);
                    this.logger.info("str:" + str);
                    SubleaderContractDTO dto = (SubleaderContractDTO)JSONObject.parseObject((String)str, SubleaderContractDTO.class);
                    contractListS.add(dto);
                }
                this.logger.info("contractListS:" + JSONObject.toJSONString(contractListS));
                this.logger.info("hearUserDTOMap:" + JSONObject.toJSONString(hearUserDTOMap));
                for (SubleaderContractDTO subleaderContractDTO : contractListS) {
                    boolean b;
                    if (null != hearUserDTOMap.get(subleaderContractDTO.getHeadUserId())) {
                        HearUserDTO hearUserDTO2 = (HearUserDTO)hearUserDTOMap.get(subleaderContractDTO.getHeadUserId());
                        hearUserDTO2.setContCount(Integer.valueOf(hearUserDTO2.getContCount() + 1));
                        hearUserDTO2.addPro(subleaderContractDTO.getProjectId());
                        b = hearUserDTO2.addContractTaxMny(subleaderContractDTO.getContractTaxMny());
                        if (b) {
                            hearUserDTO2.setMaxOrgId(subleaderContractDTO.getParentOrgId());
                            hearUserDTO2.setMaxOrgName(subleaderContractDTO.getParentOrgName());
                            hearUserDTO2.setMaxOrgCode(subleaderContractDTO.getParentOrgCode());
                        }
                        hearUserDTOMap.put(subleaderContractDTO.getHeadUserId(), hearUserDTO2);
                        continue;
                    }
                    HearUserDTO hearUserDTO2 = new HearUserDTO();
                    hearUserDTO2.setContCount(Integer.valueOf(hearUserDTO2.getContCount() + 1));
                    hearUserDTO2.addPro(subleaderContractDTO.getProjectId());
                    b = hearUserDTO2.addContractTaxMny(subleaderContractDTO.getContractTaxMny());
                    if (b) {
                        hearUserDTO2.setMaxOrgId(subleaderContractDTO.getParentOrgId());
                        hearUserDTO2.setMaxOrgName(subleaderContractDTO.getParentOrgName());
                        hearUserDTO2.setMaxOrgCode(subleaderContractDTO.getParentOrgCode());
                    }
                    hearUserDTOMap.put(subleaderContractDTO.getHeadUserId(), hearUserDTO2);
                }
                this.logger.info("hearUserDTOMap####:" + JSONObject.toJSONString(hearUserDTOMap));
                List vos = BeanMapper.mapList((Iterable)((Iterable)shareSupplierList.getData()), SupplierVO.class);
                Iterator iterator = vos.iterator();
                while (iterator.hasNext()) {
                    SupplierVO item4 = (SupplierVO)iterator.next();
                    shareSupplierMap.put(item4.getId(), item4);
                }
                List<AppraiseResultVO> list = this.yearAppraiseService.calSubleader(hearUserDTOMap, data, shareSupplierMap, startDate);
                this.yearAppraiseService.sendData(list);
            }
        }
        this.logger.info("\u63a8\u9001\u5206\u5305\u8d1f\u8d23\u4eba\u5e74\u5ea6\u8bc4\u4ef7--end");
        processWrapper = new QueryWrapper();
        processWrapper.in((Object)"bill_state", new Object[]{1, 3});
        processWrapper.ge((Object)"create_time", (Object)startDate);
        incidentWrapper.apply(" (evaluation_obj_state = 1 or evaluation_obj_state is null)", new Object[0]);
        processWrapper.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List processlist = this.processService.list((Wrapper)processWrapper);
        incidentWrapper = new QueryWrapper();
        incidentWrapper.in((Object)"bill_state", new Object[]{1, 3});
        incidentWrapper.apply(" (evaluation_obj_state = 1 or evaluation_obj_state is null)", new Object[0]);
        incidentWrapper.ge((Object)"create_time", (Object)startDate);
        incidentWrapper.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List incidentList = this.incidentService.list((Wrapper)incidentWrapper);
        HashSet<Long> supplySet = new HashSet<Long>();
        HashSet<Long> contractIds = new HashSet<Long>();
        for (BaseEntity entity : processlist) {
            supplySet.add(entity.getSupplyId());
            contractIds.add(entity.getContractId());
        }
        for (BaseEntity entity : incidentList) {
            supplySet.add(entity.getSupplyId());
            contractIds.add(entity.getContractId());
        }
        supplySet.removeAll(pushedHeadUserIdsOrSupplyIds);
        if (CollectionUtils.isEmpty(supplySet)) {
            this.logger.info("\u9700\u8981\u63a8\u9001\u7684\u4f9b\u5e94\u5546id\u96c6\u5408\u4e3a\u7a7a\u3002\u65e0\u9700\u63a8\u9001\uff01");
            return null;
        }
        ArrayList<Long> supplyIds = new ArrayList<Long>(supplySet);
        this.logger.info("supplyIds:" + supplyIds);
        this.logger.info("processlist:" + JSONObject.toJSONString((Object)processlist));
        this.logger.info("incidentList:" + JSONObject.toJSONString((Object)incidentList));
        HashMap<String, ArrayList<Long>> map = new HashMap<String, ArrayList<Long>>();
        map.put("ids", supplyIds);
        CommonResponse shareSupplierList = this.proSupplierApi.queryPostSupplierByIds(map);
        String s = JSONObject.toJSONString((Object)shareSupplierList);
        this.logger.info("json:" + s);
        HashMap<Long, SupplierVO> shareSupplierMap = new HashMap<Long, SupplierVO>();
        if (!shareSupplierList.isSuccess() || null == shareSupplierList.getData()) {
            this.logger.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u6570\u636e\u5931\u8d25\u3002");
            return null;
        }
        List vos = BeanMapper.mapList((Iterable)((Iterable)shareSupplierList.getData()), SupplierVO.class);
        for (SupplierVO supplierVO : vos) {
            shareSupplierMap.put(supplierVO.getId(), supplierVO);
        }
        SupplyVO supplyVO = new SupplyVO();
        supplyVO.setContractIds(new ArrayList(contractIds));
        CommonResponse commonResponse = this.contractPoolApi.getContractList(supplyVO);
        this.logger.info("contractList:" + JSONObject.toJSONString((Object)commonResponse));
        if (!commonResponse.isSuccess() || commonResponse.getData() == null) {
            this.logger.info("\u67e5\u8be2\u5408\u540c\u6c60\u6570\u636e\u5931\u8d25\uff01");
            return null;
        }
        ArrayList<ContractDTO> contractListS = new ArrayList<ContractDTO>();
        for (Object object : (JSONArray)commonResponse.getData()) {
            String str = JSONObject.toJSONString(object);
            this.logger.info("str:" + str);
            ContractDTO dto = (ContractDTO)JSONObject.parseObject((String)str, ContractDTO.class);
            contractListS.add(dto);
        }
        Map<Long, SupplySubVo> longSupplySubVoMap = this.yearAppraiseService.sumSubGrade(processlist, incidentList);
        Map<Long, SupplyBaseVo> supplyBaseMap = this.yearAppraiseService.getSupplyResult("RULE_B", contractListS);
        List<AppraiseResultVO> appraiseResultVOList = this.yearAppraiseService.calGradeB(supplyBaseMap, shareSupplierMap, longSupplySubVoMap, supplyIds, startDate);
        this.logger.info("shareSupplierMap:" + JSONObject.toJSONString(shareSupplierMap));
        this.logger.info("longSupplySubVoMap:" + JSONObject.toJSONString(longSupplySubVoMap));
        this.logger.info("supplyBaseMap:" + JSONObject.toJSONString(supplyBaseMap));
        this.logger.info("appraiseResultVOList:" + JSONObject.toJSONString(appraiseResultVOList));
        this.yearAppraiseService.sendData(appraiseResultVOList);
        return null;
    }

    @Override
    public boolean checkAndPushProcessAppraise(AppraiseParamVO appraiseParamVO) {
        try {
            this.pushProcessRuleBLogic.checkAndPushProcessAppraise(appraiseParamVO);
            return true;
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4b\u5e76\u63a8\u9001\u8fc7\u7a0b\u8bc4\u4ef7\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
            return false;
        }
    }

    public List<Map<String, Object>> getSubGrade2(Long supplyId, String startDate, String endDate, Integer evaluationObjState, String contractType, Long headUserId) {
        QueryWrapper processWrapper = new QueryWrapper();
        processWrapper.eq((Object)"supply_id", (Object)supplyId);
        processWrapper.in((Object)"bill_state", new Object[]{1, 3});
        if (evaluationObjState != null && evaluationObjState == 2) {
            processWrapper.eq((Object)"evaluation_obj_state", (Object)evaluationObjState);
            processWrapper.eq((Object)"head_user_id", (Object)headUserId);
        } else {
            processWrapper.apply(" (evaluation_obj_state = 1 or evaluation_obj_state is null)", new Object[0]);
        }
        processWrapper.ge((Object)"create_time", (Object)startDate);
        processWrapper.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List processlist = this.subcontractProcessService.list((Wrapper)processWrapper);
        QueryWrapper incidentWrapper = new QueryWrapper();
        incidentWrapper.eq((Object)"supply_id", (Object)supplyId);
        incidentWrapper.in((Object)"bill_state", new Object[]{1, 3});
        if (evaluationObjState != null && evaluationObjState == 2) {
            incidentWrapper.eq((Object)"evaluation_obj_state", (Object)evaluationObjState);
            incidentWrapper.eq((Object)"head_user_id", (Object)headUserId);
        } else {
            incidentWrapper.apply(" (evaluation_obj_state = 1 or evaluation_obj_state is null)", new Object[0]);
        }
        incidentWrapper.ge((Object)"create_time", (Object)startDate);
        incidentWrapper.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List incidentList = this.subcontractIncidentService.list((Wrapper)incidentWrapper);
        List<Map<String, Object>> vos = this.yearAppraiseService.sumSubProGrade2(processlist, incidentList, supplyId, contractType);
        return vos;
    }
}

