/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.BankEntity;
import com.ejianc.business.pro.supplier.bean.CertsEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractCanInEntity;
import com.ejianc.business.pro.supplier.bean.SubleadersEntity;
import com.ejianc.business.pro.supplier.mapper.SubcontractCanInMapper;
import com.ejianc.business.pro.supplier.service.ISubcontractCanInService;
import com.ejianc.business.pro.supplier.vo.SubcontractCanInVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subcontractCanInService")
public class SubcontractCanInServiceImpl
extends BaseServiceImpl<SubcontractCanInMapper, SubcontractCanInEntity>
implements ISubcontractCanInService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<String> pushSupplierToShare(SubcontractCanInEntity entity, String billTypeCode) {
        Long billId = entity.getId();
        SupplierVO supplierVO = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
        supplierVO.setCode(this.getBillCode(entity));
        supplierVO.setTaxPayerIdentifier(entity.getTaxpayerNum());
        supplierVO.setLegal(entity.getLegalPerson());
        supplierVO.setBusinessScope(entity.getBusinessRange());
        supplierVO.setBlTime(entity.getTimeOut());
        supplierVO.setTenantUserName(entity.getCoordinationName());
        supplierVO.setTenantPhone(entity.getCoordinationPhone());
        supplierVO.setRegisterTime(entity.getRegisterDate());
        supplierVO.setRegisteredCapital(entity.getRegisterMny());
        if (!entity.getBanks().isEmpty()) {
            ArrayList<BankAccountVO> list = new ArrayList<BankAccountVO>();
            for (BankEntity bank : entity.getBanks()) {
                BankAccountVO vo1 = (BankAccountVO)BeanMapper.map((Object)((Object)bank), BankAccountVO.class);
                vo1.setBankAddress(bank.getAddress());
                vo1.setDefaultFlag(bank.getDefaultable());
                if (vo1.getDefaultFlag() == null) {
                    vo1.setDefaultFlag(Integer.valueOf(0));
                }
                list.add(vo1);
            }
            supplierVO.setBanks(list);
        }
        supplierVO.setAccessId(billId);
        this.logger.info("billTypeCode---{}", (Object)billTypeCode);
        CommonResponse fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "attachMgr", String.valueOf(billId), "BT200422000000028", "attachMgr");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384111794", String.valueOf(billId), "BT200422000000028", "K1639384111794");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384112713", String.valueOf(billId), "BT200422000000028", "K1639384112713");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384499212", String.valueOf(billId), "BT200422000000028", "K1639384499212");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384662753", String.valueOf(billId), "BT200422000000028", "K1639384662753");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384663721", String.valueOf(billId), "BT200422000000028", "K1639384663721");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        if (ListUtil.isNotEmpty(entity.getCerts())) {
            for (CertsEntity cert : entity.getCerts()) {
                this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(cert.getId()), billTypeCode, "K1639386256873", String.valueOf(cert.getId()), "BT200422000000028", "K1639386256873");
            }
        }
        if (ListUtil.isNotEmpty(entity.getSubLeaders())) {
            for (SubleadersEntity subLeader : entity.getSubLeaders()) {
                this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(subLeader.getId()), billTypeCode, "K1639443798330", String.valueOf(subLeader.getId()), "BT200422000000028", "K1639443798330");
            }
        }
        this.logger.info("pushSupplierToShare----{}", (Object)JSONObject.toJSONString((Object)supplierVO));
        return this.iProSupplierApi.pushSupplierToShareZzyj(JSONObject.toJSONString((Object)supplierVO).getBytes(StandardCharsets.UTF_8));
    }

    private String getBillCode(SubcontractCanInEntity canInEntity) {
        String codeRole = "pro-supplier-code-lw";
        if ("labor".equals(canInEntity.getSupplyType())) {
            codeRole = "pro-supplier-code-lw";
        } else if ("major".equals(canInEntity.getSupplyType())) {
            codeRole = "pro-supplier-code-zy";
        }
        BillCodeParam billCodeParam = BillCodeParam.build((String)codeRole, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)canInEntity), SubcontractCanInVO.class)));
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            return (String)billCode.getData();
        }
        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u4f9b\u5e94\u5546\u7f16\u7801\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @Override
    public CommonResponse<String> afterInvestigate(Long canInId, Long gradeId, String gradeName) {
        SubcontractCanInEntity canInEntity = (SubcontractCanInEntity)((Object)this.selectById(canInId));
        canInEntity.setGradeId(gradeId);
        canInEntity.setGradeName(gradeName);
        return this.pushSupplierToShare(canInEntity, "BT211230000000004");
    }
}

